/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.INumericParameterRefinementConfiguration;
import ai.libs.jaicore.components.api.INumericParameterRefinementConfigurationMap;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.model.CompositionProblemUtil;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.mlplan.metamining.pipelinecharacterizing.ComponentInstanceStringConverterIntializeException;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IOntologyConnector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import treeminer.util.TreeRepresentationUtils;

public class ComponentInstanceStringConverter
extends Thread {
    private static final String WEKA_LABEL_FILE = "weka-labels.properties";
    private static final Logger log = LoggerFactory.getLogger(ComponentInstanceStringConverter.class);
    private String pipelineTreeName = "0";
    private IOntologyConnector ontologyConnector;
    private List<IComponentInstance> cIs;
    private Properties wekaLabels;
    private List<String> convertedPipelines;
    private INumericParameterRefinementConfigurationMap componentParameters;

    public ComponentInstanceStringConverter(IOntologyConnector ontologyConnector, List<? extends IComponentInstance> cIs, INumericParameterRefinementConfigurationMap componentParameters) {
        this.ontologyConnector = ontologyConnector;
        this.cIs = new ArrayList<IComponentInstance>(cIs);
        this.convertedPipelines = new ArrayList<String>(cIs.size());
        this.componentParameters = componentParameters;
        InputStream fis = this.getClass().getClassLoader().getResourceAsStream(WEKA_LABEL_FILE);
        this.wekaLabels = new Properties();
        try {
            this.wekaLabels.load(fis);
        }
        catch (IOException e) {
            log.warn("Could not load weka labels.");
            throw new ComponentInstanceStringConverterIntializeException(e);
        }
    }

    @Override
    public void run() {
        for (IComponentInstance cI : this.cIs) {
            String pipeline = this.makeStringTreeRepresentation(cI);
            this.convertedPipelines.add(pipeline);
        }
    }

    public String makeStringTreeRepresentation(IComponentInstance pipeline) {
        IComponentInstance classifierCI;
        ArrayList<String> pipelineBranches = new ArrayList<String>();
        if (pipeline == null) {
            log.warn("Try to characterize a null pipeline");
            return null;
        }
        if (pipeline.getComponent().getName().equals("pipeline")) {
            IComponentInstance preprocessorCI = (IComponentInstance)pipeline.getSatisfactionOfRequiredInterface("preprocessor").iterator().next();
            if (preprocessorCI != null) {
                this.addCharacterizationOfPipelineElement(pipelineBranches, (IComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterface("search").iterator().next());
                this.addCharacterizationOfPipelineElement(pipelineBranches, (IComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterface("eval").iterator().next());
            }
            classifierCI = (IComponentInstance)pipeline.getSatisfactionOfRequiredInterface("classifier").iterator().next();
        } else {
            classifierCI = pipeline;
        }
        this.addCharacterizationOfPipelineElement(pipelineBranches, classifierCI);
        String toReturn = TreeRepresentationUtils.addChildrenToNode((String)this.pipelineTreeName, pipelineBranches);
        if (this.wekaLabels != null) {
            Pattern p = Pattern.compile(" ");
            return p.splitAsStream(toReturn).filter(s -> !"".equals(s)).map(s -> this.wekaLabels.getProperty((String)s, (String)s)).collect(Collectors.joining(" "));
        }
        log.error("Did not find label property mapper.");
        throw new IllegalStateException();
    }

    protected void addCharacterizationOfPipelineElement(List<String> pipelineBranches, IComponentInstance componentInstance) {
        if (componentInstance != null) {
            String wekaName = componentInstance.getComponent().getName();
            List<String> branchComponents = this.ontologyConnector.getAncestorsOfAlgorithm(wekaName);
            branchComponents.set(branchComponents.size() - 1, TreeRepresentationUtils.addChildrenToNode((String)branchComponents.get(branchComponents.size() - 1), this.getParametersForComponentInstance(componentInstance)));
            String branch = TreeRepresentationUtils.makeRepresentationForBranch(branchComponents);
            pipelineBranches.add(branch);
        }
    }

    protected List<String> getParametersForComponentInstance(IComponentInstance componentInstance) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (componentInstance.getSatisfactionOfRequiredInterfaces() != null && componentInstance.getSatisfactionOfRequiredInterfaces().size() > 0) {
            componentInstance.getSatisfactionOfRequiredInterfaces().forEach((requiredInterface, component) -> {
                ArrayList<String> kernelFunctionCharacterisation = new ArrayList<String>();
                kernelFunctionCharacterisation.add((String)requiredInterface);
                kernelFunctionCharacterisation.addAll(this.ontologyConnector.getAncestorsOfAlgorithm(((IComponentInstance)component.iterator().next()).getComponent().getName()));
                parameters.add(TreeRepresentationUtils.addChildrenToNode((String)requiredInterface, Arrays.asList(TreeRepresentationUtils.makeRepresentationForBranch(kernelFunctionCharacterisation))));
            });
        }
        for (IParameter parameter : componentInstance.getComponent().getParameters()) {
            String parameterName = parameter.getName();
            if (!componentInstance.getParameterValues().containsKey(parameterName)) continue;
            ArrayList<String> parameterRefinement = new ArrayList<String>();
            parameterRefinement.add(parameterName);
            if (parameter.isNumeric()) {
                this.resolveNumericParameter(componentInstance, parameter, parameterName, parameterRefinement);
            } else if (parameter.isCategorical()) {
                parameterRefinement.add((String)componentInstance.getParameterValues().get(parameterName));
            }
            parameters.add(TreeRepresentationUtils.makeRepresentationForBranch(parameterRefinement));
        }
        return parameters;
    }

    private void resolveNumericParameter(IComponentInstance componentInstance, IParameter parameter, String parameterName, List<String> parameterRefinement) {
        INumericParameterRefinementConfiguration parameterRefinementConfiguration = this.componentParameters.getRefinement(componentInstance.getComponent(), parameter);
        NumericParameterDomain parameterDomain = (NumericParameterDomain)parameter.getDefaultDomain();
        Interval currentInterval = null;
        Interval nextInterval = new Interval(parameterDomain.getMin(), parameterDomain.getMax());
        double parameterValue = Double.parseDouble((String)componentInstance.getParameterValues().get(parameterName));
        double precision = parameterValue == 0.0 ? 0.0 : Math.ulp(parameterValue);
        block0: while (true) {
            Interval interval;
            currentInterval = nextInterval;
            parameterRefinement.add(this.serializeInterval(currentInterval));
            List refinement = CompositionProblemUtil.getNumericParameterRefinement((Interval)nextInterval, (double)parameterValue, (boolean)parameterDomain.isInteger(), (INumericParameterRefinementConfiguration)parameterRefinementConfiguration);
            if (refinement.isEmpty()) break;
            Iterator iterator = refinement.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while ((interval = (Interval)iterator.next()).checkPoint(parameterValue, precision) != Region.Location.INSIDE && interval.checkPoint(parameterValue, precision) != Region.Location.BOUNDARY);
            nextInterval = interval;
        }
        parameterRefinement.add(String.valueOf(parameterValue));
    }

    protected String serializeInterval(Interval interval) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(interval.getInf());
        builder.append(",");
        builder.append(interval.getSup());
        builder.append("]");
        return builder.toString();
    }

    public List<String> getConvertedPipelines() {
        return this.convertedPipelines;
    }
}

