/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.similaritymeasures;

import ai.libs.mlplan.metamining.similaritymeasures.IRelativeRankMatrixComputer;
import ai.libs.mlplan.metamining.similaritymeasures.ISignificanceTest;
import ai.libs.mlplan.metamining.similaritymeasures.MannWhitneyUSignificance;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class RelativeRankMatricComputer
implements IRelativeRankMatrixComputer {
    private ISignificanceTest significanceTest;

    public RelativeRankMatricComputer() {
        this(new MannWhitneyUSignificance());
    }

    public RelativeRankMatricComputer(ISignificanceTest significanceTest) {
        this.significanceTest = significanceTest;
    }

    @Override
    public INDArray computeRelativeRankMatrix(double[][][] performanceValues) {
        double[][] significances = new double[performanceValues.length][performanceValues[1].length];
        for (int i = 0; i < performanceValues.length; ++i) {
            for (int j = 0; j < performanceValues[i].length; ++j) {
                double score = 0.0;
                if (performanceValues[i][j] != null && performanceValues[i][j].length > 0) {
                    for (int k = 0; k < performanceValues[i].length; ++k) {
                        if (performanceValues[i][k] != null && performanceValues[i][k].length > 0) {
                            double significance = this.significanceTest.computeSignificance(performanceValues[i][j], performanceValues[i][k]);
                            if (significance < 0.05) {
                                double mean2;
                                double mean1 = Arrays.stream(performanceValues[i][j]).average().orElse(Double.NaN);
                                if (!(mean1 > (mean2 = Arrays.stream(performanceValues[i][k]).average().orElse(Double.NaN)))) continue;
                                score += 1.0;
                                continue;
                            }
                            score += 0.5;
                            continue;
                        }
                        score += 1.0;
                    }
                }
                significances[i][j] = score;
            }
        }
        return Nd4j.create((double[][])significances);
    }
}

