/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.single;

import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.ml.classification.loss.dataset.EClassificationPerformanceMeasure;
import ai.libs.jaicore.ml.core.evaluation.evaluator.FixedSplitClassifierEvaluator;
import ai.libs.jaicore.ml.core.evaluation.evaluator.MonteCarloCrossValidationEvaluator;
import ai.libs.jaicore.ml.weka.WekaUtil;
import ai.libs.jaicore.ml.weka.classification.learner.WekaClassifier;
import ai.libs.jaicore.ml.weka.classification.learner.reduction.MCTreeNodeReD;
import ai.libs.jaicore.ml.weka.classification.learner.reduction.splitter.ISplitter;
import ai.libs.jaicore.ml.weka.classification.learner.reduction.splitter.ISplitterFactory;
import ai.libs.jaicore.ml.weka.dataset.IWekaInstances;
import ai.libs.jaicore.ml.weka.dataset.WekaInstances;
import ai.libs.reduction.single.ReductionExperiment;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ExperimentRunner<T extends ISplitter> {
    private final int k;
    private final int mccvRepeats;
    private final ISplitterFactory<T> splitterFactory;
    private final Logger logger = LoggerFactory.getLogger(ExperimentRunner.class);

    public ExperimentRunner(int k, int mccvRepeats, ISplitterFactory<T> splitterFactory) {
        this.k = k;
        this.mccvRepeats = mccvRepeats;
        this.splitterFactory = splitterFactory;
    }

    public Map<String, Object> conductSingleOneStepReductionExperiment(ReductionExperiment experiment) throws Exception {
        Instances instances = new Instances((Reader)new BufferedReader(new FileReader(experiment.getDataset())));
        instances.setClassIndex(instances.numAttributes() - 1);
        WekaInstances data = new WekaInstances(instances);
        int seed = experiment.getSeed();
        Classifier leftClassifier = AbstractClassifier.forName((String)experiment.getNameOfLeftClassifier(), null);
        Classifier innerClassifier = AbstractClassifier.forName((String)experiment.getNameOfInnerClassifier(), null);
        Classifier rightClassifier = AbstractClassifier.forName((String)experiment.getNameOfRightClassifier(), null);
        List outerSplit = WekaUtil.getStratifiedSplit((IWekaInstances)data, (long)experiment.getSeed(), (double)0.7);
        MonteCarloCrossValidationEvaluator mccv = new MonteCarloCrossValidationEvaluator((ILabeledDataset)new WekaInstances((ILabeledDataset)data), this.mccvRepeats, 0.7, new Random(seed));
        ISplitter splitter = this.splitterFactory.getSplitter(seed);
        MCTreeNodeReD bestFoundClassifier = null;
        double bestFoundScore = Double.MAX_VALUE;
        for (int i = 0; i < this.k; ++i) {
            ArrayList classSplit;
            try {
                classSplit = new ArrayList(splitter.split(((IWekaInstances)outerSplit.get(0)).getInstances()));
            }
            catch (Exception e) {
                throw new ExperimentEvaluationFailedException("Could not create a split.", (Throwable)e);
            }
            MCTreeNodeReD classifier = new MCTreeNodeReD(innerClassifier, (Collection)classSplit.get(0), leftClassifier, (Collection)classSplit.get(1), rightClassifier);
            double loss = (Double)mccv.evaluate((Object)new WekaClassifier((Classifier)classifier));
            this.logger.info("\t\t\tComputed loss {}", (Object)loss);
            if (!(loss < bestFoundScore)) continue;
            bestFoundScore = loss;
            bestFoundClassifier = classifier;
        }
        double loss = new FixedSplitClassifierEvaluator((ILabeledDataset)outerSplit.get(0), (ILabeledDataset)outerSplit.get(1), (IDeterministicPredictionPerformanceMeasure)EClassificationPerformanceMeasure.ERRORRATE).evaluate((ISupervisedLearner)new WekaClassifier(bestFoundClassifier));
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.logger.info("\t\t\tBest previously observed loss was {}. The retrained classifier achieves {} on the full data.", (Object)bestFoundScore, (Object)loss);
        result.put("errorRate", loss);
        return result;
    }
}

