/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclasswithreduction;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ClassSplit<T> {
    private final Collection<T> classes;
    private final Collection<T> l;
    private final Collection<T> r;

    public ClassSplit(Collection<T> classes, Collection<T> l, Collection<T> r) {
        this.classes = classes;
        this.l = l;
        this.r = r;
    }

    public ClassSplit(ClassSplit<T> split) {
        this(split.getClasses(), new ArrayList<T>(split.getL()), new ArrayList<T>(split.getR()));
    }

    public Collection<T> getClasses() {
        return this.classes;
    }

    public Collection<T> getL() {
        return this.l;
    }

    public Collection<T> getR() {
        return this.r;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.classes).append(this.l).append(this.r).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassSplit)) {
            return false;
        }
        ClassSplit other = (ClassSplit)obj;
        return new EqualsBuilder().append(other.classes, this.classes).append(other.l, this.l).append(other.r, this.r).isEquals();
    }

    public String toString() {
        return "ClassSplit [classes=" + this.classes + ", l=" + this.l + ", r=" + this.r + "]";
    }
}

