/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclasswithreduction;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.theories.set.SetTheoryUtil;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCAction;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.ceociptfd.OracleTaskResolver;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.mlplan.multiclasswithreduction.ClassSplit;
import ai.libs.mlplan.multiclasswithreduction.NestedDichotomyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public class RPNDOracleTaskSolver
implements OracleTaskResolver {
    private static final Logger logger = LoggerFactory.getLogger(RPNDOracleTaskSolver.class);
    private final Random rand;
    private final String classifierName;
    private final Instances data;
    private CEOCOperation configChildNodesOp;

    public RPNDOracleTaskSolver(Random rand, String classifierName, Instances data, CEOCIPSTNPlanningProblem problem) {
        this.rand = rand;
        this.classifierName = classifierName;
        this.data = data;
        for (CEOCOperation op : problem.getDomain().getOperations()) {
            if (!op.getName().equals("configChildNodes")) continue;
            this.configChildNodesOp = op;
            break;
        }
        if (this.configChildNodesOp == null) {
            throw new IllegalArgumentException("Domain has no operation with name \"configChildNodes\"");
        }
    }

    public Collection<List<Action>> getSubSolutions(Monom state, Literal task) throws Exception {
        String nameOfParent = ((ConstantParam)task.getConstantParams().get(0)).getName();
        String nameOfLC = ((ConstantParam)task.getConstantParams().get(1)).getName();
        String nameOfRC = ((ConstantParam)task.getConstantParams().get(2)).getName();
        HashMap<VariableParam, ConstantParam> groundingTemplate = new HashMap<VariableParam, ConstantParam>();
        groundingTemplate.put(new VariableParam("p"), new ConstantParam(nameOfParent));
        groundingTemplate.put(new VariableParam("lc"), new ConstantParam(nameOfLC));
        groundingTemplate.put(new VariableParam("rc"), new ConstantParam(nameOfRC));
        ArrayList<String> set = new ArrayList<String>(SetTheoryUtil.getObjectsInSet((Monom)state, (String)nameOfParent));
        logger.info("Compute RPND split for {}", set);
        if (set.size() <= 1) {
            return new ArrayList<List<Action>>();
        }
        if (set.size() == 2) {
            ArrayList<List<Action>> subsolutions = new ArrayList<List<Action>>();
            HashMap<VariableParam, ConstantParam> grounding = new HashMap<VariableParam, ConstantParam>(groundingTemplate);
            grounding.put(new VariableParam("ss"), new ConstantParam("{" + (String)set.get(0) + "}"));
            ArrayList<CEOCAction> subsolution = new ArrayList<CEOCAction>();
            subsolution.add(new CEOCAction(this.configChildNodesOp, grounding));
            subsolutions.add(subsolution);
            return subsolutions;
        }
        ArrayList<RPNDSplitter> splitters = new ArrayList<RPNDSplitter>();
        int max = 1;
        logger.info("Make {} suggestions for {} classes", (Object)max, (Object)set.size());
        for (int i = 0; i < max; ++i) {
            splitters.add(new RPNDSplitter(this.data));
        }
        ArrayList<List<Action>> subsolutions = new ArrayList<List<Action>>();
        for (Splitter splitter : splitters) {
            logger.info("Compute next split");
            Split split = splitter.split(set);
            logger.info("Split computed: {}", (Object)split);
            HashMap<VariableParam, ConstantParam> grounding = new HashMap<VariableParam, ConstantParam>(groundingTemplate);
            grounding.put(new VariableParam("ss"), new ConstantParam(SetUtil.serializeAsSet((Collection)((Collection)split.getX()))));
            ArrayList<CEOCAction> subsolution = new ArrayList<CEOCAction>();
            subsolution.add(new CEOCAction(this.configChildNodesOp, grounding));
            subsolutions.add(subsolution);
        }
        logger.info("Ready with RPND computation");
        return subsolutions;
    }

    private class RPNDSplitter
    implements Splitter {
        private final Instances data;

        public RPNDSplitter(Instances data) {
            this.data = data;
        }

        @Override
        public Split split(Collection<String> set) throws InterruptedException {
            ClassSplit<String> split = NestedDichotomyUtil.createGeneralRPNDBasedSplit(set, RPNDOracleTaskSolver.this.rand, RPNDOracleTaskSolver.this.classifierName, this.data);
            return new Split(new HashSet<String>(split.getL()), new HashSet<String>(split.getR()));
        }
    }

    class SplitException
    extends Exception {
        public SplitException(Exception e) {
            super(e);
        }
    }

    class Split
    extends Pair<Set<String>, Set<String>> {
        public Split(Set<String> x, Set<String> y) {
            super(x, y);
        }

        public String toString() {
            return "Split [getX()=" + this.getX() + ", getY()=" + this.getY() + "]";
        }
    }

    private static interface Splitter {
        public Split split(Collection<String> var1) throws InterruptedException;
    }
}

