/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction;

import ai.libs.jaicore.ml.weka.WekaUtil;
import ai.libs.jaicore.ml.weka.classification.learner.reduction.MCTreeNodeReD;
import ai.libs.jaicore.ml.weka.classification.learner.reduction.splitter.RPNDSplitter;
import ai.libs.reduction.ensemble.simple.EnsembleOfSimpleOneStepReductionsExperiment;
import ai.libs.reduction.single.ReductionExperiment;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.Vote;
import weka.core.Instances;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final String LABEL_TRAIN_TIME = "trainTime";

    private Util() {
    }

    public static List<Map<String, Object>> conductSingleOneStepReductionExperiment(ReductionExperiment experiment) throws Exception {
        Instances data = new Instances((Reader)new BufferedReader(new FileReader(experiment.getDataset())));
        data.setClassIndex(data.numAttributes() - 1);
        int seed = experiment.getSeed();
        Classifier classifierForRPNDSplit = AbstractClassifier.forName((String)experiment.getNameOfInnerClassifier(), null);
        Classifier leftClassifier = AbstractClassifier.forName((String)experiment.getNameOfLeftClassifier(), null);
        Classifier innerClassifier = AbstractClassifier.forName((String)experiment.getNameOfInnerClassifier(), null);
        Classifier rightClassifier = AbstractClassifier.forName((String)experiment.getNameOfRightClassifier(), null);
        RPNDSplitter splitter = new RPNDSplitter(new Random(seed), classifierForRPNDSplit);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (int k = 0; k < 10; ++k) {
            ArrayList classSplit;
            try {
                classSplit = new ArrayList(splitter.split(data));
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create RPND split.", e);
            }
            MCTreeNodeReD classifier = new MCTreeNodeReD(innerClassifier, (Collection)classSplit.get(0), leftClassifier, (Collection)classSplit.get(1), rightClassifier);
            long start = System.currentTimeMillis();
            HashMap<String, Number> result = new HashMap<String, Number>();
            List dataSplit = WekaUtil.getStratifiedSplit((Instances)data, (long)(seed + k), (double)0.7);
            classifier.buildClassifier((Instances)dataSplit.get(0));
            long time = System.currentTimeMillis() - start;
            Evaluation eval = new Evaluation((Instances)dataSplit.get(0));
            eval.evaluateModel((Classifier)classifier, (Instances)dataSplit.get(1), new Object[0]);
            double loss = (100.0 - eval.pctCorrect()) / 100.0;
            logger.info("Conducted experiment {} with split {}/{}. Loss: {}. Time: {}ms.", new Object[]{k, classSplit.get(0), classSplit.get(1), loss, time});
            result.put("errorRate", loss);
            result.put(LABEL_TRAIN_TIME, time);
            results.add(result);
        }
        return results;
    }

    public static List<Map<String, Object>> conductEnsembleOfOneStepReductionsExperiment(EnsembleOfSimpleOneStepReductionsExperiment experiment) throws Exception {
        Instances data = new Instances((Reader)new BufferedReader(new FileReader(experiment.getDataset())));
        data.setClassIndex(data.numAttributes() - 1);
        int seed = experiment.getSeed();
        String classifier = experiment.getNameOfClassifier();
        RPNDSplitter splitter = new RPNDSplitter(new Random(seed), AbstractClassifier.forName((String)classifier, null));
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (int k = 0; k < 10; ++k) {
            Vote ensemble = new Vote();
            ensemble.setOptions(new String[]{"-R", "MAJ"});
            long start = System.currentTimeMillis();
            List dataSplit = WekaUtil.getStratifiedSplit((Instances)data, (long)(seed + k), (double)0.7);
            for (int i = 0; i < experiment.getNumberOfStumps(); ++i) {
                ArrayList classSplit = new ArrayList(splitter.split(data));
                MCTreeNodeReD tree = new MCTreeNodeReD(classifier, (Collection)classSplit.get(0), classifier, (Collection)classSplit.get(1), classifier);
                tree.buildClassifier((Instances)dataSplit.get(0));
                ensemble.addPreBuiltClassifier((Classifier)tree);
            }
            HashMap<String, Number> result = new HashMap<String, Number>();
            result.put(LABEL_TRAIN_TIME, System.currentTimeMillis() - start);
            ensemble.buildClassifier(data);
            Evaluation eval = new Evaluation((Instances)dataSplit.get(0));
            eval.evaluateModel((Classifier)ensemble, (Instances)dataSplit.get(1), new Object[0]);
            double loss = (100.0 - eval.pctCorrect()) / 100.0;
            logger.info("Conducted experiment {}. Loss: {}. Time: {}ms.", new Object[]{k, loss, result.get(LABEL_TRAIN_TIME)});
            result.put("errorRate", loss);
            results.add(result);
        }
        return results;
    }
}

