/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.ensemble.simple;

import ai.libs.jaicore.db.IDatabaseAdapter;
import ai.libs.jaicore.db.IDatabaseConfig;
import ai.libs.jaicore.db.sql.DatabaseAdapterFactory;
import ai.libs.reduction.Util;
import ai.libs.reduction.ensemble.simple.EnsembleOfSimpleOneStepReductionsExperiment;
import ai.libs.reduction.ensemble.simple.MySQLEnsembleOfSimpleOneStepReductionsExperiment;
import java.io.File;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aeonbits.owner.ConfigFactory;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLEnsembleOfSimpleOneStepReductionsExperimentRunner {
    private static final String KEY_ERROR_RATE = "errorRate";
    private static final String TABLE_NAME = "homogeneousensemblesofreductionstumps";
    private final IDatabaseAdapter adapter;
    private final Collection<MySQLEnsembleOfSimpleOneStepReductionsExperiment> knownExperiments = new HashSet<MySQLEnsembleOfSimpleOneStepReductionsExperiment>();
    private final Logger logger = LoggerFactory.getLogger(MySQLEnsembleOfSimpleOneStepReductionsExperimentRunner.class);

    public MySQLEnsembleOfSimpleOneStepReductionsExperimentRunner(String host, String user, String password, String database) throws SQLException {
        IDatabaseConfig config = (IDatabaseConfig)ConfigFactory.create(IDatabaseConfig.class, (Map[])new Map[0]);
        config.setProperty("db.host", host);
        config.setProperty("db.username", user);
        config.setProperty("db.password", password);
        config.setProperty("db.database", database);
        this.adapter = DatabaseAdapterFactory.get((IDatabaseConfig)config);
        this.knownExperiments.addAll(this.getConductedExperiments());
    }

    public Collection<MySQLEnsembleOfSimpleOneStepReductionsExperiment> getConductedExperiments() throws SQLException {
        HashSet<MySQLEnsembleOfSimpleOneStepReductionsExperiment> experiments = new HashSet<MySQLEnsembleOfSimpleOneStepReductionsExperiment>();
        List rs = this.adapter.getRowsOfTable(TABLE_NAME);
        for (IKVStore store : rs) {
            experiments.add(new MySQLEnsembleOfSimpleOneStepReductionsExperiment(store.getAsInt("evaluation_id"), new EnsembleOfSimpleOneStepReductionsExperiment(store.getAsInt("seed"), store.getAsString("dataset"), store.getAsString("classifier"), store.getAsInt("size"), store.getAsDouble(KEY_ERROR_RATE), store.getAsString("exception"))));
        }
        return experiments;
    }

    public MySQLEnsembleOfSimpleOneStepReductionsExperiment createAndGetExperimentIfNotConducted(int seed, File dataFile, String nameOfClassifier, int size) throws SQLException {
        EnsembleOfSimpleOneStepReductionsExperiment exp = new EnsembleOfSimpleOneStepReductionsExperiment(seed, dataFile.getAbsolutePath(), nameOfClassifier, size);
        Optional<MySQLEnsembleOfSimpleOneStepReductionsExperiment> existingExperiment = this.knownExperiments.stream().filter(e -> e.getExperiment().equals(exp)).findAny();
        if (existingExperiment.isPresent()) {
            return null;
        }
        if (this.canInfeasibilityBeDerived(this.knownExperiments, exp)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seed", String.valueOf(seed));
        map.put("dataset", dataFile.getAbsolutePath());
        map.put("classifier", nameOfClassifier);
        map.put("size", size);
        int[] id = this.adapter.insert(TABLE_NAME, map);
        return new MySQLEnsembleOfSimpleOneStepReductionsExperiment(id[0], exp);
    }

    private void updateExperiment(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp, Map<String, ? extends Object> values) throws SQLException {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("evaluation_id", String.valueOf(exp.getId()));
        this.adapter.update(TABLE_NAME, values, where);
    }

    public void conductExperiment(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp) throws Exception {
        List<Map<String, Object>> mccvResults = Util.conductEnsembleOfOneStepReductionsExperiment(exp.getExperiment());
        DescriptiveStatistics errorRate = new DescriptiveStatistics();
        DescriptiveStatistics runtime = new DescriptiveStatistics();
        for (Map<String, Object> result : mccvResults) {
            errorRate.addValue(((Double)result.get(KEY_ERROR_RATE)).doubleValue());
            runtime.addValue((double)((Long)result.get("trainTime")).longValue());
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put(KEY_ERROR_RATE, errorRate.getMean());
        this.updateExperiment(exp, values);
    }

    public void markExperimentAsUnsolvable(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : new String[]{KEY_ERROR_RATE}) {
            values.put(key, "-1");
        }
        this.updateExperiment(exp, values);
    }

    public void associateExperimentWithException(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp, Throwable e) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : new String[]{KEY_ERROR_RATE}) {
            values.put(key, "-1");
        }
        values.put("exception", e.getClass().getName() + "\n" + e.getMessage());
        this.updateExperiment(exp, values);
    }

    private boolean canInfeasibilityBeDerived(Collection<MySQLEnsembleOfSimpleOneStepReductionsExperiment> experimentsWithResults, EnsembleOfSimpleOneStepReductionsExperiment experimentInQuestion) {
        for (MySQLEnsembleOfSimpleOneStepReductionsExperiment knownExperiment : experimentsWithResults) {
            EnsembleOfSimpleOneStepReductionsExperiment re;
            if (!knownExperiment.getExperiment().getDataset().equals(experimentInQuestion.getDataset()) || (re = knownExperiment.getExperiment()).getException() == null || !re.getNameOfClassifier().equals(experimentInQuestion.getNameOfClassifier())) continue;
            this.logger.debug("Skipping because {} is known to be problematic as classifier on {} due to {}", new Object[]{experimentInQuestion.getNameOfClassifier(), re.getDataset(), re.getException()});
            return true;
        }
        return false;
    }
}

