/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.single;

import ai.libs.jaicore.db.IDatabaseAdapter;
import ai.libs.jaicore.ml.weka.classification.learner.reduction.splitter.RandomSplitter;
import ai.libs.reduction.single.ExperimentRunner;
import ai.libs.reduction.single.MySQLReductionExperiment;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public abstract class ABestOfKReductionStumpExperimentRunnerWrapper {
    private final IDatabaseAdapter adapter;
    private final String tableName;
    private final int k;
    private final int mccvrepeats;

    protected ABestOfKReductionStumpExperimentRunnerWrapper(IDatabaseAdapter adapter, String tableName, int k, int mccvrepeats) {
        this.adapter = adapter;
        this.tableName = tableName;
        this.k = k;
        this.mccvrepeats = mccvrepeats;
    }

    public void markExperimentAsUnsolvable(MySQLReductionExperiment exp) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("errorRate", "-1");
        this.updateExperiment(exp, values);
    }

    public void associateExperimentWithException(MySQLReductionExperiment exp, Throwable e) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("errorRate", "-1");
        values.put("exception", e.getClass().getName() + "\n" + e.getMessage());
        this.updateExperiment(exp, values);
    }

    public void conductExperiment(MySQLReductionExperiment exp) throws Exception {
        ExperimentRunner runner = new ExperimentRunner(this.k, this.mccvrepeats, seed -> new RandomSplitter(new Random(seed)));
        Map<String, Object> results = runner.conductSingleOneStepReductionExperiment(exp.getExperiment());
        this.updateExperiment(exp, results);
    }

    protected void updateExperiment(MySQLReductionExperiment exp, Map<String, ? extends Object> values) throws SQLException {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("evaluation_id", String.valueOf(exp.getId()));
        this.adapter.update(this.tableName, values, where);
    }

    public int getK() {
        return this.k;
    }

    public int getMCCVRepeats() {
        return this.mccvrepeats;
    }

    public IDatabaseAdapter getAdapter() {
        return this.adapter;
    }
}

