/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.single.confusion;

import java.util.ArrayList;
import java.util.Collection;

public class AConfusionBasedAlgorithm {
    protected Collection<Integer> incrementCluster(Collection<Integer> cluster, double[][] confusionMatrix, Collection<Integer> blackList) {
        int leastSeenPenalty = Integer.MAX_VALUE;
        int choice = -1;
        for (int cId = 0; cId < confusionMatrix.length; ++cId) {
            if (cluster.contains(cId) || blackList.contains(cId)) continue;
            int addedPenalty = 0;
            for (int i = 0; i < confusionMatrix.length; ++i) {
                addedPenalty = (int)((double)addedPenalty + confusionMatrix[i][cId]);
                addedPenalty = (int)((double)addedPenalty + confusionMatrix[cId][i]);
            }
            if (addedPenalty >= leastSeenPenalty) continue;
            leastSeenPenalty = addedPenalty;
            choice = cId;
        }
        ArrayList<Integer> newCluster = new ArrayList<Integer>(cluster);
        if (choice < 0) {
            return newCluster;
        }
        newCluster.add(choice);
        return newCluster;
    }

    protected int getPenaltyOfCluster(Collection<Integer> cluster, double[][] confusionMatrix) {
        int sum = 0;
        for (int i : cluster) {
            for (int j : cluster) {
                if (i == j) continue;
                sum = (int)((double)sum + confusionMatrix[i][j]);
            }
        }
        return sum;
    }

    protected int getLeastConflictingClass(double[][] confusionMatrix, Collection<Integer> blackList) {
        int leastConflictingClass = -1;
        int leastKnownScore = Integer.MAX_VALUE;
        for (int i = 0; i < confusionMatrix.length; ++i) {
            if (blackList.contains(i)) continue;
            int sum = 0;
            for (int j = 0; j < confusionMatrix.length; ++j) {
                if (i == j) continue;
                sum = (int)((double)sum + confusionMatrix[i][j]);
            }
            if (sum >= leastKnownScore) continue;
            leastKnownScore = sum;
            leastConflictingClass = i;
        }
        return leastConflictingClass;
    }
}

