/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.gui.outofsampleplots;

import ai.libs.jaicore.basic.reconstruction.ReconstructionPlan;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.ScoredSolutionCandidateInfo;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import ai.libs.jaicore.ml.classification.loss.dataset.EClassificationPerformanceMeasure;
import ai.libs.jaicore.ml.core.evaluation.MLEvaluationUtil;
import ai.libs.mlplan.core.events.ClassifierFoundEvent;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPlugin;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPluginModel;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPluginView;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.api4.java.ai.ml.classification.IClassifier;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.algorithm.events.serializable.IPropertyProcessedAlgorithmEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutOfSampleErrorPlotPluginController
extends ASimpleMVCPluginController<OutOfSampleErrorPlotPluginModel, OutOfSampleErrorPlotPluginView> {
    private ILabeledDataset<?> train;
    private ILabeledDataset<?> test;
    private Logger logger = LoggerFactory.getLogger(OutOfSampleErrorPlotPlugin.class);

    public OutOfSampleErrorPlotPluginController(OutOfSampleErrorPlotPluginModel model, OutOfSampleErrorPlotPluginView view) {
        super((ASimpleMVCPluginModel)model, (ASimpleMVCPluginView)view);
    }

    public ILabeledDataset<?> getTrain() {
        return this.train;
    }

    public void setTrain(ILabeledDataset<?> train) {
        this.train = train;
    }

    public ILabeledDataset<?> getTest() {
        return this.test;
    }

    public void setTest(ILabeledDataset<?> test) {
        this.test = test;
    }

    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent || guiEvent instanceof GoToTimeStepEvent) {
            ((OutOfSampleErrorPlotPluginModel)this.getModel()).clear();
        }
    }

    public void handleAlgorithmEventInternally(IPropertyProcessedAlgorithmEvent algorithmEvent) {
        if (algorithmEvent.correspondsToEventOfClass(ClassifierFoundEvent.class)) {
            this.logger.debug("Received classifier found event {}", (Object)algorithmEvent);
            Object rawScoredSolutionCandidateInfo = algorithmEvent.getProperty("scored_solution_candidate_info");
            if (rawScoredSolutionCandidateInfo != null) {
                ScoredSolutionCandidateInfo scoredSolutionCandidateInfo = (ScoredSolutionCandidateInfo)rawScoredSolutionCandidateInfo;
                try {
                    IClassifier classifier = this.deserializeClassifier(scoredSolutionCandidateInfo.getSolutionCandidateRepresentation());
                    this.logger.debug("Building classifier");
                    classifier.fit(this.train);
                    ArrayList<Double> performances = new ArrayList<Double>();
                    performances.add(this.parseScoreToDouble(scoredSolutionCandidateInfo.getScore()));
                    performances.add(MLEvaluationUtil.getLossForTrainedClassifier((ISupervisedLearner)classifier, this.test, (IDeterministicPredictionPerformanceMeasure)EClassificationPerformanceMeasure.ERRORRATE));
                    this.logger.debug("Adding solution to model and updating view.");
                    ((OutOfSampleErrorPlotPluginModel)this.getModel()).addEntry(algorithmEvent.getTimestampOfEvent(), classifier, performances);
                    this.logger.debug("Added solution to model.");
                }
                catch (NumberFormatException exception) {
                    this.logger.warn("Received processed SolutionCandidateFoundEvent, but the score {} cannot be parsed to a double.", (Object)scoredSolutionCandidateInfo.getScore());
                    return;
                }
                catch (Exception e) {
                    this.logger.error("Could not train classifier! " + e.toString());
                }
            }
        }
    }

    private IClassifier deserializeClassifier(String serializedClassifier) throws Exception {
        ReconstructionPlan plan = (ReconstructionPlan)new ObjectMapper().readValue(serializedClassifier, ReconstructionPlan.class);
        return (IClassifier)plan.reconstructObject();
    }

    private double parseScoreToDouble(String score) throws NumberFormatException {
        return Double.parseDouble(score);
    }
}

