/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.gui.outofsampleplots;

import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginModel;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPluginController;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPluginModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutOfSampleErrorPlotPluginView
extends ASimpleMVCPluginView<OutOfSampleErrorPlotPluginModel, OutOfSampleErrorPlotPluginController, LineChart<Number, Number>> {
    private Logger logger = LoggerFactory.getLogger(OutOfSampleErrorPlotPluginView.class);
    private final XYChart.Series<Number, Number> believedErrorSeries;
    private final XYChart.Series<Number, Number> outOfSampleErrorSeries;
    private int nextIndexToDisplay = 0;

    public OutOfSampleErrorPlotPluginView(OutOfSampleErrorPlotPluginModel model) {
        super((IGUIPluginModel)model, (Node)new LineChart((Axis)new NumberAxis(), (Axis)new NumberAxis()));
        ((LineChart)this.getNode()).getXAxis().setLabel("elapsed time (s)");
        this.believedErrorSeries = new XYChart.Series();
        this.believedErrorSeries.setName("Believed (internal) Error");
        this.outOfSampleErrorSeries = new XYChart.Series();
        this.outOfSampleErrorSeries.setName("Out-of-Sample Error");
        ((LineChart)this.getNode()).getData().add(this.believedErrorSeries);
        ((LineChart)this.getNode()).getData().add(this.outOfSampleErrorSeries);
    }

    public void update() {
        List<Integer> observedTimestamps = ((OutOfSampleErrorPlotPluginModel)this.getModel()).getTimestamps();
        List<List<Double>> performances = ((OutOfSampleErrorPlotPluginModel)this.getModel()).getPerformances();
        ArrayList<XYChart.Data> believedErrors = new ArrayList<XYChart.Data>();
        ArrayList<XYChart.Data> outOfSampleErrors = new ArrayList<XYChart.Data>();
        while (this.nextIndexToDisplay < observedTimestamps.size()) {
            int timestamp = observedTimestamps.get(this.nextIndexToDisplay) / 100;
            believedErrors.add(new XYChart.Data((Object)timestamp, (Object)performances.get(this.nextIndexToDisplay).get(0)));
            outOfSampleErrors.add(new XYChart.Data((Object)timestamp, (Object)performances.get(this.nextIndexToDisplay).get(1)));
            ++this.nextIndexToDisplay;
        }
        this.logger.info("Adding {} values to chart.", (Object)believedErrors.size());
        Platform.runLater(() -> {
            this.believedErrorSeries.getData().addAll((Collection)believedErrors);
            this.outOfSampleErrorSeries.getData().addAll((Collection)outOfSampleErrors);
        });
    }

    public void clear() {
        this.nextIndexToDisplay = 0;
        this.believedErrorSeries.getData().clear();
        this.outOfSampleErrorSeries.getData().clear();
    }

    public int getNextIndexToDisplay() {
        return this.nextIndexToDisplay;
    }
}

