/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.meka;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.exceptions.ComponentInstantiationFailedException;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.ml.classification.multilabel.learner.IMekaClassifier;
import ai.libs.jaicore.ml.classification.multilabel.learner.MekaClassifier;
import ai.libs.mlplan.meka.IMekaPipelineFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import meka.classifiers.multilabel.MultiLabelClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.SMOreg;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.OptionHandler;

public class MekaPipelineFactory
implements IMekaPipelineFactory {
    private static final String PARAMETER_NAME_WITH_DASH_WARNING = "Required interface of component {} has dash or underscore in interface id {}";
    private static final Logger logger = LoggerFactory.getLogger(MekaPipelineFactory.class);

    public IMekaClassifier getComponentInstantiation(IComponentInstance ci) throws ComponentInstantiationFailedException {
        MultiLabelClassifier instance = null;
        try {
            instance = (MultiLabelClassifier)this.getClassifier(ci);
            return new MekaClassifier(instance);
        }
        catch (Exception e) {
            throw new ComponentInstantiationFailedException((Throwable)e, "Could not instantiate " + ci.getComponent().getName());
        }
    }

    private Classifier getClassifier(IComponentInstance ci) throws Exception {
        Classifier c = (Classifier)Class.forName(ci.getComponent().getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        List<String> optionsList = MekaPipelineFactory.getOptionsForParameterValues(ci);
        if (c instanceof OptionHandler) {
            ((OptionHandler)c).setOptions(optionsList.toArray(new String[0]));
        }
        for (Map.Entry reqI : ci.getSatisfactionOfRequiredInterfaces().entrySet()) {
            if (((String)reqI.getKey()).startsWith("-") || ((String)reqI.getKey()).startsWith("_")) {
                logger.warn(PARAMETER_NAME_WITH_DASH_WARNING, (Object)ci.getComponent(), reqI.getKey());
            }
            IComponentInstance subCI = (IComponentInstance)((List)reqI.getValue()).iterator().next();
            if (((String)reqI.getKey()).equals("K") && (ci.getComponent().getName().endsWith("SMO") || ci.getComponent().getName().endsWith("SMOreg"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Set kernel for SMO to be {}", (Object)subCI.getComponent().getName());
                }
                Kernel k = (Kernel)Class.forName(subCI.getComponent().getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                k.setOptions(MekaPipelineFactory.getOptionsForParameterValues(subCI).toArray(new String[0]));
                if (c instanceof SMO) {
                    ((SMO)c).setKernel(k);
                    continue;
                }
                if (!(c instanceof SMOreg)) continue;
                ((SMOreg)c).setKernel(k);
                continue;
            }
            if (((String)reqI.getKey()).equals("B") && c instanceof MultipleClassifiersCombiner) {
                Classifier[] classifiers = this.getListOfBaseLearners(subCI).toArray(new Classifier[0]);
                ((MultipleClassifiersCombiner)c).setClassifiers(classifiers);
                continue;
            }
            if (!((String)reqI.getKey()).equals("W") || !(c instanceof SingleClassifierEnhancer)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Set {} as a base classifier for {}", (Object)subCI.getComponent().getName(), (Object)ci.getComponent().getName());
            }
            ((SingleClassifierEnhancer)c).setClassifier(this.getClassifier(subCI));
        }
        return c;
    }

    private List<Classifier> getListOfBaseLearners(IComponentInstance ci) throws Exception {
        LinkedList<Classifier> baseLearnerList = new LinkedList<Classifier>();
        if (ci.getComponent().getName().equals("MultipleBaseLearnerListElement")) {
            baseLearnerList.add(this.getClassifier((IComponentInstance)ci.getSatisfactionOfRequiredInterface("classifier").iterator().next()));
        } else if (ci.getComponent().getName().equals("MultipleBaseLearnerListChain")) {
            baseLearnerList.add(this.getClassifier((IComponentInstance)ci.getSatisfactionOfRequiredInterface("classifier").iterator().next()));
            baseLearnerList.addAll(this.getListOfBaseLearners((IComponentInstance)ci.getSatisfactionOfRequiredInterface("chain").iterator().next()));
        }
        return baseLearnerList;
    }

    public static List<String> getOptionsForParameterValues(IComponentInstance ci) {
        LinkedList<String> optionsList = new LinkedList<String>();
        for (Map.Entry parameterValue : ci.getParameterValues().entrySet()) {
            IParameter param = ci.getComponent().getParameter((String)parameterValue.getKey());
            if (param.isDefaultValue(parameterValue.getValue()) || ((String)parameterValue.getKey()).toLowerCase().contains("activator") || ((String)parameterValue.getValue()).equals("false")) continue;
            if (((String)parameterValue.getValue()).equals("true")) {
                optionsList.add("-" + (String)parameterValue.getKey());
                continue;
            }
            optionsList.add("-" + (String)parameterValue.getKey());
            if (ci.getComponent().getParameter((String)parameterValue.getKey()).isNumeric()) {
                NumericParameterDomain numDom = (NumericParameterDomain)ci.getComponent().getParameter((String)parameterValue.getKey()).getDefaultDomain();
                if (numDom.isInteger()) {
                    optionsList.add((int)Double.parseDouble((String)parameterValue.getValue()) + "");
                    continue;
                }
                optionsList.add((String)parameterValue.getValue());
                continue;
            }
            optionsList.add((String)parameterValue.getValue());
        }
        return optionsList;
    }

    private List<String> getOptionsRecursively(IComponentInstance ci) {
        List<String> optionsList = MekaPipelineFactory.getOptionsForParameterValues(ci);
        for (Map.Entry reqI : ci.getSatisfactionOfRequiredInterfaces().entrySet()) {
            if (((String)reqI.getKey()).startsWith("-") || ((String)reqI.getKey()).startsWith("_")) {
                logger.warn(PARAMETER_NAME_WITH_DASH_WARNING, (Object)ci.getComponent(), reqI.getKey());
            }
            optionsList.add("-" + (String)reqI.getKey());
            IComponentInstance subComponentInstance = (IComponentInstance)((List)reqI.getValue()).iterator().next();
            if (((String)reqI.getKey()).equals("B") || ((String)reqI.getKey()).equals("K")) {
                LinkedList<String> valueList = new LinkedList<String>();
                valueList.add(subComponentInstance.getComponent().getName());
                valueList.addAll(this.getOptionsRecursively(subComponentInstance));
                optionsList.add(SetUtil.implode(valueList, (String)" "));
                continue;
            }
            optionsList.add(subComponentInstance.getComponent().getName());
            if (subComponentInstance.getParameterValues().isEmpty() && subComponentInstance.getSatisfactionOfRequiredInterfaces().isEmpty()) continue;
            optionsList.add("--");
            optionsList.addAll(this.getOptionsRecursively(subComponentInstance));
        }
        return optionsList;
    }
}

