/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan.weka;

import ai.libs.jaicore.components.exceptions.ComponentInstantiationFailedException;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.IParameterDomain;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaClassifier;
import ai.libs.jaicore.ml.weka.classification.learner.WekaClassifier;
import ai.libs.jaicore.ml.weka.classification.pipeline.MLPipeline;
import ai.libs.mlplan.core.ILearnerFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.meta.Stacking;
import weka.core.OptionHandler;

public class WekaPipelineFactory
implements ILearnerFactory<IWekaClassifier> {
    private Logger logger = LoggerFactory.getLogger(WekaPipelineFactory.class);
    private static final String L_CLASSIFIER = "classifier";

    public IWekaClassifier getComponentInstantiation(ComponentInstance groundComponent) throws ComponentInstantiationFailedException {
        this.logger.debug("Instantiate weka classifier from component instance {}.", (Object)groundComponent);
        try {
            if (groundComponent.getComponent().getName().equals("pipeline")) {
                ComponentInstance preprocessorCI = null;
                preprocessorCI = (ComponentInstance)groundComponent.getSatisfactionOfRequiredInterfaces().get("preprocessor");
                ComponentInstance evaluatorCI = (ComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterfaces().get("eval");
                ComponentInstance searcherCI = (ComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterfaces().get("search");
                ASEvaluation eval = ASEvaluation.forName((String)evaluatorCI.getComponent().getName(), (String[])this.getParameterList(evaluatorCI).toArray(new String[0]));
                ASSearch search = ASSearch.forName((String)searcherCI.getComponent().getName(), (String[])this.getParameterList(searcherCI).toArray(new String[0]));
                IWekaClassifier c = this.getComponentInstantiation((ComponentInstance)groundComponent.getSatisfactionOfRequiredInterfaces().get(L_CLASSIFIER));
                this.logger.debug("Returning a MLPipeline object (aseval: {}, assearch: {}, classifier: {})", new Object[]{eval != null, search != null, c != null});
                return new WekaClassifier((Classifier)new MLPipeline(search, eval, c.getClassifier()));
            }
            Classifier c = AbstractClassifier.forName((String)groundComponent.getComponent().getName(), (String[])this.getParameterList(groundComponent).toArray(new String[0]));
            List<String> options = this.getParameterList(groundComponent);
            options.add("-do-not-check-capabilities");
            if (c instanceof OptionHandler) {
                ((OptionHandler)c).setOptions(options.toArray(new String[0]));
            }
            block12: for (Map.Entry reqI : groundComponent.getSatisfactionOfRequiredInterfaces().entrySet()) {
                switch ((String)reqI.getKey()) {
                    case "W": {
                        if (c instanceof SingleClassifierEnhancer) {
                            ((SingleClassifierEnhancer)c).setClassifier(this.getComponentInstantiation((ComponentInstance)reqI.getValue()).getClassifier());
                            continue block12;
                        }
                        this.logger.error("Got required interface W but classifier {} is not single classifier enhancer", (Object)c.getClass().getName());
                        continue block12;
                    }
                    case "K": {
                        if (c instanceof SMO) {
                            Kernel k = (Kernel)Class.forName(((ComponentInstance)reqI.getValue()).getComponent().getName()).newInstance();
                            k.setOptions(this.getParameterList((ComponentInstance)reqI.getValue()).toArray(new String[0]));
                            ((SMO)c).setKernel(k);
                            continue block12;
                        }
                        this.logger.error("Got required interface K but classifier {} is not SMO", (Object)c.getClass().getName());
                        continue block12;
                    }
                    case "B": {
                        Classifier baseClassifier = this.getComponentInstantiation((ComponentInstance)reqI.getValue()).getClassifier();
                        if (c instanceof Stacking) {
                            ((Stacking)c).setClassifiers(new Classifier[]{baseClassifier});
                            continue block12;
                        }
                        this.logger.error("Unsupported option B for classifier {}", (Object)c.getClass().getName());
                        continue block12;
                    }
                }
                this.logger.error("Got required interface {} for classifier {}. Dont know what to do with it...", reqI.getKey(), (Object)c.getClass().getName());
            }
            return new WekaClassifier(c);
        }
        catch (Exception e) {
            throw new ComponentInstantiationFailedException((Throwable)e, "Could not instantiate component.");
        }
    }

    private List<IWekaClassifier> getListOfBaseLearners(ComponentInstance ci) throws ComponentInstantiationFailedException {
        LinkedList<IWekaClassifier> baseLearnerList = new LinkedList<IWekaClassifier>();
        if (ci.getComponent().getName().equals("MultipleBaseLearnerListElement")) {
            baseLearnerList.add(this.getComponentInstantiation((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get(L_CLASSIFIER)));
        } else if (ci.getComponent().getName().equals("MultipleBaseLearnerListChain")) {
            baseLearnerList.add(this.getComponentInstantiation((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get(L_CLASSIFIER)));
            baseLearnerList.addAll(this.getListOfBaseLearners((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get("chain")));
        }
        return baseLearnerList;
    }

    private List<String> getParameterList(ComponentInstance ci) {
        LinkedList<String> parameters = new LinkedList<String>();
        for (Map.Entry parameterValues : ci.getParameterValues().entrySet()) {
            Parameter param = ci.getComponent().getParameterWithName((String)parameterValues.getKey());
            boolean isDefault = param.isDefaultValue(parameterValues.getValue());
            if (((String)parameterValues.getKey()).toLowerCase().endsWith("activator") || ((String)parameterValues.getValue()).equals("REMOVED") || isDefault) continue;
            if (!((String)parameterValues.getValue()).equals("false")) {
                parameters.add("-" + (String)parameterValues.getKey());
            }
            IParameterDomain domain = ci.getComponent().getParameterWithName((String)parameterValues.getKey()).getDefaultDomain();
            if (parameterValues.getValue() == null || ((String)parameterValues.getValue()).equals("") || ((String)parameterValues.getValue()).equals("true") || ((String)parameterValues.getValue()).equals("false")) continue;
            if (domain instanceof NumericParameterDomain && ((NumericParameterDomain)domain).isInteger()) {
                parameters.add((int)Double.parseDouble((String)parameterValues.getValue()) + "");
                continue;
            }
            parameters.add((String)parameterValues.getValue());
        }
        return parameters;
    }
}

