/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan.weka;

import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.serialization.ComponentNotFoundException;
import ai.libs.jaicore.components.serialization.ComponentUtils;
import ai.libs.jaicore.ml.weka.classification.pipeline.MLPipeline;
import ai.libs.jaicore.ml.weka.classification.pipeline.SupervisedFilterSelector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aeonbits.owner.util.Collections;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import weka.core.OptionHandler;

public class MLPipelineComponentInstanceFactory {
    private Collection<Component> components;

    public MLPipelineComponentInstanceFactory(Collection<Component> components) {
        this.components = components;
    }

    public ComponentInstance convertToComponentInstance(MLPipeline pipeline) throws ComponentNotFoundException {
        if (pipeline.getPreprocessors() != null && !pipeline.getPreprocessors().isEmpty()) {
            SupervisedFilterSelector preprocessor = (SupervisedFilterSelector)pipeline.getPreprocessors().get(0);
            ComponentInstance searcherCI = this.getComponentInstanceForPipelineElement(preprocessor.getSearcher(), new Pair[0]);
            ComponentInstance evaluatorCI = this.getComponentInstanceForPipelineElement(preprocessor.getEvaluator(), new Pair[0]);
            ComponentInstance preprocessorCI = this.getComponentInstanceForPipelineElement(preprocessor.getSelector(), new Pair[]{new ImmutablePair((Object)"eval", (Object)evaluatorCI), new ImmutablePair((Object)"search", (Object)searcherCI)});
            ComponentInstance classifierCI = this.getComponentInstanceForPipelineElement(pipeline.getBaseClassifier(), new Pair[0]);
            HashMap<String, ComponentInstance> satisfactionOfRequiredInterfaces = new HashMap<String, ComponentInstance>();
            satisfactionOfRequiredInterfaces.put("preprocessor", preprocessorCI);
            satisfactionOfRequiredInterfaces.put("classifier", classifierCI);
            return new ComponentInstance(ComponentUtils.getComponentByName((String)"pipeline", this.components), new HashMap(), satisfactionOfRequiredInterfaces);
        }
        return new ComponentInstance(ComponentUtils.getComponentByName((String)pipeline.getBaseClassifier().getClass().getName(), this.components), this.getParametersForPipelineElement(pipeline.getBaseClassifier()), new HashMap());
    }

    private ComponentInstance getComponentInstanceForPipelineElement(Object pipelineElement, Pair<String, ComponentInstance> ... satisfactionOfRegquiredInterfaces) throws ComponentNotFoundException {
        HashMap satisfactionOfRequiredInterfaces = new HashMap();
        Arrays.stream(satisfactionOfRegquiredInterfaces).forEach(entry -> satisfactionOfRequiredInterfaces.put((String)entry.getKey(), (ComponentInstance)entry.getValue()));
        return new ComponentInstance(ComponentUtils.getComponentByName((String)pipelineElement.getClass().getName(), this.components), this.getParametersForPipelineElement(pipelineElement), satisfactionOfRequiredInterfaces);
    }

    private Map<String, String> getParametersForPipelineElement(Object classifier) {
        if (classifier instanceof OptionHandler) {
            OptionHandler handler = (OptionHandler)classifier;
            HashMap<String, String> parametersWithValues = new HashMap<String, String>(handler.getOptions().length);
            String optionName = null;
            boolean previousStringWasAValue = true;
            for (String option : handler.getOptions()) {
                if (option.equals("--")) break;
                if (previousStringWasAValue || !NumberUtils.isCreatable((String)option) && !NumberUtils.isParsable((String)option) && option.startsWith("-")) {
                    if (!previousStringWasAValue) {
                        parametersWithValues.put(optionName, "true");
                    }
                    previousStringWasAValue = false;
                    optionName = option.equals("") ? option : option.substring(1, option.length());
                    continue;
                }
                previousStringWasAValue = true;
                parametersWithValues.put(optionName, option);
            }
            if (!previousStringWasAValue) {
                parametersWithValues.put(optionName, (String)Collections.list((Object[])handler.getOptions()).get(handler.getOptions().length - 1));
            }
            return parametersWithValues;
        }
        return new HashMap<String, String>(0);
    }
}

