/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.weka;

import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.ISupervisedLearnerEvaluatorFactory;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.LearningCurveExtrapolationEvaluatorFactory;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaClassifier;
import ai.libs.jaicore.ml.weka.dataset.WekaInstances;
import ai.libs.mlplan.core.AMLPlanBuilder;
import ai.libs.mlplan.core.IProblemType;
import ai.libs.mlplan.weka.EMLPlanWekaProblemType;
import ai.libs.mlplan.weka.MLPlan4Weka;
import java.io.IOException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLPlanWekaBuilder
extends AMLPlanBuilder<IWekaClassifier, MLPlanWekaBuilder> {
    private Logger logger = LoggerFactory.getLogger(MLPlanWekaBuilder.class);

    public static MLPlanWekaBuilder forClassification() throws IOException {
        return new MLPlanWekaBuilder(EMLPlanWekaProblemType.CLASSIFICATION_MULTICLASS);
    }

    public static MLPlanWekaBuilder forClassificationReduced() throws IOException {
        return new MLPlanWekaBuilder(EMLPlanWekaProblemType.CLASSIFICATION_MULTICLASS_REDUCED);
    }

    public static MLPlanWekaBuilder forRegression() throws IOException {
        return new MLPlanWekaBuilder(EMLPlanWekaProblemType.REGRESSION);
    }

    public static MLPlanWekaBuilder forClassificationWithTinySearchSpace() throws IOException {
        return new MLPlanWekaBuilder(EMLPlanWekaProblemType.CLASSIFICATION_MULTICLASS_TINY);
    }

    public MLPlanWekaBuilder() throws IOException {
        this(EMLPlanWekaProblemType.CLASSIFICATION_MULTICLASS);
    }

    public MLPlanWekaBuilder(EMLPlanWekaProblemType problemType) throws IOException {
        super((IProblemType)problemType);
    }

    public void withLearningCurveExtrapolationEvaluation(int[] anchorpoints, ISamplingAlgorithmFactory<ILabeledDataset<?>, ? extends ASamplingAlgorithm<ILabeledDataset<?>>> subsamplingAlgorithmFactory, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod) {
        this.withSearchPhaseEvaluatorFactory((ISupervisedLearnerEvaluatorFactory)new LearningCurveExtrapolationEvaluatorFactory(anchorpoints, subsamplingAlgorithmFactory, trainSplitForAnchorpointsMeasurement, extrapolationMethod));
        this.withSelectionPhaseEvaluatorFactory((ISupervisedLearnerEvaluatorFactory)((MonteCarloCrossValidationEvaluatorFactory)new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(3)).withTrainFoldSize(0.7));
        this.getAlgorithmConfig().setProperty("hasco.blowup.selection", "10");
        throw new UnsupportedOperationException("Learning Curve Prediction based ML-Plan runs are not supported in this release. They will be activated again in the upcoming release.");
    }

    public MLPlanWekaBuilder withDataset(ILabeledDataset<?> dataset) {
        WekaInstances instances = dataset instanceof WekaInstances ? (WekaInstances)dataset : new WekaInstances(dataset);
        super.withDataset((ILabeledDataset)instances);
        this.logger.info("Setting dataset as WekaInstances object.");
        return this.getSelf();
    }

    public MLPlanWekaBuilder getSelf() {
        return this;
    }

    public MLPlan4Weka build() {
        this.checkPreconditionsForInitialization();
        return new MLPlan4Weka(this, this.getDataset());
    }
}

