/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.weka;

import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaClassifier;
import ai.libs.jaicore.ml.weka.dataset.WekaInstances;
import ai.libs.mlplan.core.MLPlan;
import ai.libs.mlplan.multiclass.IMLPlanClassifierConfig;
import ai.libs.mlplan.weka.MLPlan4Weka;
import ai.libs.mlplan.weka.MLPlanWekaBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.api4.java.ai.ml.core.dataset.IDataSource;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.IPrediction;
import org.api4.java.ai.ml.core.evaluation.IPredictionBatch;
import org.api4.java.ai.ml.core.exception.LearnerConfigurationFailedException;
import org.api4.java.ai.ml.core.exception.PredictionException;
import org.api4.java.ai.ml.core.exception.TrainingException;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.event.IEventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;

public class MLPlanWekaClassifier
implements Classifier,
CapabilitiesHandler,
OptionHandler,
ILoggingCustomizable,
IWekaClassifier,
IEventEmitter<Object> {
    private transient Logger logger = LoggerFactory.getLogger(MLPlanWekaClassifier.class);
    private String loggerName;
    private final transient MLPlanWekaBuilder builder;
    private Timeout timeout;
    private IWekaClassifier classifierFoundByMLPlan;
    private double internalValidationErrorOfSelectedClassifier;
    private final transient List<Object> listeners = new ArrayList<Object>();

    public MLPlanWekaClassifier(MLPlanWekaBuilder builder) {
        this.builder = builder;
        this.timeout = builder.getTimeOut();
    }

    public void buildClassifier(Instances data) throws Exception {
        this.fit((ILabeledDataset<? extends ILabeledInstance>)new WekaInstances(data));
    }

    public double[] classifyInstances(Instances instances) throws PredictionException, InterruptedException {
        double[] predictionsAsDoubles = new double[instances.size()];
        List predictions = this.classifierFoundByMLPlan.predict((IDataSource)new WekaInstances(instances)).getPredictions();
        for (int i = 0; i < instances.size(); ++i) {
            predictionsAsDoubles[i] = (Double)((IPrediction)predictions.get(i)).getPrediction();
        }
        return predictionsAsDoubles;
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.classifierFoundByMLPlan == null) {
            throw new IllegalStateException("Classifier has not been built yet.");
        }
        return this.classifierFoundByMLPlan.getClassifier().classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.classifierFoundByMLPlan == null) {
            throw new IllegalStateException("Classifier has not been built yet.");
        }
        return this.classifierFoundByMLPlan.getClassifier().distributionForInstance(instance);
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public Enumeration<Option> listOptions() {
        return null;
    }

    public void setOptions(String[] options) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    public IMLPlanClassifierConfig getMLPlanConfig() {
        return this.builder.getAlgorithmConfig();
    }

    public Collection<IComponent> getComponents() throws IOException {
        return this.builder.getComponents();
    }

    public Classifier getSelectedWekaClassifier() {
        return this.classifierFoundByMLPlan.getClassifier();
    }

    public double getInternalValidationErrorOfSelectedClassifier() {
        return this.internalValidationErrorOfSelectedClassifier;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger name to {}", (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched ML-Plan logger to {}", (Object)name);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void registerListener(Object listener) {
        this.listeners.add(listener);
    }

    public IPrediction fitAndPredict(ILabeledDataset<? extends ILabeledInstance> dTrain, ILabeledInstance xTest) throws TrainingException, PredictionException, InterruptedException {
        this.fit(dTrain);
        return this.predict(xTest);
    }

    public IPredictionBatch fitAndPredict(ILabeledDataset<? extends ILabeledInstance> dTrain, ILabeledInstance[] xTest) throws TrainingException, PredictionException, InterruptedException {
        this.fit(dTrain);
        return this.predict(xTest);
    }

    public IPredictionBatch fitAndPredict(ILabeledDataset<? extends ILabeledInstance> dTrain, ILabeledDataset<? extends ILabeledInstance> dTest) throws TrainingException, PredictionException, InterruptedException {
        this.fit(dTrain);
        return this.predict(dTest);
    }

    public void fit(ILabeledDataset<? extends ILabeledInstance> dTrain) throws TrainingException, InterruptedException {
        Objects.requireNonNull(this.timeout, "Timeout must be set before running ML-Plan.");
        MLPlan4Weka mlplan = this.builder.withDataset((ILabeledDataset)dTrain).build();
        this.listeners.forEach(arg_0 -> ((MLPlan)mlplan).registerListener(arg_0));
        mlplan.setTimeout(this.timeout);
        if (this.loggerName != null) {
            mlplan.setLoggerName(this.loggerName + ".mlplan");
        }
        try {
            this.classifierFoundByMLPlan = (IWekaClassifier)mlplan.call();
        }
        catch (AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
            throw new TrainingException("Could not finish ML-Plan training.", e);
        }
    }

    public IPrediction predict(ILabeledInstance xTest) throws PredictionException, InterruptedException {
        return this.classifierFoundByMLPlan.predict((IInstance)xTest);
    }

    public IPredictionBatch predict(ILabeledDataset<? extends ILabeledInstance> dTest) throws PredictionException, InterruptedException {
        return this.classifierFoundByMLPlan.predict(dTest);
    }

    public IPredictionBatch predict(ILabeledInstance[] dTest) throws PredictionException, InterruptedException {
        return this.classifierFoundByMLPlan.predict((IInstance[])dTest);
    }

    public void setConfig(Map<String, Object> config) throws LearnerConfigurationFailedException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getConfig() {
        throw new UnsupportedOperationException();
    }

    public Classifier getClassifier() {
        return this.getSelectedWekaClassifier();
    }
}

