/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.weka.weka;

import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.api.IParameter;
import ai.libs.jaicore.components.api.IParameterDomain;
import ai.libs.jaicore.components.exceptions.ComponentInstantiationFailedException;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaClassifier;
import ai.libs.jaicore.ml.weka.classification.learner.WekaClassifier;
import ai.libs.jaicore.ml.weka.classification.pipeline.MLPipeline;
import ai.libs.mlplan.core.ILearnerFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.SMOreg;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.meta.Stacking;
import weka.classifiers.meta.Vote;
import weka.core.OptionHandler;

public class WekaPipelineFactory
implements ILearnerFactory<IWekaClassifier> {
    private Logger logger = LoggerFactory.getLogger(WekaPipelineFactory.class);
    private static final String L_CLASSIFIER = "classifier";

    public IWekaClassifier getComponentInstantiation(IComponentInstance groundComponent) throws ComponentInstantiationFailedException {
        this.logger.debug("Instantiate weka classifier from component instance {}.", (Object)groundComponent);
        try {
            if (groundComponent.getComponent().getName().equals("pipeline")) {
                IComponentInstance preprocessorCI = null;
                preprocessorCI = (IComponentInstance)groundComponent.getSatisfactionOfRequiredInterface("preprocessor").iterator().next();
                IComponentInstance evaluatorCI = (IComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterface("eval").iterator().next();
                IComponentInstance searcherCI = (IComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterface("search").iterator().next();
                ASEvaluation eval = ASEvaluation.forName((String)evaluatorCI.getComponent().getName(), (String[])this.getParameterList(evaluatorCI).toArray(new String[0]));
                ASSearch search = ASSearch.forName((String)searcherCI.getComponent().getName(), (String[])this.getParameterList(searcherCI).toArray(new String[0]));
                IWekaClassifier c = this.getComponentInstantiation((IComponentInstance)groundComponent.getSatisfactionOfRequiredInterface(L_CLASSIFIER).iterator().next());
                this.logger.debug("Returning a MLPipeline object (aseval: {}, assearch: {}, classifier: {})", new Object[]{eval != null, search != null, c != null});
                return new WekaClassifier((Classifier)new MLPipeline(search, eval, c.getClassifier()));
            }
            Classifier c = AbstractClassifier.forName((String)groundComponent.getComponent().getName(), (String[])this.getParameterList(groundComponent).toArray(new String[0]));
            List<String> options = this.getParameterList(groundComponent);
            options.add("-do-not-check-capabilities");
            if (c instanceof OptionHandler) {
                ((OptionHandler)c).setOptions(options.toArray(new String[0]));
            }
            block14: for (Map.Entry reqI : groundComponent.getSatisfactionOfRequiredInterfaces().entrySet()) {
                switch ((String)reqI.getKey()) {
                    case "W": {
                        if (c instanceof SingleClassifierEnhancer) {
                            ((SingleClassifierEnhancer)c).setClassifier(this.getComponentInstantiation((IComponentInstance)((List)reqI.getValue()).iterator().next()).getClassifier());
                            break;
                        }
                        this.logger.error("Got required interface W but classifier {} is not single classifier enhancer", (Object)c.getClass().getName());
                        break;
                    }
                    case "K": {
                        if (c instanceof SMO || c instanceof SMOreg) {
                            IComponentInstance kernel = (IComponentInstance)((List)reqI.getValue()).iterator().next();
                            Kernel k = (Kernel)Class.forName(kernel.getComponent().getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            k.setOptions(this.getParameterList(kernel).toArray(new String[0]));
                            if (c instanceof SMO) {
                                ((SMO)c).setKernel(k);
                                break;
                            }
                            if (!(c instanceof SMOreg)) continue block14;
                            ((SMOreg)c).setKernel(k);
                            break;
                        }
                        this.logger.error("Got required interface K but classifier {} is not SMO", (Object)c.getClass().getName());
                        break;
                    }
                    case "B": {
                        List<Classifier> baseClassifierList = ((List)reqI.getValue()).stream().map(x -> {
                            try {
                                return this.getComponentInstantiation((IComponentInstance)x).getClassifier();
                            }
                            catch (ComponentInstantiationFailedException e) {
                                return null;
                            }
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                        if (baseClassifierList.size() != ((List)reqI.getValue()).size()) {
                            this.logger.error("Could not instantiate base learners correctly.");
                            throw new ComponentInstantiationFailedException("Could not instantiate base learner list of Stacking.");
                        }
                        if (c instanceof Stacking) {
                            ((Stacking)c).setClassifiers(baseClassifierList.toArray(new Classifier[0]));
                            break;
                        }
                        if (c instanceof Vote) {
                            ((Vote)c).setClassifiers(baseClassifierList.toArray(new Classifier[0]));
                            break;
                        }
                        this.logger.error("Unsupported option B for classifier {}", (Object)c.getClass().getName());
                        break;
                    }
                    case "M": {
                        if (c instanceof Stacking) {
                            Classifier baseClassifier = this.getComponentInstantiation((IComponentInstance)((List)reqI.getValue()).iterator().next()).getClassifier();
                            ((Stacking)c).setMetaClassifier(baseClassifier);
                            break;
                        }
                        this.logger.error("Unsupported option B for classifier {}", (Object)c.getClass().getName());
                        break;
                    }
                    default: {
                        this.logger.error("Got required interface {} for classifier {}. Dont know what to do with it...", reqI.getKey(), (Object)c.getClass().getName());
                    }
                }
            }
            return new WekaClassifier(c);
        }
        catch (Exception e) {
            throw new ComponentInstantiationFailedException((Throwable)e, "Could not instantiate component.");
        }
    }

    private List<IWekaClassifier> getListOfBaseLearners(IComponentInstance ci) throws ComponentInstantiationFailedException {
        LinkedList<IWekaClassifier> baseLearnerList = new LinkedList<IWekaClassifier>();
        if (ci.getComponent().getName().equals("MultipleBaseLearnerListElement")) {
            baseLearnerList.add(this.getComponentInstantiation((IComponentInstance)ci.getSatisfactionOfRequiredInterface(L_CLASSIFIER).iterator().next()));
        } else if (ci.getComponent().getName().equals("MultipleBaseLearnerListChain")) {
            baseLearnerList.add(this.getComponentInstantiation((IComponentInstance)ci.getSatisfactionOfRequiredInterface(L_CLASSIFIER).iterator().next()));
            baseLearnerList.addAll(this.getListOfBaseLearners((IComponentInstance)ci.getSatisfactionOfRequiredInterface("chain").iterator().next()));
        }
        return baseLearnerList;
    }

    private List<String> getParameterList(IComponentInstance ci) {
        LinkedList<String> parameters = new LinkedList<String>();
        for (Map.Entry parameterValues : ci.getParameterValues().entrySet()) {
            IParameter param = ci.getComponent().getParameter((String)parameterValues.getKey());
            boolean isDefault = param.isDefaultValue(parameterValues.getValue());
            if (((String)parameterValues.getKey()).toLowerCase().endsWith("activator") || ((String)parameterValues.getValue()).equals("REMOVED") || isDefault) continue;
            if (!((String)parameterValues.getValue()).equals("false")) {
                parameters.add("-" + (String)parameterValues.getKey());
            }
            IParameterDomain domain = ci.getComponent().getParameter((String)parameterValues.getKey()).getDefaultDomain();
            if (parameterValues.getValue() == null || ((String)parameterValues.getValue()).equals("") || ((String)parameterValues.getValue()).equals("true") || ((String)parameterValues.getValue()).equals("false")) continue;
            if (domain instanceof NumericParameterDomain && ((NumericParameterDomain)domain).isInteger()) {
                parameters.add((int)Double.parseDouble((String)parameterValues.getValue()) + "");
                continue;
            }
            parameters.add((String)parameterValues.getValue());
        }
        return parameters;
    }
}

