/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.weka.weka;

import ai.libs.hasco.core.HASCOUtil;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.ml.weka.WekaUtil;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.exceptions.ControlledNodeEvaluationException;
import ai.libs.mlplan.core.PipelineValidityCheckingNodeEvaluator;
import java.util.Collection;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WekaPipelineValidityCheckingNodeEvaluator
extends PipelineValidityCheckingNodeEvaluator
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(WekaPipelineValidityCheckingNodeEvaluator.class);

    public WekaPipelineValidityCheckingNodeEvaluator() {
    }

    public WekaPipelineValidityCheckingNodeEvaluator(Collection<Component> components, ILabeledDataset<?> data) {
        super(components, data);
    }

    public Double evaluate(ILabeledPath<TFDNode, String> path) throws ControlledNodeEvaluationException {
        ComponentInstance instance;
        if (!this.propertiesDetermined) {
            this.extractDatasetProperties();
        }
        if ((instance = HASCOUtil.getSolutionCompositionFromState((Collection)this.getComponents(), (Monom)((TFDNode)path.getHead()).getState(), (boolean)false)) != null) {
            Object classifier;
            IComponentInstance pp;
            if (instance.getSatisfactionOfRequiredInterfaces().containsKey("preprocessor") && (pp = (IComponentInstance)instance.getSatisfactionOfRequiredInterface("preprocessor").iterator().next()) != null && pp.getComponent().getName().contains("AttributeSelection")) {
                IComponentInstance search = (IComponentInstance)pp.getSatisfactionOfRequiredInterface("search").iterator().next();
                IComponentInstance eval = (IComponentInstance)pp.getSatisfactionOfRequiredInterface("eval").iterator().next();
                if (search != null && eval != null && !WekaUtil.isValidPreprocessorCombination((String)search.getComponent().getName(), (String)eval.getComponent().getName())) {
                    throw new ControlledNodeEvaluationException("The given combination of searcher and evaluator cannot be benchmarked since they are incompatible.");
                }
            }
            if ((classifier = instance.getComponent().getName().toLowerCase().contains("pipeline") ? (IComponentInstance)instance.getSatisfactionOfRequiredInterface("classifier").iterator().next() : instance) != null) {
                this.checkValidity((IComponentInstance)classifier);
            }
        }
        return null;
    }

    private void checkValidity(IComponentInstance classifier) throws ControlledNodeEvaluationException {
        String classifierName = classifier.getComponent().getName().toLowerCase();
        boolean binaryClassifierMatch = classifierName.matches("(.*)(additiveregression|simplelinearregression|m5rules|votedperceptron|m5p)(.*)");
        if (!this.binaryClass && binaryClassifierMatch) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on non-binary datasets.");
        }
        boolean noBinaryClassifierMatch = classifierName.matches("(.*)(additiveregression|m5p|m5rules|simplelinearregression)(.*)");
        if (this.binaryClass && noBinaryClassifierMatch) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted for binary classification tasks.");
        }
        if (this.multiValuedNominalAttributes && classifierName.matches("(.*)(naivebayesmultinomial|simplelinearregression)(.*)")) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on datasets with multi-valued nominal attributes.");
        }
        boolean noMulticlassClassifierMatch = classifierName.matches("(.*)(votedperceptron)(.*)");
        if (this.multiClass && noMulticlassClassifierMatch) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on multinomial classification dataset.");
        }
        if (this.containsNegativeValues && classifierName.matches("(.*)(naivebayesmultinomial)(.*)")) {
            throw new ControlledNodeEvaluationException("Negative numeric attribute values are not supported by the classifier.");
        }
        if (this.regression && classifierName.matches("(.*)(oner|smo|j48|jrip|naivebayes|logistic|lmt|bayesnet)(.*)")) {
            throw new ControlledNodeEvaluationException("Learner does not support regression");
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

