/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlpipeline_evaluation;

import ai.libs.hasco.model.ComponentInstance;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.cache.ReproducibleInstances;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.AbstractSplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleSLCSplitBasedClassifierEvaluator;
import ai.libs.mlpipeline_evaluation.PerformanceDBAdapter;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class CacheEvaluatorMeasureBridge
extends AbstractSplitBasedClassifierEvaluator<Double, Double> {
    private static final Logger logger = LoggerFactory.getLogger(CacheEvaluatorMeasureBridge.class);
    private ComponentInstance evaluatedComponent;
    private SimpleSLCSplitBasedClassifierEvaluator simpleEvaluatorMeasureBridge;
    private PerformanceDBAdapter performanceDBAdapter;

    public CacheEvaluatorMeasureBridge(IMeasure<Double, Double> basicEvaluator, PerformanceDBAdapter performanceDBAdapter) {
        super(basicEvaluator);
        this.performanceDBAdapter = performanceDBAdapter;
        this.simpleEvaluatorMeasureBridge = new SimpleSLCSplitBasedClassifierEvaluator(basicEvaluator);
    }

    public Double evaluateSplit(Classifier pl, Instances trainingData, Instances validationData) throws ObjectEvaluationFailedException, InterruptedException {
        if (trainingData instanceof ReproducibleInstances) {
            Optional<Double> potentialCache;
            if (((ReproducibleInstances)trainingData).isCacheLookup() && (potentialCache = this.performanceDBAdapter.exists(this.evaluatedComponent, (ReproducibleInstances)trainingData, (ReproducibleInstances)validationData, this.simpleEvaluatorMeasureBridge.getBasicEvaluator().getClass().getName())).isPresent()) {
                logger.debug("Cache hit");
                return potentialCache.get();
            }
            logger.debug("Cache miss");
            Instant start = Instant.now();
            double performance = this.simpleEvaluatorMeasureBridge.evaluateSplit(pl, trainingData, validationData);
            Instant end = Instant.now();
            Duration delta = Duration.between(start, end);
            if (((ReproducibleInstances)trainingData).isCacheStorage()) {
                this.performanceDBAdapter.store(this.evaluatedComponent, (ReproducibleInstances)trainingData, (ReproducibleInstances)validationData, performance, this.simpleEvaluatorMeasureBridge.getBasicEvaluator().getClass().getName(), delta.toMillis());
            }
            return performance;
        }
        return this.simpleEvaluatorMeasureBridge.evaluateSplit(pl, trainingData, validationData);
    }

    public CacheEvaluatorMeasureBridge getShallowCopy(ComponentInstance componentInstance) {
        CacheEvaluatorMeasureBridge bridge = new CacheEvaluatorMeasureBridge((IMeasure<Double, Double>)this.getBasicEvaluator(), this.performanceDBAdapter);
        bridge.evaluatedComponent = componentInstance;
        return bridge;
    }
}

