/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.cli;

import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPlugin;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.IAlgorithm;
import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphViewPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGenerator;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePlugin;
import ai.libs.jaicore.graphvisualizer.window.AlgorithmVisualizationWindow;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.AutoMEKAGGPFitnessMeasureLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.ExactMatchLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.F1MacroAverageLLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.HammingLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.InstanceWiseF1AsLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.JaccardLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.RankLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.MeanSquaredErrorLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.PrecisionAsLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.RootMeanSquaredErrorLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.ZeroOneLoss;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNodeInfoGenerator;
import ai.libs.jaicore.search.gui.plugins.rollouthistograms.SearchRolloutHistogramPlugin;
import ai.libs.jaicore.search.model.travesaltree.JaicoreNodeInfoGenerator;
import ai.libs.mlplan.core.AbstractMLPlanBuilder;
import ai.libs.mlplan.core.AbstractMLPlanSingleLabelBuilder;
import ai.libs.mlplan.core.MLPlan;
import ai.libs.mlplan.core.MLPlanMekaBuilder;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPlugin;
import ai.libs.mlplan.multiclass.wekamlplan.weka.model.MLPipeline;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import meka.classifiers.MultiXClassifier;
import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.MultiLabelClassifier;
import meka.core.MLUtils;
import meka.core.Metrics;
import meka.core.Result;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.SerializationHelper;

public class MLPlanCLI {
    private static Logger logger = LoggerFactory.getLogger((String)"MLPlanCLI");
    private static String trainOption = "train";
    private static String testOption = "test";
    private static String totalTimeoutOption = "timeoutTotal";
    private static String nodeEvaluationTimeoutOption = "timeoutNodeEval";
    private static String solutionEvaluationTimeoutOption = "timeoutSolutionEval";
    private static String algorithmConfigurationOption = "algorithmConfig";
    private static String searchSpaceConfigurationOption = "searchSpaceConfig";
    private static String evaluationMeasureOption = "evaluationMeasure";
    private static String numCPUsOption = "numCPUS";
    private static String randomSeedOption = "randomSeed";
    private static String multiLabelOption = "multilabel";
    private static String positiveClassIndex = "positiveClassIndex";
    private static String totalTimeout = "150";
    private static String nodeEvaluationTimeout = "60";
    private static String solutionEvaluationTimeout = "60";
    private static String numCPUS = "4";
    private static String randomSeed = "0";
    private static String modelFileOption = "modelFile";
    private static String resultsFileOption = "resultsFile";
    private static String printModelOption = "printModel";
    private static String visualizeOption = "visualize";
    private static String helpOption = "help";
    private static String modelFile = "model.txt";
    private static String resultsFile = "results.txt";

    private MLPlanCLI() {
    }

    private static Options generateOptions() {
        Option train = Option.builder((String)"t").required(false).hasArg().longOpt(trainOption).desc("location of the .arff training data file").build();
        Option test = Option.builder((String)"T").required(false).longOpt(testOption).hasArg().desc("location of the .arff test data file").build();
        Option totalTimeout = Option.builder((String)"tt").longOpt(totalTimeoutOption).required(false).hasArg().desc("timeout for the complete run of mlplan in seconds").build();
        Option nodeEvaluationTimeout = Option.builder((String)"tne").longOpt(nodeEvaluationTimeoutOption).required(false).hasArg().desc("timeout for the evaluation of a single node in seconds").build();
        Option solutionEvaluation = Option.builder((String)"tse").longOpt(solutionEvaluationTimeoutOption).required(false).hasArg().desc("timeout for the evaluation of a solution in seconds").build();
        Option algorithmConfiguration = Option.builder((String)"ac").longOpt(algorithmConfigurationOption).required(false).hasArg().desc("configuration file for mlplan").build();
        Option searchSpaceConfiguration = Option.builder((String)"sc").longOpt(searchSpaceConfigurationOption).required(false).hasArg().desc("search space configuration file, or alternatively: weka, weka-tiny, sklearn, sklearn-ul, meka").build();
        Option evaluationMeasure = Option.builder((String)"em").longOpt(evaluationMeasureOption).required(false).hasArg().desc("measure for assessing solution quality, allowed values: \nsinglelabel: \nERRORRATE, MEAN_SQUARED_ERROR, PRECISION, ROOT_MEAN_SQUARED_ERROR \nmultilabel: \nAUTO_MEKA_GGP_FITNESS, AUTO_MEKA_GGP_FITNESS_LOSS, EXACT_MATCH_ACCURARY, EXACT_MATCH_LOSS, F1_MACRO_AVG_D, F1_MACRO_AVG_D_LOSS, F1_MACRO_AVG_L, F1_MACRO_AVG_L_LOSS,  HAMMING_ACCURACY, HAMMING_LOSS, JACCARD_LOSS, JACCARD_SCORE, RANK_LOSS, RANK_SCORE").build();
        Option positiveClass = Option.builder((String)"pci").longOpt(positiveClassIndex).required(false).hasArg(true).desc("Index of the class (in the list of classes) which is to be considered as the positive class").build();
        Option numCPUS = Option.builder((String)"ncpus").longOpt(numCPUsOption).required(false).hasArg().desc("number of used CPUs, default: " + MLPlanCLI.numCPUS).build();
        Option randomSeed = Option.builder((String)"rs").longOpt(randomSeedOption).required(false).hasArg().desc("randomization seed, default: " + MLPlanCLI.randomSeed).build();
        Option multiLabel = Option.builder((String)"ml").longOpt(multiLabelOption).required(false).hasArg(false).desc("enable for multilabel settings").build();
        Option modelFile = Option.builder((String)"mf").longOpt(modelFileOption).required(false).hasArg().desc("serialize model to the given output file, \"off\" if no model file shall be written; turn off for search spaces that contain non-serializable models").build();
        Option resultsFile = Option.builder((String)"rf").longOpt(resultsFileOption).required(false).hasArg().desc("serialize model to the given output file, \"off\" if no results file shall be written").build();
        Option visualize = Option.builder((String)"v").longOpt(visualizeOption).required(false).hasArg(false).desc("enable visualization").build();
        Option printModel = Option.builder((String)"p").longOpt(printModelOption).required(false).hasArg(false).desc("whether a visual representation of the final model shall be added to the model file").build();
        Option help = Option.builder((String)"h").longOpt(helpOption).required(false).hasArg(false).desc("supply help").build();
        Options options = new Options();
        options.addOption(train);
        options.addOption(test);
        options.addOption(totalTimeout);
        options.addOption(nodeEvaluationTimeout);
        options.addOption(solutionEvaluation);
        options.addOption(algorithmConfiguration);
        options.addOption(searchSpaceConfiguration);
        options.addOption(evaluationMeasure);
        options.addOption(numCPUS);
        options.addOption(randomSeed);
        options.addOption(multiLabel);
        options.addOption(resultsFile);
        options.addOption(modelFile);
        options.addOption(visualize);
        options.addOption(printModel);
        options.addOption(help);
        options.addOption(positiveClass);
        return options;
    }

    private static CommandLine generateCommandLine(Options options, String[] commandLineArguments) {
        DefaultParser cmdLineParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = cmdLineParser.parse(options, commandLineArguments);
        }
        catch (ParseException parseException) {
            logger.error("ERROR: Unable to parse command-line arguments {} due to {}", (Object)Arrays.toString(commandLineArguments), (Object)parseException);
        }
        return commandLine;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "mlplan";
        PrintWriter pw = new PrintWriter(System.out);
        formatter.printUsage(pw, 400, "mlplan", options);
        pw.println("use -h or --help for help");
        pw.flush();
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "mlplan [options]";
        formatter.printHelp("mlplan [options]", options);
    }

    private static void runMLPlan(CommandLine commandLine) throws Exception {
        AbstractMLPlanBuilder builder;
        File trainDataFile = new File(commandLine.getOptionValue(trainOption));
        logger.info("Load train data file: {}", (Object)trainDataFile.getAbsolutePath());
        Instances trainData = new Instances((Reader)new FileReader(trainDataFile));
        if (commandLine.hasOption(multiLabelOption)) {
            MLUtils.prepareData((Instances)trainData);
        } else {
            trainData.setClassIndex(trainData.numAttributes() - 1);
        }
        if (commandLine.hasOption(searchSpaceConfigurationOption)) {
            switch (commandLine.getOptionValue(searchSpaceConfigurationOption)) {
                case "weka": {
                    builder = AbstractMLPlanBuilder.forWeka();
                    break;
                }
                case "weka-tiny": {
                    builder = AbstractMLPlanBuilder.forWeka().withTinyWekaSearchSpace();
                    break;
                }
                case "sklearn": {
                    builder = AbstractMLPlanBuilder.forSKLearn();
                    break;
                }
                case "sklearn-ul": {
                    builder = AbstractMLPlanBuilder.forSKLearn().withUnlimitedLengthPipelineSearchSpace();
                    break;
                }
                case "meka": {
                    builder = AbstractMLPlanBuilder.forMeka();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not identify search space configuration");
                }
            }
        } else {
            builder = AbstractMLPlanBuilder.forWeka();
        }
        if (commandLine.hasOption(multiLabelOption)) {
            MLPlanMekaBuilder mekaBuilder = (MLPlanMekaBuilder)builder;
            switch (commandLine.getOptionValue(evaluationMeasureOption)) {
                case "AUTO_MEKA_GGP_FITNESS": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new AutoMEKAGGPFitnessMeasureLoss());
                    break;
                }
                case "EXACT_MATCH": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new ExactMatchLoss());
                    break;
                }
                case "F1_MACRO_AVG_D": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new InstanceWiseF1AsLoss());
                    break;
                }
                case "F1_MACRO_AVG_L": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new F1MacroAverageLLoss());
                    break;
                }
                case "HAMMING": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new HammingLoss());
                    break;
                }
                case "JACCARD": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new JaccardLoss());
                    break;
                }
                case "RANK_LOSS": {
                    mekaBuilder.withPerformanceMeasure((IMeasure<double[], Double>)new RankLoss());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid multilabel measure " + commandLine.getOptionValue(evaluationMeasureOption));
                }
            }
        } else {
            AbstractMLPlanSingleLabelBuilder slcBuilder = (AbstractMLPlanSingleLabelBuilder)builder;
            switch (commandLine.getOptionValue(evaluationMeasureOption)) {
                case "ERRORRATE": {
                    slcBuilder.withPerformanceMeasure((IMeasure<Double, Double>)new ZeroOneLoss());
                    break;
                }
                case "MEAN_SQUARED_ERROR": {
                    slcBuilder.withPerformanceMeasure((IMeasure<Double, Double>)new MeanSquaredErrorLoss());
                    break;
                }
                case "PRECISION": {
                    int classIndex = Integer.parseInt(commandLine.getOptionValue(positiveClassIndex, "0"));
                    slcBuilder.withPerformanceMeasure((IMeasure<Double, Double>)new PrecisionAsLoss(classIndex));
                    break;
                }
                case "ROOT_MEAN_SQUARED_ERROR": {
                    slcBuilder.withPerformanceMeasure((IMeasure<Double, Double>)new RootMeanSquaredErrorLoss());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid singlelabel measure " + commandLine.getOptionValue(evaluationMeasureOption));
                }
            }
        }
        if (commandLine.hasOption(algorithmConfigurationOption)) {
            File algoConfigFile = new File(commandLine.getOptionValue(algorithmConfigurationOption));
            builder.withAlgorithmConfigFile(algoConfigFile);
        }
        builder.withNodeEvaluationTimeOut(new TimeOut((long)Integer.parseInt(commandLine.getOptionValue(nodeEvaluationTimeoutOption, nodeEvaluationTimeout)), TimeUnit.SECONDS));
        builder.withCandidateEvaluationTimeOut(new TimeOut((long)Integer.parseInt(commandLine.getOptionValue(solutionEvaluationTimeoutOption, solutionEvaluationTimeout)), TimeUnit.SECONDS));
        builder.withTimeOut(new TimeOut((long)Integer.parseInt(commandLine.getOptionValue(totalTimeoutOption, totalTimeout)), TimeUnit.SECONDS));
        builder.withNumCpus(Integer.parseInt(commandLine.getOptionValue(numCPUsOption, numCPUS)));
        MLPlan mlplan = builder.build(trainData);
        mlplan.setLoggerName("mlplan");
        mlplan.setRandomSeed(Integer.parseInt(commandLine.getOptionValue(randomSeedOption, randomSeed)));
        Instances testData = null;
        if (commandLine.hasOption(testOption)) {
            File testDataFile = new File(commandLine.getOptionValue(testOption));
            logger.info("Load test data file: {}", (Object)testDataFile.getAbsolutePath());
            testData = new Instances((Reader)new FileReader(testDataFile));
            if (commandLine.hasOption(multiLabelOption)) {
                MLUtils.prepareData((Instances)testData);
            } else {
                testData.setClassIndex(testData.numAttributes() - 1);
            }
        }
        if (commandLine.hasOption(visualizeOption)) {
            new JFXPanel();
            AlgorithmVisualizationWindow window = commandLine.hasOption(testOption) ? new AlgorithmVisualizationWindow((IAlgorithm)mlplan, (IGUIPlugin)new GraphViewPlugin(), new IGUIPlugin[]{new NodeInfoGUIPlugin((NodeInfoGenerator)new JaicoreNodeInfoGenerator((NodeInfoGenerator)new TFDNodeInfoGenerator())), new SearchRolloutHistogramPlugin(), new SolutionPerformanceTimelinePlugin(), new HASCOModelStatisticsPlugin(), new OutOfSampleErrorPlotPlugin(trainData, testData)}) : new AlgorithmVisualizationWindow((IAlgorithm)mlplan, (IGUIPlugin)new GraphViewPlugin(), new IGUIPlugin[]{new NodeInfoGUIPlugin((NodeInfoGenerator)new JaicoreNodeInfoGenerator((NodeInfoGenerator)new TFDNodeInfoGenerator())), new SearchRolloutHistogramPlugin(), new SolutionPerformanceTimelinePlugin(), new HASCOModelStatisticsPlugin()});
            Platform.runLater((Runnable)window);
        }
        logger.info("Build mlplan classifier");
        Classifier optimizedClassifier = mlplan.call();
        logger.info("Open timeout tasks: {}", (Object)GlobalTimer.getInstance().getActiveTasks());
        if (!"off".equals(commandLine.getOptionValue(modelFileOption))) {
            MLPlanCLI.serializeModel(commandLine, mlplan.getSelectedClassifier());
        }
        if (commandLine.hasOption(testOption)) {
            double error = -1.0;
            if (commandLine.hasOption(multiLabelOption)) {
                logger.info("Assess test performance...");
                Result result = Evaluation.evaluateModel((MultiXClassifier)((MultiLabelClassifier)mlplan.getSelectedClassifier()), (Instances)trainData, (Instances)testData);
                switch (commandLine.getOptionValue(evaluationMeasureOption, "AUTO_MEKA_GGP_FITNESS_LOSS")) {
                    case "AUTO_MEKA_GGP_FITNESS": {
                        error = (Metrics.P_ExactMatch((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5)) + (1.0 - Metrics.L_Hamming((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5))) + Metrics.P_FmacroAvgL((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5)) + (1.0 - Metrics.L_RankLoss((int[][])result.allTrueValues(), (double[][])result.allPredictions()))) / 4.0;
                        break;
                    }
                    case "AUTO_MEKA_GGP_FITNESS_LOSS": {
                        error = 1.0 - (Metrics.P_ExactMatch((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5)) + (1.0 - Metrics.L_Hamming((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5))) + Metrics.P_FmacroAvgL((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5)) + (1.0 - Metrics.L_RankLoss((int[][])result.allTrueValues(), (double[][])result.allPredictions()))) / 4.0;
                        break;
                    }
                    case "EXACT_MATCH_ACCURARY": {
                        error = Metrics.P_ExactMatch((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "EXACT_MATCH_LOSS": {
                        error = 1.0 - Metrics.P_ExactMatch((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "F1_MACRO_AVG_D": {
                        error = Metrics.P_FmacroAvgD((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "F1_MACRO_AVG_D_LOSS": {
                        error = 1.0 - Metrics.P_FmacroAvgD((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "F1_MACRO_AVG_L": {
                        error = Metrics.P_FmacroAvgL((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "F1_MACRO_AVG_L_LOSS": {
                        error = 1.0 - Metrics.P_FmacroAvgL((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "HAMMING_ACCURACY": {
                        error = Metrics.P_Hamming((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "HAMMING_LOSS": {
                        error = Metrics.L_Hamming((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "JACCARD_LOSS": {
                        error = Metrics.L_JaccardDist((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "JACCARD_SCORE": {
                        error = Metrics.P_JaccardIndex((int[][])result.allTrueValues(), (int[][])result.allPredictions(0.5));
                        break;
                    }
                    case "RANK_LOSS": {
                        error = Metrics.L_RankLoss((int[][])result.allTrueValues(), (double[][])result.allPredictions());
                        break;
                    }
                    case "RANK_SCORE": {
                        error = 1.0 - Metrics.L_RankLoss((int[][])result.allTrueValues(), (double[][])result.allPredictions());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid multilabel measure " + commandLine.getOptionValue(evaluationMeasureOption));
                    }
                }
                if (!"off".equals(commandLine.getOptionValue(resultsFileOption))) {
                    MLPlanCLI.writeMultiLabelEvaluationFile(result, mlplan.getInternalValidationErrorOfSelectedClassifier(), commandLine, mlplan.getSelectedClassifier());
                }
            } else {
                weka.classifiers.evaluation.Evaluation eval = new weka.classifiers.evaluation.Evaluation(trainData);
                logger.info("Assess test performance...");
                eval.evaluateModel(optimizedClassifier, testData, new Object[0]);
                switch (commandLine.getOptionValue(evaluationMeasureOption, "ERRORRATE")) {
                    case "ERRORRATE": {
                        error = eval.errorRate();
                        break;
                    }
                    case "MEAN_SQUARED_ERROR": {
                        error = Math.pow(eval.rootMeanSquaredError(), 2.0);
                        break;
                    }
                    case "ROOT_MEAN_SQUARED_ERROR": {
                        error = eval.rootMeanSquaredError();
                        break;
                    }
                    case "PRECISION": {
                        error = 1.0 - eval.precision(Integer.parseInt(commandLine.getOptionValue(positiveClassIndex, "0")));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid singlelabel measure " + commandLine.getOptionValue(evaluationMeasureOption));
                    }
                }
                if (!"off".equals(commandLine.getOptionValue(resultsFileOption))) {
                    MLPlanCLI.writeSingleLabelEvaluationFile(eval, mlplan.getInternalValidationErrorOfSelectedClassifier(), commandLine, mlplan.getSelectedClassifier());
                }
            }
            logger.info("Test error was {}. Internally estimated error for this model was {}", (Object)error, (Object)mlplan.getInternalValidationErrorOfSelectedClassifier());
        }
        logger.info("Experiment done.");
    }

    private static void serializeModel(CommandLine commandLine, Classifier bestClassifier) throws Exception {
        SerializationHelper.write((String)commandLine.getOptionValue(modelFileOption, modelFile), (Object)bestClassifier);
    }

    private static void writeMultiLabelEvaluationFile(Result result, double internalError, CommandLine commandLine, Classifier bestModel) {
        StringBuilder builder = new StringBuilder();
        builder.append("Internally believed error: ");
        builder.append(internalError);
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("Best Model: ");
        builder.append(System.lineSeparator());
        builder.append(bestModel.toString());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(result.toString());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        if (commandLine.hasOption(printModelOption)) {
            builder.append("Classifier Representation: ");
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
            if (bestModel instanceof MLPipeline) {
                builder.append(((MLPipeline)bestModel).getBaseClassifier().toString());
            } else {
                builder.append(bestModel.toString());
            }
        }
        MLPlanCLI.writeFile(commandLine.getOptionValue(resultsFileOption, resultsFile), builder.toString());
    }

    private static void writeSingleLabelEvaluationFile(weka.classifiers.evaluation.Evaluation eval, double internalError, CommandLine commandLine, Classifier bestModel) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("Internally believed error: ");
        builder.append(internalError);
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("Best Model: ");
        builder.append(System.lineSeparator());
        builder.append(bestModel.toString());
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(eval.toSummaryString("Summary", true));
        builder.append(System.lineSeparator());
        builder.append(eval.toClassDetailsString("Class Details"));
        builder.append(System.lineSeparator());
        builder.append("Evaluation Overview");
        builder.append(System.lineSeparator());
        builder.append(eval.toCumulativeMarginDistributionString());
        builder.append(System.lineSeparator());
        builder.append(eval.toMatrixString("Matrix"));
        if (commandLine.hasOption(printModelOption)) {
            builder.append("Classifier Representation: ");
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
            if (bestModel instanceof MLPipeline) {
                builder.append(((MLPipeline)bestModel).getBaseClassifier().toString());
            } else {
                builder.append(bestModel.toString());
            }
        }
        MLPlanCLI.writeFile(commandLine.getOptionValue(resultsFileOption, resultsFile), builder.toString());
    }

    private static void writeFile(String fileName, String value) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(new File(fileName)));){
            bw.write(value);
        }
        catch (IOException e) {
            logger.error("Could not write value to file {}: {}", (Object)fileName, (Object)value);
        }
    }

    public static void main(String[] args) throws Exception {
        Options options = MLPlanCLI.generateOptions();
        if (args.length == 0) {
            MLPlanCLI.printUsage(options);
        } else {
            CommandLine commandLine = MLPlanCLI.generateCommandLine(options, args);
            if (commandLine != null) {
                if (commandLine.hasOption(helpOption)) {
                    MLPlanCLI.printHelp(options);
                } else {
                    MLPlanCLI.runMLPlan(commandLine);
                }
            }
        }
    }
}

