/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.core.HASCOConfig;
import ai.libs.hasco.core.HASCOFactory;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.serialization.ComponentLoader;
import ai.libs.hasco.variants.forwarddecomposition.HASCOViaFDAndBestFirstFactory;
import ai.libs.hasco.variants.forwarddecomposition.HASCOViaFDFactory;
import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.LearningCurveExtrapolationEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.ClassifierEvaluatorConstructionFailedException;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.IClassifierEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.StandardBestFirstFactory;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.AlternativeNodeEvaluator;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import ai.libs.jaicore.search.core.interfaces.IOptimalPathInORGraphSearchFactory;
import ai.libs.jaicore.search.problemtransformers.GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS;
import ai.libs.mlpipeline_evaluation.PerformanceDBAdapter;
import ai.libs.mlplan.core.IMLPlanBuilder;
import ai.libs.mlplan.core.MLPlan;
import ai.libs.mlplan.core.MLPlanMekaBuilder;
import ai.libs.mlplan.core.MLPlanSKLearnBuilder;
import ai.libs.mlplan.core.MLPlanWekaBuilder;
import ai.libs.mlplan.core.PipelineEvaluator;
import ai.libs.mlplan.core.PipelineValidityCheckingNodeEvaluator;
import ai.libs.mlplan.multiclass.MLPlanClassifierConfig;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import ai.libs.mlplan.multiclass.wekamlplan.weka.PreferenceBasedNodeEvaluator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public abstract class AbstractMLPlanBuilder
implements IMLPlanBuilder,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(AbstractMLPlanBuilder.class);
    private String loggerName = AbstractMLPlanBuilder.class.getName();
    private static final String RES_ALGORITHM_CONFIG = "mlplan/mlplan.properties";
    private static final String FS_ALGORITHM_CONFIG = "conf/mlplan.properties";
    private static final File DEF_ALGORITHM_CONFIG = FileUtil.getExistingFileWithHighestPriority((String)"mlplan/mlplan.properties", (String[])new String[]{"conf/mlplan.properties"});
    private boolean factoryPreparedWithData = false;
    private MLPlanClassifierConfig algorithmConfig;
    private HASCOViaFDFactory hascoFactory = new HASCOViaFDFactory();
    private Predicate<TFDNode> priorizingPredicate = null;
    private File searchSpaceFile;
    private String requestedHASCOInterface;
    private IClassifierFactory classifierFactory;
    private INodeEvaluator<TFDNode, Double> preferredNodeEvaluator = null;
    private PipelineValidityCheckingNodeEvaluator pipelineValidityCheckingNodeEvaluator;
    private IDatasetSplitter searchSelectionDatasetSplitter;
    private IClassifierEvaluatorFactory factoryForPipelineEvaluationInSearchPhase = null;
    private IClassifierEvaluatorFactory factoryForPipelineEvaluationInSelectionPhase = null;
    private Collection<Component> components = new LinkedList<Component>();
    private String performanceMeasureName;
    private boolean useCache;
    private PerformanceDBAdapter dbAdapter = null;
    private Instances dataset;

    protected AbstractMLPlanBuilder() {
        this.withAlgorithmConfigFile(DEF_ALGORITHM_CONFIG);
        this.withRandomCompletionBasedBestFirstSearch();
    }

    public static MLPlanSKLearnBuilder forSKLearn() throws IOException {
        return new MLPlanSKLearnBuilder();
    }

    public static MLPlanWekaBuilder forWeka() throws IOException {
        return new MLPlanWekaBuilder();
    }

    public static MLPlanMekaBuilder forMeka() throws IOException {
        return new MLPlanMekaBuilder();
    }

    public AbstractMLPlanBuilder withPreferredNodeEvaluator(INodeEvaluator<TFDNode, Double> preferredNodeEvaluator) {
        if (this.factoryPreparedWithData) {
            throw new IllegalStateException("The method prepareNodeEvaluatorInFactoryWithData has already been called. No changes to the preferred node evaluator possible anymore");
        }
        this.preferredNodeEvaluator = this.preferredNodeEvaluator == null ? preferredNodeEvaluator : new AlternativeNodeEvaluator(preferredNodeEvaluator, this.preferredNodeEvaluator);
        this.update();
        return this;
    }

    public AbstractMLPlanBuilder withSearchFactory(IOptimalPathInORGraphSearchFactory searchFactory, AlgorithmicProblemReduction transformer) {
        this.hascoFactory.setSearchFactory(searchFactory);
        this.hascoFactory.setSearchProblemTransformer(transformer);
        return this;
    }

    public AbstractMLPlanBuilder withRandomCompletionBasedBestFirstSearch() {
        this.hascoFactory.setSearchFactory((IOptimalPathInORGraphSearchFactory)new StandardBestFirstFactory());
        this.update();
        return this;
    }

    public Collection<Component> getComponents() throws IOException {
        return new ComponentLoader(this.searchSpaceFile).getComponents();
    }

    public AbstractMLPlanBuilder withAlgorithmConfigFile(File algorithmConfigFile) {
        return this.withAlgorithmConfig((MLPlanClassifierConfig)((MLPlanClassifierConfig)ConfigFactory.create(MLPlanClassifierConfig.class, (Map[])new Map[0])).loadPropertiesFromFile(algorithmConfigFile));
    }

    public AbstractMLPlanBuilder withAlgorithmConfig(MLPlanClassifierConfig config) {
        this.algorithmConfig = config;
        this.hascoFactory.withAlgorithmConfig((HASCOConfig)this.algorithmConfig);
        this.update();
        return this;
    }

    public AbstractMLPlanBuilder withPreferredComponentsFile(File preferredComponentsFile) throws IOException {
        ArrayList<String> ordering;
        this.getAlgorithmConfig().setProperty("mlplan.preferredComponents", preferredComponentsFile.getAbsolutePath());
        if (!preferredComponentsFile.exists()) {
            this.logger.warn("The configured file for preferred components \"{}\" does not exist. Not using any particular ordering.", (Object)preferredComponentsFile.getAbsolutePath());
            ordering = new ArrayList<String>();
        } else {
            ordering = FileUtil.readFileAsList((File)preferredComponentsFile);
        }
        return this.withPreferredNodeEvaluator(new PreferenceBasedNodeEvaluator(this.components, ordering));
    }

    public void setPerformanceMeasureName(String name) {
        this.performanceMeasureName = name;
    }

    public AbstractMLPlanBuilder withDataset(Instances dataset) {
        this.dataset = dataset;
        return this;
    }

    public AbstractMLPlanBuilder withSearchSpaceConfigFile(File searchSpaceConfig) throws IOException {
        FileUtil.requireFileExists((File)searchSpaceConfig);
        this.searchSpaceFile = searchSpaceConfig;
        this.components.clear();
        this.components.addAll(new ComponentLoader(this.searchSpaceFile).getComponents());
        return this;
    }

    public AbstractMLPlanBuilder withClassifierFactory(IClassifierFactory classifierFactory) {
        this.classifierFactory = classifierFactory;
        return this;
    }

    public AbstractMLPlanBuilder withDatasetSplitterForSearchSelectionSplit(IDatasetSplitter datasetSplitter) {
        this.searchSelectionDatasetSplitter = datasetSplitter;
        return this;
    }

    public AbstractMLPlanBuilder withRequestedInterface(String requestedInterface) {
        this.requestedHASCOInterface = requestedInterface;
        return this;
    }

    public AbstractMLPlanBuilder withTimeOut(TimeOut timeout) {
        this.algorithmConfig.setProperty("timeout", timeout.milliseconds() + "");
        this.update();
        return this;
    }

    public TimeOut getTimeOut() {
        return new TimeOut(this.algorithmConfig.timeout(), TimeUnit.MILLISECONDS);
    }

    public AbstractMLPlanBuilder withNodeEvaluationTimeOut(TimeOut timeout) {
        this.algorithmConfig.setProperty("hasco.random_completions.timeout_node", timeout.milliseconds() + "");
        this.update();
        return this;
    }

    public TimeOut getNodeEvaluationTimeOut() {
        return new TimeOut((long)this.algorithmConfig.timeoutForNodeEvaluation(), TimeUnit.MILLISECONDS);
    }

    public AbstractMLPlanBuilder withCandidateEvaluationTimeOut(TimeOut timeout) {
        this.algorithmConfig.setProperty("hasco.random_completions.timeout_path", timeout.milliseconds() + "");
        this.update();
        return this;
    }

    public TimeOut getCandidateEvaluationTimeOut() {
        return new TimeOut((long)this.algorithmConfig.timeoutForCandidateEvaluation(), TimeUnit.MILLISECONDS);
    }

    @Override
    public PipelineEvaluator getClassifierEvaluationInSearchPhase(Instances data, int seed, int fullDatasetSize) throws ClassifierEvaluatorConstructionFailedException {
        Objects.requireNonNull(this.factoryForPipelineEvaluationInSearchPhase, "No factory for pipeline evaluation in search phase has been set!");
        IClassifierEvaluator evaluator = this.factoryForPipelineEvaluationInSearchPhase.getIClassifierEvaluator(data, (long)seed);
        if (evaluator instanceof LearningCurveExtrapolationEvaluator) {
            ((LearningCurveExtrapolationEvaluator)evaluator).setFullDatasetSize(fullDatasetSize);
        }
        return new PipelineEvaluator(this.getClassifierFactory(), evaluator, this.getAlgorithmConfig().timeoutForCandidateEvaluation());
    }

    @Override
    public PipelineEvaluator getClassifierEvaluationInSelectionPhase(Instances data, int seed) throws ClassifierEvaluatorConstructionFailedException {
        if (this.factoryForPipelineEvaluationInSelectionPhase == null) {
            throw new IllegalStateException("No factory for pipeline evaluation in selection phase has been set!");
        }
        return new PipelineEvaluator(this.getClassifierFactory(), this.factoryForPipelineEvaluationInSelectionPhase.getIClassifierEvaluator(data, (long)seed), Integer.MAX_VALUE);
    }

    public void withSearchPhaseEvaluatorFactory(IClassifierEvaluatorFactory evaluatorFactory) {
        this.factoryForPipelineEvaluationInSearchPhase = evaluatorFactory;
    }

    protected IClassifierEvaluatorFactory getSearchEvaluatorFactory() {
        return this.factoryForPipelineEvaluationInSearchPhase;
    }

    public AbstractMLPlanBuilder withSelectionPhaseEvaluatorFactory(MonteCarloCrossValidationEvaluatorFactory evaluatorFactory) {
        this.factoryForPipelineEvaluationInSelectionPhase = evaluatorFactory;
        return this;
    }

    public AbstractMLPlanBuilder withNumCpus(int numCpus) {
        this.algorithmConfig.setProperty("cpus", numCpus + "");
        this.update();
        return this;
    }

    protected IClassifierEvaluatorFactory getSelectionEvaluatorFactory() {
        return this.factoryForPipelineEvaluationInSelectionPhase;
    }

    @Override
    public String getPerformanceMeasureName() {
        return this.performanceMeasureName;
    }

    public HASCOFactory getHASCOFactory() {
        return this.hascoFactory;
    }

    @Override
    public IClassifierFactory getClassifierFactory() {
        return this.classifierFactory;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.loggerName = name;
    }

    @Override
    public String getRequestedInterface() {
        return this.requestedHASCOInterface;
    }

    @Override
    public IDatasetSplitter getSearchSelectionDatasetSplitter() {
        return this.searchSelectionDatasetSplitter;
    }

    @Override
    public File getSearchSpaceConfigFile() {
        return this.searchSpaceFile;
    }

    @Override
    public MLPlanClassifierConfig getAlgorithmConfig() {
        return this.algorithmConfig;
    }

    @Override
    public boolean getUseCache() {
        return this.useCache;
    }

    @Override
    public PerformanceDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    @Override
    public void prepareNodeEvaluatorInFactoryWithData(Instances data) {
        PipelineValidityCheckingNodeEvaluator actualNodeEvaluator;
        if (!(this.hascoFactory instanceof HASCOViaFDAndBestFirstFactory)) {
            return;
        }
        if (this.factoryPreparedWithData) {
            throw new IllegalStateException("Factory has already been prepared with data. This can only be done once!");
        }
        this.factoryPreparedWithData = true;
        if (this.pipelineValidityCheckingNodeEvaluator == null && this.preferredNodeEvaluator == null) {
            return;
        }
        if (this.pipelineValidityCheckingNodeEvaluator != null) {
            this.pipelineValidityCheckingNodeEvaluator.setComponents(this.components);
            this.pipelineValidityCheckingNodeEvaluator.setData(data);
            actualNodeEvaluator = this.preferredNodeEvaluator != null ? new AlternativeNodeEvaluator((INodeEvaluator)this.pipelineValidityCheckingNodeEvaluator, this.preferredNodeEvaluator) : this.pipelineValidityCheckingNodeEvaluator;
        } else {
            actualNodeEvaluator = this.preferredNodeEvaluator;
        }
        this.preferredNodeEvaluator = actualNodeEvaluator;
        this.update();
    }

    private void update() {
        this.hascoFactory.setSearchProblemTransformer((AlgorithmicProblemReduction)new GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS(this.preferredNodeEvaluator, this.priorizingPredicate, this.algorithmConfig.randomSeed(), this.algorithmConfig.numberOfRandomCompletions(), this.algorithmConfig.timeoutForCandidateEvaluation(), this.algorithmConfig.timeoutForNodeEvaluation()));
        this.hascoFactory.withAlgorithmConfig((HASCOConfig)this.getAlgorithmConfig());
    }

    public MLPlan build(Instances dataset) {
        this.dataset = dataset;
        return this.build();
    }

    public MLPlan build() {
        Objects.requireNonNull(this.dataset, "A dataset needs to be provided as input to ML-Plan");
        MLPlan mlplan = new MLPlan(this, this.dataset);
        mlplan.setTimeout(this.getTimeOut());
        return mlplan;
    }
}

