/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.core.HASCOFactory;
import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.SoftwareConfigurationProblem;
import ai.libs.hasco.events.HASCOSolutionEvent;
import ai.libs.hasco.exceptions.ComponentInstantiationFailedException;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.optimizingfactory.BaseFactory;
import ai.libs.hasco.optimizingfactory.OptimizingFactory;
import ai.libs.hasco.optimizingfactory.OptimizingFactoryProblem;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseHASCO;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseHASCOConfig;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseHASCOFactory;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseSoftwareConfigurationProblem;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.events.MCCVSplitEvaluationEvent;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.ClassifierEvaluatorConstructionFailedException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolatedEvent;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import ai.libs.mlplan.core.IMLPlanBuilder;
import ai.libs.mlplan.core.PipelineEvaluator;
import ai.libs.mlplan.core.events.ClassifierCreatedEvent;
import ai.libs.mlplan.core.events.ClassifierFoundEvent;
import ai.libs.mlplan.multiclass.MLPlanClassifierConfig;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class MLPlan
extends AAlgorithm<Instances, Classifier>
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(MLPlan.class);
    private String loggerName;
    private Classifier selectedClassifier;
    private double internalValidationErrorOfSelectedClassifier;
    private ComponentInstance componentInstanceOfSelectedClassifier;
    private final IMLPlanBuilder builder;
    private final Instances data;
    private TwoPhaseHASCOFactory<GraphSearchInput<TFDNode, String>, TFDNode, String> twoPhaseHASCOFactory;
    private OptimizingFactory<TwoPhaseSoftwareConfigurationProblem, Classifier, HASCOSolutionCandidate<Double>, Double> optimizingFactory;
    private boolean buildSelectedClasifierOnGivenData = true;

    public MLPlan(IMLPlanBuilder builder, Instances data) {
        super((IAlgorithmConfig)builder.getAlgorithmConfig(), (Object)data);
        builder.prepareNodeEvaluatorInFactoryWithData(data);
        if (builder.getSearchSpaceConfigFile() == null || !builder.getSearchSpaceConfigFile().exists()) {
            throw new IllegalArgumentException("The search space configuration file must be set in MLPlanBuilder, and it must be set to a file that exists!");
        }
        if (builder.getClassifierFactory() == null) {
            throw new IllegalArgumentException("ClassifierFactory must be set in MLPlanBuilder!");
        }
        this.builder = builder;
        this.data = data;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        switch (this.getState()) {
            case created: {
                PipelineEvaluator classifierEvaluatorForSelection;
                PipelineEvaluator classifierEvaluatorForSearch;
                this.logger.info("Starting an ML-Plan instance.");
                AlgorithmInitializedEvent event = this.activate();
                if (this.getConfig().cpus() < 1) {
                    throw new IllegalStateException("Cannot generate search where number of CPUs is " + this.getConfig().cpus());
                }
                final double dataPortionUsedForSelection = this.getConfig().dataPortionForSelection();
                this.logger.debug("Splitting given {} data points into search data ({}%) and selection data ({}%).", new Object[]{this.data.size(), MathExt.round((double)((1.0 - dataPortionUsedForSelection) * 100.0), (int)2), MathExt.round((double)dataPortionUsedForSelection, (int)2)});
                Instances dataShownToSearch = dataPortionUsedForSelection > 0.0 ? (Instances)this.builder.getSearchSelectionDatasetSplitter().split((Instances)this.getInput(), (long)this.getConfig().randomSeed(), new double[]{dataPortionUsedForSelection}).get(1) : (Instances)this.getInput();
                if (dataShownToSearch.isEmpty()) {
                    throw new IllegalStateException("Cannot search on no data.");
                }
                if (Double.isNaN(this.getConfig().expectedBlowupInSelection())) {
                    double blowUpInSelectionPhase = 1.0;
                    this.getConfig().setProperty("hasco.blowup.selection", String.valueOf(blowUpInSelectionPhase));
                    this.logger.info("No expected blow-up for selection phase has been defined. Automatically configuring {}", (Object)blowUpInSelectionPhase);
                }
                if (!this.buildSelectedClasifierOnGivenData) {
                    this.getConfig().setProperty("hasco.blowup.postprocess", String.valueOf(0));
                    this.logger.info("Selected classifier won't be built, so now blow-up is calculated.");
                } else if (Double.isNaN(this.getConfig().expectedBlowupInPostprocessing())) {
                    double blowUpInPostprocessing = 1.0;
                    this.getConfig().setProperty("hasco.blowup.postprocess", String.valueOf(blowUpInPostprocessing));
                    this.logger.info("No expected blow-up for postprocessing phase has been defined. Automatically configuring {}", (Object)blowUpInPostprocessing);
                }
                this.logger.debug("Setting up the pipeline evaluators.");
                try {
                    classifierEvaluatorForSearch = this.builder.getClassifierEvaluationInSearchPhase(dataShownToSearch, this.getConfig().randomSeed(), ((Instances)this.getInput()).size());
                    classifierEvaluatorForSelection = this.builder.getClassifierEvaluationInSelectionPhase(dataShownToSearch, this.getConfig().randomSeed());
                }
                catch (ClassifierEvaluatorConstructionFailedException e2) {
                    throw new AlgorithmException((Throwable)e2, "Could not create the pipeline evaluator");
                }
                classifierEvaluatorForSearch.registerListener((Object)this);
                classifierEvaluatorForSelection.registerListener((Object)this);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Starting ML-Plan with the following setup:\n\tDataset: {}\n\tTarget: {}\n\tCPUs: {}\n\tTimeout: {}s\n\tTimeout for single candidate evaluation: {}s\n\tTimeout for node evaluation: {}s\n\tRandom Completions per node evaluation: {}\n\tPortion of data for selection phase: {}%\n\tPipeline evaluation during search: {}\n\tPipeline evaluation during selection: {}\n\tBlow-ups are {} for selection phase and {} for post-processing phase.", new Object[]{((Instances)this.getInput()).hashCode(), this.builder.getPerformanceMeasureName(), this.getConfig().cpus(), this.getTimeout().seconds(), this.getConfig().timeoutForCandidateEvaluation() / 1000, this.getConfig().timeoutForNodeEvaluation() / 1000, this.getConfig().numberOfRandomCompletions(), MathExt.round((double)(this.getConfig().dataPortionForSelection() * 100.0), (int)2), classifierEvaluatorForSearch, classifierEvaluatorForSelection, this.getConfig().expectedBlowupInSelection(), this.getConfig().expectedBlowupInPostprocessing()});
                }
                this.logger.debug("Creating 2-phase software configuration problem.");
                TwoPhaseSoftwareConfigurationProblem problem = null;
                try {
                    problem = new TwoPhaseSoftwareConfigurationProblem(this.builder.getSearchSpaceConfigFile(), this.builder.getRequestedInterface(), (IObjectEvaluator)classifierEvaluatorForSearch, (IObjectEvaluator)classifierEvaluatorForSelection);
                }
                catch (IOException e1) {
                    throw new AlgorithmException((Throwable)e1, "Could not activate ML-Plan!");
                }
                this.logger.info("Creating the twoPhaseHASCOFactory.");
                OptimizingFactoryProblem optimizingFactoryProblem = new OptimizingFactoryProblem((BaseFactory)this.builder.getClassifierFactory(), (SoftwareConfigurationProblem)problem);
                HASCOFactory<GraphSearchInput<TFDNode, String>, TFDNode, String, Double> hascoFactory = this.builder.getHASCOFactory();
                this.twoPhaseHASCOFactory = new TwoPhaseHASCOFactory(hascoFactory);
                this.twoPhaseHASCOFactory.setConfig((TwoPhaseHASCOConfig)this.getConfig());
                this.optimizingFactory = new OptimizingFactory(optimizingFactoryProblem, this.twoPhaseHASCOFactory);
                this.logger.info("Setting logger of {} to {}.optimizingfactory", (Object)this.optimizingFactory.getClass().getName(), (Object)this.loggerName);
                this.optimizingFactory.setLoggerName(this.loggerName + ".optimizingfactory");
                this.optimizingFactory.registerListener(new Object(){

                    @Subscribe
                    public void receiveEventFromFactory(AlgorithmEvent event) {
                        if (event instanceof AlgorithmInitializedEvent || event instanceof AlgorithmFinishedEvent) {
                            return;
                        }
                        if (event instanceof HASCOSolutionEvent) {
                            HASCOSolutionCandidate solution = (HASCOSolutionCandidate)((HASCOSolutionEvent)event).getSolutionCandidate();
                            try {
                                MLPlan.this.logger.info("Received new solution {} with score {} and evaluation time {}ms", new Object[]{MLPlan.this.builder.getClassifierFactory().getComponentInstantiation(solution.getComponentInstance()), solution.getScore(), solution.getTimeToEvaluateCandidate()});
                            }
                            catch (Exception e) {
                                MLPlan.this.logger.warn("Could not print log due to exception while preparing the log message.", (Throwable)e);
                            }
                            if (dataPortionUsedForSelection == 0.0 && (Double)solution.getScore() < MLPlan.this.internalValidationErrorOfSelectedClassifier) {
                                try {
                                    MLPlan.this.selectedClassifier = (Classifier)MLPlan.this.builder.getClassifierFactory().getComponentInstantiation(solution.getComponentInstance());
                                    MLPlan.this.internalValidationErrorOfSelectedClassifier = (Double)solution.getScore();
                                    MLPlan.this.componentInstanceOfSelectedClassifier = solution.getComponentInstance();
                                }
                                catch (ComponentInstantiationFailedException e) {
                                    MLPlan.this.logger.error("Could not update selectedClassifier with newly best seen solution due to issues building the classifier from its ComponentInstance description.", (Throwable)e);
                                }
                            }
                            try {
                                MLPlan.this.post((Object)new ClassifierFoundEvent(MLPlan.this.getId(), solution.getComponentInstance(), (Classifier)MLPlan.this.builder.getClassifierFactory().getComponentInstantiation(solution.getComponentInstance()), (Double)solution.getScore()));
                            }
                            catch (ComponentInstantiationFailedException e) {
                                MLPlan.this.logger.error("An issue occurred while preparing the description for the post of a ClassifierFoundEvent", (Throwable)e);
                            }
                        } else {
                            MLPlan.this.post(event);
                        }
                    }
                });
                this.logger.info("Initializing the optimization factory.");
                this.optimizingFactory.init();
                this.logger.info("Started and activated ML-Plan.");
                return event;
            }
            case active: {
                long startOptimizationTime = System.currentTimeMillis();
                try {
                    this.selectedClassifier = (Classifier)this.optimizingFactory.call();
                    this.logger.info("2-Phase-HASCO has chosen classifier {}, which will now be built on the entire data given, i.e. {} data points.", (Object)this.selectedClassifier, (Object)((Instances)this.getInput()).size());
                }
                catch (AlgorithmExecutionCanceledException | AlgorithmException | AlgorithmTimeoutedException | InterruptedException e) {
                    this.terminate();
                    throw e;
                }
                this.internalValidationErrorOfSelectedClassifier = (Double)this.optimizingFactory.getPerformanceOfObject();
                this.componentInstanceOfSelectedClassifier = this.optimizingFactory.getComponentInstanceOfObject();
                if (this.buildSelectedClasifierOnGivenData) {
                    long startBuildTime = System.currentTimeMillis();
                    try {
                        this.selectedClassifier.buildClassifier((Instances)this.getInput());
                    }
                    catch (Exception e) {
                        throw new AlgorithmException((Throwable)e, "Training the classifier failed!");
                    }
                    long endBuildTime = System.currentTimeMillis();
                    this.logger.info("Selected model has been built on entire dataset. Build time of chosen model was {}ms. Total construction time was {}ms. The chosen classifier is: {}", new Object[]{endBuildTime - startBuildTime, endBuildTime - startOptimizationTime, this.selectedClassifier});
                } else {
                    this.logger.info("Selected model has not been built, since model building has been disabled. Total construction time was {}ms.", (Object)(System.currentTimeMillis() - startOptimizationTime));
                }
                return this.terminate();
            }
        }
        throw new IllegalStateException("Cannot do anything in state " + this.getState());
    }

    public Classifier call() throws AlgorithmException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.selectedClassifier;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger name to {}", (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated ML-Plan logger {}. Now setting logger of twoPhaseHASCO to {}.2phasehasco", (Object)name, (Object)name);
        if (this.optimizingFactory != null) {
            this.logger.info("Setting logger of {} to {}.optimizingfactory", (Object)this.optimizingFactory.getClass().getName(), (Object)this.loggerName);
            this.optimizingFactory.setLoggerName(this.loggerName + ".optimizingfactory");
        } else {
            this.logger.debug("Optimizingfactory has not been set yet, so not customizing its logger.");
        }
        this.logger.info("Switched ML-Plan logger to {}", (Object)name);
    }

    public void setPortionOfDataForPhase2(float portion) {
        this.getConfig().setProperty("mlplan.selection.mccvPortion", String.valueOf(portion));
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public MLPlanClassifierConfig getConfig() {
        return (MLPlanClassifierConfig)super.getConfig();
    }

    public void setRandomSeed(int seed) {
        this.getConfig().setProperty("hasco.seed", String.valueOf(seed));
    }

    public Classifier getSelectedClassifier() {
        return this.selectedClassifier;
    }

    public ComponentInstance getComponentInstanceOfSelectedClassifier() {
        return this.componentInstanceOfSelectedClassifier;
    }

    public GraphGenerator<TFDNode, String> getGraphGenerator() {
        return ((TwoPhaseHASCO)this.optimizingFactory.getOptimizer()).getGraphGenerator();
    }

    public double getInternalValidationErrorOfSelectedClassifier() {
        return this.internalValidationErrorOfSelectedClassifier;
    }

    public synchronized void cancel() {
        this.logger.info("Received cancel. First canceling optimizer, then invoking general shutdown.");
        this.optimizingFactory.cancel();
        this.logger.debug("Now canceling main ML-Plan routine");
        super.cancel();
        assert (this.isCanceled()) : "Canceled-flag is not positive at the end of the cancel routine!";
        this.logger.info("Completed cancellation of ML-Plan. Cancel status is {}", (Object)this.isCanceled());
    }

    public OptimizingFactory<TwoPhaseSoftwareConfigurationProblem, Classifier, HASCOSolutionCandidate<Double>, Double> getOptimizingFactory() {
        return this.optimizingFactory;
    }

    @Subscribe
    public void receiveClassifierCreatedEvent(ClassifierCreatedEvent e) {
        this.post(e);
    }

    @Subscribe
    public void receiveClassifierCreatedEvent(LearningCurveExtrapolatedEvent e) {
        this.post(e);
    }

    @Subscribe
    public void receiveClassifierCreatedEvent(MCCVSplitEvaluationEvent e) {
        this.post(e);
    }

    public TwoPhaseHASCOFactory<GraphSearchInput<TFDNode, String>, TFDNode, String> getTwoPhaseHASCOFactory() {
        return this.twoPhaseHASCOFactory;
    }

    public boolean isBuildSelectedClasifierOnGivenData() {
        return this.buildSelectedClasifierOnGivenData;
    }

    public void setBuildSelectedClasifierOnGivenData(boolean buildSelectedClasifierOnGivenData) {
        this.buildSelectedClasifierOnGivenData = buildSelectedClasifierOnGivenData;
    }
}

