/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.core.HASCOConfig;
import ai.libs.hasco.core.HASCOFactory;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.serialization.ComponentLoader;
import ai.libs.hasco.variants.forwarddecomposition.HASCOViaFDAndBestFirstFactory;
import ai.libs.hasco.variants.forwarddecomposition.HASCOViaFDFactory;
import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.AutoMEKAGGPFitnessMeasureLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.EMultilabelPerformanceMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.EMultiClassPerformanceMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.MultiClassMeasureBuilder;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.ZeroOneLoss;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.LearningCurveExtrapolationEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.ClassifierEvaluatorConstructionFailedException;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.IClassifierEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.LearningCurveExtrapolationEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleMLCSplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleSLCSplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.weka.dataset.splitter.ArbitrarySplitter;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import ai.libs.jaicore.ml.weka.dataset.splitter.MulticlassClassStratifiedSplitter;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.StandardBestFirstFactory;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.AlternativeNodeEvaluator;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import ai.libs.jaicore.search.core.interfaces.IOptimalPathInORGraphSearchFactory;
import ai.libs.jaicore.search.problemtransformers.GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS;
import ai.libs.mlpipeline_evaluation.CacheEvaluatorMeasureBridge;
import ai.libs.mlpipeline_evaluation.PerformanceDBAdapter;
import ai.libs.mlplan.core.PipelineEvaluator;
import ai.libs.mlplan.core.PipelineValidityCheckingNodeEvaluator;
import ai.libs.mlplan.multiclass.MLPlanClassifierConfig;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import ai.libs.mlplan.multiclass.wekamlplan.sklearn.SKLearnClassifierFactory;
import ai.libs.mlplan.multiclass.wekamlplan.weka.PreferenceBasedNodeEvaluator;
import ai.libs.mlplan.multiclass.wekamlplan.weka.WEKAPipelineFactory;
import ai.libs.mlplan.multiclass.wekamlplan.weka.WekaPipelineValidityCheckingNodeEvaluator;
import ai.libs.mlplan.multilabel.MekaPipelineFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public class MLPlanBuilder {
    private Logger logger = LoggerFactory.getLogger(MLPlanBuilder.class);
    private static final String SLC_REQUESTED_HASCO_INTERFACE = "AbstractClassifier";
    private static final String MLC_REQUESTED_HASCO_INTERFACE = "MLClassifier";
    private static final File SPC_TINYTEST = new File("resources/automl/searchmodels/weka/tinytest.json");
    private static final File SPC_AUTO_WEKA = new File("resources/automl/searchmodels/weka/weka-all-autoweka.json");
    private static final File SPC_SKLEARN = new File("resources/automl/searchmodels/sklearn/sklearn-mlplan.json");
    private static final File SPC_SKLEARN_UL = new File("resources/automl/searchmodels/sklearn/ml-plan-ul.json");
    private static final File SPC_MEKA = new File("resources/automl/searchmodels/meka/meka-multilabel.json");
    private static final File PREFC_AUTO_WEKA = new File("resources/mlplan/weka-precedenceList.txt");
    private static final File PREFC_SKLEARN = new File("resources/mlplan/sklearn-precedenceList.txt");
    private static final File PREFC_SKLEARN_UL = new File("resources/mlplan/sklearn-ul-precedenceList.txt");
    private static final File PREFC_MEKA = new File("resources/mlplan/meka-preferenceList.txt");
    private static final File DEFAULT_ALGORITHM_CONFIG_FILE = new File("conf/mlplan.properties");
    private static final boolean DEFAULT_USE_CACHE = false;
    private static final Predicate<TFDNode> DEFAULT_PRIORIZING_PREDICATE = null;
    private static final String DEFAULT_REQUESTED_HASCO_INTERFACE = "AbstractClassifier";
    private boolean factoryPreparedWithData = false;
    private MLPlanClassifierConfig algorithmConfig;
    private HASCOViaFDFactory hascoFactory = new HASCOViaFDFactory();
    private File searchSpaceConfigFile;
    private Collection<Component> components;
    private IClassifierFactory classifierFactory;
    private String requestedHASCOInterface;
    private PipelineValidityCheckingNodeEvaluator pipelineValidityCheckingNodeEvaluator;
    private INodeEvaluator<TFDNode, Double> preferredNodeEvaluator = null;
    private IDatasetSplitter searchSelectionDatasetSplitter = new MulticlassClassStratifiedSplitter();
    private IDatasetSplitter searchPhaseDatasetSplitter = new MulticlassClassStratifiedSplitter();
    private IDatasetSplitter selectionPhaseDatasetSplitter = new MulticlassClassStratifiedSplitter();
    private boolean useCache;
    private PerformanceDBAdapter dbAdapter = null;
    private EMultiClassPerformanceMeasure singleLabelPerformanceMeasure;
    private EMultilabelPerformanceMeasure multiLabelPerformanceMeasure;
    private ISplitBasedClassifierEvaluator<Double> splitBasedClassifierEvaluator;
    private Predicate<TFDNode> priorizingPredicate = null;
    private IClassifierEvaluatorFactory factoryForPipelineEvaluationInSearchPhase = null;
    private IClassifierEvaluatorFactory factoryForPipelineEvaluationInSelectionPhase = null;

    public MLPlanBuilder() {
        try {
            this.withAlgorithmConfigFile(DEFAULT_ALGORITHM_CONFIG_FILE);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("The default algorithm configuration file could not be loaded.", (Throwable)e);
        }
        this.useCache = false;
        this.priorizingPredicate = DEFAULT_PRIORIZING_PREDICATE;
        this.requestedHASCOInterface = "AbstractClassifier";
    }

    public MLPlanBuilder(File searchSpaceConfigFile, File algorithmConfigFile, EMultiClassPerformanceMeasure performanceMeasure) {
        this();
        this.withAlgorithmConfigFile(algorithmConfigFile);
        this.searchSpaceConfigFile = searchSpaceConfigFile;
        this.singleLabelPerformanceMeasure = performanceMeasure;
        this.useCache = false;
    }

    public MLPlanBuilder(File searchSpaceConfigFile, File algorithmConfigFile, EMultiClassPerformanceMeasure performanceMeasure, PerformanceDBAdapter dbAdapter) {
        this(searchSpaceConfigFile, algorithmConfigFile, performanceMeasure);
        this.useCache = true;
        this.dbAdapter = dbAdapter;
    }

    public void withClassifierFactory(IClassifierFactory classifierFactory) {
        this.classifierFactory = classifierFactory;
    }

    public MLPlanBuilder withSearchSpaceConfigFile(File searchSpaceConfig) throws IOException {
        FileUtil.requireFileExists((File)searchSpaceConfig);
        this.searchSpaceConfigFile = searchSpaceConfig;
        this.components = new ComponentLoader(searchSpaceConfig).getComponents();
        return this;
    }

    public MLPlanBuilder withDatasetSplitterForSearchSelectionSplit(IDatasetSplitter datasetSplitter) {
        this.searchSelectionDatasetSplitter = datasetSplitter;
        return this;
    }

    public MLPlanBuilder withSearchPhaseDatasetSplitter(IDatasetSplitter datasetSplitter) {
        this.searchPhaseDatasetSplitter = datasetSplitter;
        return this;
    }

    public MLPlanBuilder withSelectionPhaseDatasetSplitter(IDatasetSplitter datasetSplitter) {
        this.selectionPhaseDatasetSplitter = datasetSplitter;
        return this;
    }

    public MLPlanBuilder withRequestedInterface(String requestedInterface) {
        this.requestedHASCOInterface = requestedInterface;
        return this;
    }

    public MLPlanBuilder withAutoSKLearnConfig() throws IOException {
        this.classifierFactory = new SKLearnClassifierFactory();
        return this.withDefaultConfiguration(EDefaultConfig.SKLEARN);
    }

    public MLPlanBuilder withTpotConfig() throws IOException {
        this.classifierFactory = new SKLearnClassifierFactory();
        return this.withDefaultConfiguration(EDefaultConfig.SKLEARN_UL);
    }

    public MLPlanBuilder withAutoWEKAConfiguration() throws IOException {
        this.classifierFactory = new WEKAPipelineFactory();
        this.pipelineValidityCheckingNodeEvaluator = new WekaPipelineValidityCheckingNodeEvaluator();
        return this.withDefaultConfiguration(EDefaultConfig.AUTO_WEKA);
    }

    public MLPlanBuilder withTinyTestConfiguration() throws IOException {
        this.classifierFactory = new WEKAPipelineFactory();
        this.pipelineValidityCheckingNodeEvaluator = new WekaPipelineValidityCheckingNodeEvaluator();
        return this.withDefaultConfiguration(EDefaultConfig.TINYTEST);
    }

    public MLPlanBuilder withMekaDefaultConfiguration() throws IOException {
        this.withDefaultConfiguration(EDefaultConfig.MEKA);
        this.singleLabelPerformanceMeasure = null;
        this.multiLabelPerformanceMeasure = EMultilabelPerformanceMeasure.AUTO_MEKA_GGP_FITNESS_LOSS;
        this.splitBasedClassifierEvaluator = new SimpleMLCSplitBasedClassifierEvaluator((IMeasure)new AutoMEKAGGPFitnessMeasureLoss());
        this.classifierFactory = new MekaPipelineFactory();
        this.requestedHASCOInterface = MLC_REQUESTED_HASCO_INTERFACE;
        this.withDatasetSplitterForSearchSelectionSplit((IDatasetSplitter)new ArbitrarySplitter());
        this.withSearchPhaseDatasetSplitter((IDatasetSplitter)new ArbitrarySplitter());
        this.withSelectionPhaseDatasetSplitter((IDatasetSplitter)new ArbitrarySplitter());
        return this;
    }

    private MLPlanBuilder withDefaultConfiguration(EDefaultConfig defConfig) throws IOException {
        if (this.searchSpaceConfigFile == null) {
            this.withSearchSpaceConfigFile(defConfig.getSearchSpaceConfigFile());
        }
        this.withPreferredComponentsFile(defConfig.preferredComponentsFile);
        this.withRandomCompletionBasedBestFirstSearch();
        if (defConfig != EDefaultConfig.MEKA && this.singleLabelPerformanceMeasure == null) {
            this.singleLabelPerformanceMeasure = EMultiClassPerformanceMeasure.ERRORRATE;
            this.withSingleLabelClassificationMeasure(this.singleLabelPerformanceMeasure);
        }
        int mccvIterationsDuringSearch = 5;
        int mccvIterationsDuringSelection = 5;
        double mccvPortion = 0.7;
        if (!(this.factoryForPipelineEvaluationInSearchPhase instanceof MonteCarloCrossValidationEvaluatorFactory)) {
            this.factoryForPipelineEvaluationInSearchPhase = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(mccvIterationsDuringSearch).withTrainFoldSize(mccvPortion).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator((IMeasure)new ZeroOneLoss()));
        }
        if (!(this.factoryForPipelineEvaluationInSelectionPhase instanceof MonteCarloCrossValidationEvaluatorFactory)) {
            this.factoryForPipelineEvaluationInSelectionPhase = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(mccvIterationsDuringSearch).withTrainFoldSize(mccvPortion).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator((IMeasure)new ZeroOneLoss()));
        }
        double blowUpInSelectionPhase = MathExt.round((double)(1.0 / mccvPortion * (double)mccvIterationsDuringSelection / (double)mccvIterationsDuringSearch), (int)2);
        this.algorithmConfig.setProperty("hasco.blowup.selection", String.valueOf(blowUpInSelectionPhase));
        double blowUpInPostprocessing = MathExt.round((double)(1.0 / (1.0 - this.algorithmConfig.dataPortionForSelection()) / (double)mccvIterationsDuringSelection), (int)2);
        this.algorithmConfig.setProperty("hasco.blowup.postprocess", String.valueOf(blowUpInPostprocessing));
        return this;
    }

    public MLPlanBuilder withPreferredComponentsFile(File preferredComponentsFile) throws IOException {
        ArrayList<String> ordering;
        this.getAlgorithmConfig().setProperty("mlplan.preferredComponents", preferredComponentsFile.getAbsolutePath());
        if (!preferredComponentsFile.exists()) {
            this.logger.warn("The configured file for preferred components \"{}\" does not exist. Not using any particular ordering.", (Object)preferredComponentsFile.getAbsolutePath());
            ordering = new ArrayList<String>();
        } else {
            ordering = FileUtil.readFileAsList((File)preferredComponentsFile);
        }
        return this.withPreferredNodeEvaluator(new PreferenceBasedNodeEvaluator(this.components, ordering));
    }

    public MLPlanBuilder withAlgorithmConfigFile(File algorithmConfigFile) {
        return this.withAlgorithmConfig((MLPlanClassifierConfig)((MLPlanClassifierConfig)ConfigFactory.create(MLPlanClassifierConfig.class, (Map[])new Map[0])).loadPropertiesFromFile(algorithmConfigFile));
    }

    public MLPlanBuilder withAlgorithmConfig(MLPlanClassifierConfig config) {
        this.algorithmConfig = config;
        this.hascoFactory.withAlgorithmConfig((HASCOConfig)this.algorithmConfig);
        this.updateEverything();
        return this;
    }

    public MLPlanBuilder withSingleLabelClassificationMeasure(EMultiClassPerformanceMeasure measure) {
        this.singleLabelPerformanceMeasure = measure;
        return this.withSplitBasedClassifierEvaluator(this.getSingleLabelEvaluationMeasurementBridge((IMeasure<Double, Double>)new MultiClassMeasureBuilder().getEvaluator(measure)));
    }

    public MLPlanBuilder withMultiLabelClassificationMeasure(EMultilabelPerformanceMeasure measure) {
        this.multiLabelPerformanceMeasure = measure;
        return this.withSplitBasedClassifierEvaluator(this.getMultiLabelEvaluationMeasurementBridge((IMeasure<double[], Double>)new MultiClassMeasureBuilder().getEvaluator(measure)));
    }

    public MLPlanBuilder withPreferredNodeEvaluator(INodeEvaluator<TFDNode, Double> preferredNodeEvaluator) {
        if (this.factoryPreparedWithData) {
            throw new IllegalStateException("The method prepareNodeEvaluatorInFactoryWithData has already been called. No changes to the preferred node evaluator possible anymore");
        }
        this.preferredNodeEvaluator = this.preferredNodeEvaluator == null ? preferredNodeEvaluator : new AlternativeNodeEvaluator(preferredNodeEvaluator, this.preferredNodeEvaluator);
        this.updateEverything();
        return this;
    }

    public MLPlanBuilder withSplitBasedClassifierEvaluator(ISplitBasedClassifierEvaluator<Double> evaluator) {
        this.splitBasedClassifierEvaluator = evaluator;
        return this;
    }

    public MLPlanBuilder withSearchFactory(IOptimalPathInORGraphSearchFactory searchFactory, AlgorithmicProblemReduction transformer) {
        this.hascoFactory.setSearchFactory(searchFactory);
        this.hascoFactory.setSearchProblemTransformer(transformer);
        return this;
    }

    public MLPlanBuilder withRandomCompletionBasedBestFirstSearch() {
        this.hascoFactory.setSearchFactory((IOptimalPathInORGraphSearchFactory)new StandardBestFirstFactory());
        this.updateEverything();
        return this;
    }

    public MLPlanBuilder withTimeoutForSingleSolutionEvaluation(TimeOut timeout) {
        this.getAlgorithmConfig().setProperty("hasco.random_completions.timeout_path", String.valueOf(timeout.milliseconds()));
        this.updateEverything();
        return this;
    }

    public MLPlanBuilder withTimeoutForNodeEvaluation(TimeOut timeout) {
        this.getAlgorithmConfig().setProperty("hasco.random_completions.timeout_node", String.valueOf(timeout.milliseconds()));
        this.updateEverything();
        return this;
    }

    public void prepareNodeEvaluatorInFactoryWithData(Instances data) {
        PipelineValidityCheckingNodeEvaluator actualNodeEvaluator;
        if (!(this.hascoFactory instanceof HASCOViaFDAndBestFirstFactory)) {
            return;
        }
        if (this.factoryPreparedWithData) {
            throw new IllegalStateException("Factory has already been prepared with data. This can only be done once!");
        }
        this.factoryPreparedWithData = true;
        if (this.pipelineValidityCheckingNodeEvaluator == null && this.preferredNodeEvaluator == null) {
            return;
        }
        if (this.pipelineValidityCheckingNodeEvaluator != null) {
            this.pipelineValidityCheckingNodeEvaluator.setComponents(this.components);
            this.pipelineValidityCheckingNodeEvaluator.setData(data);
            actualNodeEvaluator = this.preferredNodeEvaluator != null ? new AlternativeNodeEvaluator((INodeEvaluator)this.pipelineValidityCheckingNodeEvaluator, this.preferredNodeEvaluator) : this.pipelineValidityCheckingNodeEvaluator;
        } else {
            actualNodeEvaluator = this.preferredNodeEvaluator;
        }
        this.preferredNodeEvaluator = actualNodeEvaluator;
        this.updateEverything();
    }

    private void updateSearchProblemTransformer() {
        this.hascoFactory.setSearchProblemTransformer((AlgorithmicProblemReduction)new GraphSearchProblemInputToGraphSearchWithSubpathEvaluationInputTransformerViaRDFS(this.preferredNodeEvaluator, this.priorizingPredicate, this.algorithmConfig.randomSeed(), this.algorithmConfig.numberOfRandomCompletions(), this.algorithmConfig.timeoutForCandidateEvaluation(), this.algorithmConfig.timeoutForNodeEvaluation()));
    }

    private void updateAlgorithmConfigOfHASCO() {
        this.hascoFactory.withAlgorithmConfig((HASCOConfig)this.getAlgorithmConfig());
    }

    private void updateEverything() {
        this.updateSearchProblemTransformer();
        this.updateAlgorithmConfigOfHASCO();
    }

    public IDatasetSplitter getSearchSelectionDatasetSplitter() {
        return this.searchSelectionDatasetSplitter;
    }

    public IDatasetSplitter getSearchPhaseDatasetSplitter() {
        return this.searchPhaseDatasetSplitter;
    }

    public IDatasetSplitter getSelectionPhaseDatasetSplitter() {
        return this.selectionPhaseDatasetSplitter;
    }

    public String getRequestedInterface() {
        return this.requestedHASCOInterface;
    }

    public void withLearningCurveExtrapolationEvaluation(int[] anchorpoints, ISamplingAlgorithmFactory<IInstance, ? extends ASamplingAlgorithm<IInstance>> subsamplingAlgorithmFactory, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod) {
        this.factoryForPipelineEvaluationInSearchPhase = new LearningCurveExtrapolationEvaluatorFactory(anchorpoints, subsamplingAlgorithmFactory, trainSplitForAnchorpointsMeasurement, extrapolationMethod);
        this.factoryForPipelineEvaluationInSelectionPhase = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(3).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator((IMeasure)new ZeroOneLoss()));
        this.algorithmConfig.setProperty("hasco.blowup.selection", "4");
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public PerformanceDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public IClassifierFactory getClassifierFactory() {
        return this.classifierFactory;
    }

    public Collection<Component> getComponents() {
        return this.components;
    }

    public File getSearchSpaceConfigFile() {
        return this.searchSpaceConfigFile;
    }

    public MLPlanClassifierConfig getAlgorithmConfig() {
        return this.algorithmConfig;
    }

    public EMultiClassPerformanceMeasure getSingleLabelPerformanceMeasure() {
        return this.singleLabelPerformanceMeasure;
    }

    public EMultilabelPerformanceMeasure getMultiLabelPerformanceMeasure() {
        return this.multiLabelPerformanceMeasure;
    }

    public ISplitBasedClassifierEvaluator<Double> getSingleLabelEvaluationMeasurementBridge(IMeasure<Double, Double> measure) {
        if (this.splitBasedClassifierEvaluator == null) {
            if (this.getUseCache()) {
                return new CacheEvaluatorMeasureBridge(measure, this.getDBAdapter());
            }
            return new SimpleSLCSplitBasedClassifierEvaluator(measure);
        }
        return this.splitBasedClassifierEvaluator;
    }

    public ISplitBasedClassifierEvaluator<Double> getMultiLabelEvaluationMeasurementBridge(IMeasure<double[], Double> measure) {
        if (this.splitBasedClassifierEvaluator == null) {
            return new SimpleMLCSplitBasedClassifierEvaluator(measure);
        }
        return this.splitBasedClassifierEvaluator;
    }

    public HASCOFactory getHASCOFactory() {
        return this.hascoFactory;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("algorithmConfig", this.getAlgorithmConfig());
        fields.put("classifierFactory", this.classifierFactory);
        return ToJSONStringUtil.toJSONString(fields);
    }

    public IClassifierEvaluatorFactory getFactoryForPipelineEvaluationInSearchPhase() {
        return this.factoryForPipelineEvaluationInSearchPhase;
    }

    public IClassifierEvaluatorFactory getFactoryForPipelineEvaluationInSelectionPhase() {
        return this.factoryForPipelineEvaluationInSelectionPhase;
    }

    public PipelineEvaluator getClassifierEvaluationInSearchPhase(Instances data, int seed, int fullDatasetSize) throws ClassifierEvaluatorConstructionFailedException {
        if (this.factoryForPipelineEvaluationInSearchPhase == null) {
            throw new IllegalStateException("No factory for pipeline evaluation in search phase has been set!");
        }
        IClassifierEvaluator evaluator = this.factoryForPipelineEvaluationInSearchPhase.getIClassifierEvaluator(data, (long)seed);
        if (evaluator instanceof LearningCurveExtrapolationEvaluator) {
            ((LearningCurveExtrapolationEvaluator)evaluator).setFullDatasetSize(fullDatasetSize);
        }
        return new PipelineEvaluator(this.getClassifierFactory(), evaluator, this.getAlgorithmConfig().timeoutForCandidateEvaluation());
    }

    public PipelineEvaluator getClassifierEvaluationInSelectionPhase(Instances data, int seed) throws ClassifierEvaluatorConstructionFailedException {
        if (this.factoryForPipelineEvaluationInSelectionPhase == null) {
            throw new IllegalStateException("No factory for pipeline evaluation in selection phase has been set!");
        }
        return new PipelineEvaluator(this.getClassifierFactory(), this.factoryForPipelineEvaluationInSelectionPhase.getIClassifierEvaluator(data, (long)seed), Integer.MAX_VALUE);
    }

    static /* synthetic */ File access$000() {
        return SPC_TINYTEST;
    }

    static /* synthetic */ File access$100() {
        return PREFC_AUTO_WEKA;
    }

    static /* synthetic */ File access$200() {
        return SPC_AUTO_WEKA;
    }

    static /* synthetic */ File access$300() {
        return SPC_SKLEARN;
    }

    static /* synthetic */ File access$400() {
        return PREFC_SKLEARN;
    }

    static /* synthetic */ File access$500() {
        return SPC_SKLEARN_UL;
    }

    static /* synthetic */ File access$600() {
        return PREFC_SKLEARN_UL;
    }

    static /* synthetic */ File access$700() {
        return SPC_MEKA;
    }

    static /* synthetic */ File access$800() {
        return PREFC_MEKA;
    }

    private static enum EDefaultConfig {
        TINYTEST(MLPlanBuilder.access$000(), MLPlanBuilder.access$100()),
        AUTO_WEKA(MLPlanBuilder.access$200(), MLPlanBuilder.access$100()),
        SKLEARN(MLPlanBuilder.access$300(), MLPlanBuilder.access$400()),
        SKLEARN_UL(MLPlanBuilder.access$500(), MLPlanBuilder.access$600()),
        MEKA(MLPlanBuilder.access$700(), MLPlanBuilder.access$800());

        private final File searchSpaceConfigurationFile;
        private final File preferredComponentsFile;

        private EDefaultConfig(File spcFile, File preferredComponentsFile) {
            this.searchSpaceConfigurationFile = spcFile;
            this.preferredComponentsFile = preferredComponentsFile;
        }

        public File getSearchSpaceConfigFile() {
            return this.searchSpaceConfigurationFile;
        }

        public File getPreferredComponentsFile() {
            return this.preferredComponentsFile;
        }
    }
}

