/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.AutoMEKAGGPFitnessMeasureLoss;
import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.InstanceWiseF1AsLoss;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.IClassifierEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleMLCSplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.weka.dataset.splitter.ArbitrarySplitter;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import ai.libs.mlplan.core.AbstractMLPlanBuilder;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import ai.libs.mlplan.multilabel.MekaPipelineFactory;
import java.io.File;
import java.io.IOException;

public class MLPlanMekaBuilder
extends AbstractMLPlanBuilder {
    private static final String RES_SSC_MEKA_COMPLETE = "automl/searchmodels/meka/mlplan-meka.json";
    private static final String FS_SSC_MEKA_COMPLETE = "conf/mlplan-meka.json";
    private static final String RES_PREFC_MEKA = "mlplan/meka-preferenceList.txt";
    private static final String FS_PREFC_MEKA = "conf/mlpan-meka-preferenceList.txt";
    private static final int SEARCH_NUM_MC_ITERATIONS = 5;
    private static final double SEARCH_TRAIN_FOLD_SIZE = 0.7;
    private static final int SELECTION_NUM_MC_ITERATIONS = 5;
    private static final double SELECTION_TRAIN_FOLD_SIZE = 0.7;
    private static final IMeasure<double[], Double> LOSS_FUNCTION = new InstanceWiseF1AsLoss();
    private static final String DEF_REQUESTED_HASCO_INTERFACE = "MLClassifier";
    private static final IDatasetSplitter DEF_SELECTION_HOLDOUT_SPLITTER = new ArbitrarySplitter();
    private static final File DEF_SEARCH_SPACE_CONFIG = FileUtil.getExistingFileWithHighestPriority((String)"automl/searchmodels/meka/mlplan-meka.json", (String[])new String[]{"conf/mlplan-meka.json"});
    private static final File DEF_PREFERRED_COMPONENTS_CONFIG = FileUtil.getExistingFileWithHighestPriority((String)"mlplan/meka-preferenceList.txt", (String[])new String[]{"conf/mlpan-meka-preferenceList.txt"});
    private static final IClassifierFactory CLASSIFIER_FACTORY = new MekaPipelineFactory();
    private static final MonteCarloCrossValidationEvaluatorFactory DEF_SEARCH_PHASE_EVALUATOR = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(5).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleMLCSplitBasedClassifierEvaluator(LOSS_FUNCTION)).withDatasetSplitter((IDatasetSplitter)new ArbitrarySplitter());
    private static final MonteCarloCrossValidationEvaluatorFactory DEF_SELECTION_PHASE_EVALUATOR = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(5).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleMLCSplitBasedClassifierEvaluator(LOSS_FUNCTION)).withDatasetSplitter((IDatasetSplitter)new ArbitrarySplitter());

    public MLPlanMekaBuilder() throws IOException {
        this.withSearchSpaceConfigFile(DEF_SEARCH_SPACE_CONFIG);
        this.withRequestedInterface(DEF_REQUESTED_HASCO_INTERFACE);
        this.withPreferredComponentsFile(DEF_PREFERRED_COMPONENTS_CONFIG);
        this.withDatasetSplitterForSearchSelectionSplit(DEF_SELECTION_HOLDOUT_SPLITTER);
        this.withClassifierFactory(CLASSIFIER_FACTORY);
        this.withSearchPhaseEvaluatorFactory((IClassifierEvaluatorFactory)DEF_SEARCH_PHASE_EVALUATOR);
        this.withSelectionPhaseEvaluatorFactory(DEF_SELECTION_PHASE_EVALUATOR);
    }

    public MLPlanMekaBuilder withAutoMEKADefaultConfiguration() {
        this.withPerformanceMeasure((IMeasure<double[], Double>)new AutoMEKAGGPFitnessMeasureLoss());
        return this;
    }

    public MLPlanMekaBuilder withPerformanceMeasure(IMeasure<double[], Double> lossFunction) {
        if (!(this.getSearchEvaluatorFactory() instanceof MonteCarloCrossValidationEvaluatorFactory)) {
            this.withSearchPhaseEvaluatorFactory((IClassifierEvaluatorFactory)new MonteCarloCrossValidationEvaluatorFactory().withDatasetSplitter(this.getDefaultDatasetSplitter()).withNumMCIterations(5).withTrainFoldSize(0.7));
        }
        if (!(this.getSearchEvaluatorFactory() instanceof MonteCarloCrossValidationEvaluatorFactory)) {
            this.withSearchPhaseEvaluatorFactory((IClassifierEvaluatorFactory)new MonteCarloCrossValidationEvaluatorFactory().withDatasetSplitter(this.getDefaultDatasetSplitter()).withNumMCIterations(5).withTrainFoldSize(0.7));
        }
        ((MonteCarloCrossValidationEvaluatorFactory)this.getSelectionEvaluatorFactory()).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleMLCSplitBasedClassifierEvaluator(lossFunction));
        return this;
    }

    protected IDatasetSplitter getDefaultDatasetSplitter() {
        return new ArbitrarySplitter();
    }
}

