/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.SystemRequirementsNotMetException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.IClassifierEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleSLCSplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import ai.libs.jaicore.ml.weka.dataset.splitter.MulticlassClassStratifiedSplitter;
import ai.libs.mlplan.core.AbstractMLPlanSingleLabelBuilder;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import ai.libs.mlplan.multiclass.wekamlplan.sklearn.SKLearnClassifierFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLPlanSKLearnBuilder
extends AbstractMLPlanSingleLabelBuilder {
    private Logger logger = LoggerFactory.getLogger(MLPlanSKLearnBuilder.class);
    private static final String MSG_MODULE_NOT_AVAILABLE = "Could not load python module {}: {}";
    private static final String PYTHON_MINIMUM_REQUIRED_VERSION = "Python 3.5.0";
    private static final int PYTHON_MINIMUM_REQUIRED_VERSION_REL = 3;
    private static final int PYTHON_MINIMUM_REQUIRED_VERSION_MAJ = 5;
    private static final int PYTHON_MINIMUM_REQUIRED_VERSION_MIN = 0;
    private static final String[] PYTHON_REQUIRED_MODULES = new String[]{"arff", "numpy", "json", "pickle", "os", "sys", "warnings", "scipy", "sklearn"};
    private static final String COMMAND_PYTHON = "python";
    private static final String[] COMMAND_PYTHON_VERSION = new String[]{"python", "--version"};
    private static final String[] COMMAND_PYTHON_EXEC = new String[]{"python", "-c"};
    private static final String PYTHON_MODULE_NOT_FOUND_ERROR_MSG = "ModuleNotFoundError";
    private static final String RES_SKLEARN_SEARCHSPACE_CONFIG = "automl/searchmodels/sklearn/sklearn-mlplan.json";
    private static final String RES_SKLEARN_UL_SEARCHSPACE_CONFIG = "automl/searchmodels/sklearn/ml-plan-ul.json";
    private static final String FS_SEARCH_SPACE_CONFIG = "conf/mlplan-sklearn.json";
    private static final String RES_SKLEARN_PREFERRED_COMPONENTS = "mlplan/sklearn-preferenceList.txt";
    private static final String FS_SKLEARN_PREFERRED_COMPONENTS = "conf/sklearn-preferenceList.txt";
    private static final String DEF_REQUESTED_HASCO_INTERFACE = "AbstractClassifier";
    private static final IDatasetSplitter DEF_SELECTION_HOLDOUT_SPLITTER = new MulticlassClassStratifiedSplitter();
    private static final IClassifierFactory DEF_CLASSIFIER_FACTORY = new SKLearnClassifierFactory();
    private static final File DEF_SEARCH_SPACE_CONFIG = FileUtil.getExistingFileWithHighestPriority((String)"automl/searchmodels/sklearn/sklearn-mlplan.json", (String[])new String[]{"conf/mlplan-sklearn.json"});
    private static final File DEF_PREFERRED_COMPONENTS = FileUtil.getExistingFileWithHighestPriority((String)"mlplan/sklearn-preferenceList.txt", (String[])new String[]{"conf/sklearn-preferenceList.txt"});
    private static final MonteCarloCrossValidationEvaluatorFactory DEF_SEARCH_PHASE_EVALUATOR = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(5).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator(LOSS_FUNCTION)).withDatasetSplitter((IDatasetSplitter)new MulticlassClassStratifiedSplitter());
    private static final MonteCarloCrossValidationEvaluatorFactory DEF_SELECTION_PHASE_EVALUATOR = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(5).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator(LOSS_FUNCTION)).withDatasetSplitter((IDatasetSplitter)new MulticlassClassStratifiedSplitter());

    public MLPlanSKLearnBuilder() throws IOException {
        this(false);
    }

    public MLPlanSKLearnBuilder(boolean skipSetupCheck) throws IOException {
        if (!skipSetupCheck) {
            this.checkPythonSetup();
        }
        this.withSearchSpaceConfigFile(DEF_SEARCH_SPACE_CONFIG);
        this.withPreferredComponentsFile(DEF_PREFERRED_COMPONENTS);
        this.withRequestedInterface(DEF_REQUESTED_HASCO_INTERFACE);
        this.withClassifierFactory(DEF_CLASSIFIER_FACTORY);
        this.withDatasetSplitterForSearchSelectionSplit(DEF_SELECTION_HOLDOUT_SPLITTER);
        this.withSearchPhaseEvaluatorFactory((IClassifierEvaluatorFactory)DEF_SEARCH_PHASE_EVALUATOR);
        this.withSelectionPhaseEvaluatorFactory(DEF_SELECTION_PHASE_EVALUATOR);
        this.setPerformanceMeasureName(LOSS_FUNCTION.getClass().getSimpleName());
    }

    public MLPlanSKLearnBuilder withUnlimitedLengthPipelineSearchSpace() throws IOException {
        return (MLPlanSKLearnBuilder)this.withSearchSpaceConfigFile(FileUtil.getExistingFileWithHighestPriority((String)RES_SKLEARN_UL_SEARCHSPACE_CONFIG, (String[])new String[]{FS_SEARCH_SPACE_CONFIG}));
    }

    private void checkPythonSetup() {
        block52: {
            try {
                int min;
                int maj;
                Process p = new ProcessBuilder(new String[0]).command(COMMAND_PYTHON_VERSION).start();
                StringBuilder sb = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                String versionString = sb.toString();
                if (!versionString.startsWith("Python ")) {
                    throw new SystemRequirementsNotMetException("Could not detect valid python version.");
                }
                String[] versionSplit = versionString.substring(7).split("\\.");
                if (versionSplit.length != 3) {
                    throw new SystemRequirementsNotMetException("Could not parse python version to be of the shape X.X.X");
                }
                int rel = Integer.parseInt(versionSplit[0]);
                if (!this.isValidVersion(rel, maj = Integer.parseInt(versionSplit[1]), min = Integer.parseInt(versionSplit[2]))) {
                    throw new SystemRequirementsNotMetException("Python version does not conform the minimum required python version of Python 3.5.0");
                }
                LinkedList<String> checkAllModulesAvailableCommand = new LinkedList<String>(Arrays.asList(COMMAND_PYTHON_EXEC));
                StringBuilder imports = new StringBuilder();
                for (String module : PYTHON_REQUIRED_MODULES) {
                    if (!imports.toString().isEmpty()) {
                        imports.append(";");
                    }
                    imports.append("import " + module);
                }
                checkAllModulesAvailableCommand.add(imports.toString());
                StringBuilder allModulesAvailableErrorSB = new StringBuilder();
                Process allModulesCheckProcess = new ProcessBuilder(new String[0]).command(checkAllModulesAvailableCommand.toArray(new String[0])).start();
                String[] stringArray = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(allModulesCheckProcess.getErrorStream()));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        allModulesAvailableErrorSB.append(line);
                    }
                }
                catch (Throwable object) {
                    stringArray = object;
                    throw object;
                }
                if (allModulesAvailableErrorSB.toString().isEmpty()) break block52;
                LinkedList<String> modulesNotFound = new LinkedList<String>();
                for (String module : PYTHON_REQUIRED_MODULES) {
                    Process moduleCheck = new ProcessBuilder(new String[0]).command(COMMAND_PYTHON_EXEC[0], COMMAND_PYTHON_EXEC[1], "import " + module).start();
                    StringBuilder errorSB = new StringBuilder();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(moduleCheck.getErrorStream()));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            errorSB.append(line);
                        }
                    }
                    if (errorSB.toString().isEmpty() || !errorSB.toString().contains(PYTHON_MODULE_NOT_FOUND_ERROR_MSG)) continue;
                    if (module.equals("arff")) {
                        this.logger.debug(MSG_MODULE_NOT_AVAILABLE, (Object)"liac-arff", (Object)errorSB);
                        modulesNotFound.add("liac-arff");
                        continue;
                    }
                    if (module.equals("sklearn")) {
                        this.logger.debug(MSG_MODULE_NOT_AVAILABLE, (Object)"scikit-learn", (Object)errorSB);
                        modulesNotFound.add("scikit-learn");
                        continue;
                    }
                    this.logger.debug(MSG_MODULE_NOT_AVAILABLE, (Object)module, (Object)errorSB);
                    modulesNotFound.add(module);
                }
                if (!modulesNotFound.isEmpty()) {
                    throw new SystemRequirementsNotMetException("Could not find required python modules: " + SetUtil.implode(modulesNotFound, (String)", "));
                }
            }
            catch (IOException e) {
                throw new SystemRequirementsNotMetException("Could not check whether python is installed in the required version. Is python available as a command on your command line?");
            }
        }
    }

    private boolean isValidVersion(int rel, int maj, int min) {
        return rel > 3 || rel == 3 && maj > 5 || rel == 3 && maj == 5 && min >= 0;
    }

    @Override
    protected IDatasetSplitter getDefaultDatasetSplitter() {
        return new MulticlassClassStratifiedSplitter();
    }
}

