/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.ResourceUtil;
import ai.libs.jaicore.ml.core.dataset.IInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.ZeroOneLoss;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.IClassifierEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.LearningCurveExtrapolationEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleSLCSplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import ai.libs.jaicore.ml.weka.dataset.splitter.MulticlassClassStratifiedSplitter;
import ai.libs.mlplan.core.AbstractMLPlanSingleLabelBuilder;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import ai.libs.mlplan.multiclass.wekamlplan.weka.WEKAPipelineFactory;
import java.io.File;
import java.io.IOException;

public class MLPlanWekaBuilder
extends AbstractMLPlanSingleLabelBuilder {
    private static final String RES_SSC_TINY_WEKA = "automl/searchmodels/weka/tinytest.json";
    private static final String RES_SSC_WEKA_COMPLETE = "automl/searchmodels/weka/weka-all-autoweka.json";
    private static final String FS_SSC_WEKA = "conf/mlplan-weka.json";
    private static final String RES_PREFERRED_COMPONENTS = "mlplan/weka-preferenceList.txt";
    private static final String FS_PREFERRED_COMPONENTS = "conf/mlpan-weka-preferenceList.txt";
    private static final String DEF_REQUESTED_HASCO_INTERFACE = "AbstractClassifier";
    private static final IDatasetSplitter DEF_SELECTION_HOLDOUT_SPLITTER = new MulticlassClassStratifiedSplitter();
    private static final IClassifierFactory DEF_CLASSIFIER_FACTORY = new WEKAPipelineFactory();
    private static final File DEF_PREFERRED_COMPONENTS = FileUtil.getExistingFileWithHighestPriority((String)"mlplan/weka-preferenceList.txt", (String[])new String[]{"conf/mlpan-weka-preferenceList.txt"});
    private static final File DEF_SEARCH_SPACE_CONFIG = FileUtil.getExistingFileWithHighestPriority((String)"automl/searchmodels/weka/weka-all-autoweka.json", (String[])new String[]{"conf/mlplan-weka.json"});
    private static final MonteCarloCrossValidationEvaluatorFactory DEF_SEARCH_PHASE_EVALUATOR = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(5).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator(LOSS_FUNCTION)).withDatasetSplitter((IDatasetSplitter)new MulticlassClassStratifiedSplitter());
    private static final MonteCarloCrossValidationEvaluatorFactory DEF_SELECTION_PHASE_EVALUATOR = new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(5).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator(LOSS_FUNCTION)).withDatasetSplitter((IDatasetSplitter)new MulticlassClassStratifiedSplitter());

    public MLPlanWekaBuilder() throws IOException {
        this.withSearchSpaceConfigFile(DEF_SEARCH_SPACE_CONFIG);
        this.withPreferredComponentsFile(DEF_PREFERRED_COMPONENTS);
        this.withRequestedInterface(DEF_REQUESTED_HASCO_INTERFACE);
        this.withClassifierFactory(DEF_CLASSIFIER_FACTORY);
        this.withDatasetSplitterForSearchSelectionSplit(DEF_SELECTION_HOLDOUT_SPLITTER);
        this.withSearchPhaseEvaluatorFactory((IClassifierEvaluatorFactory)DEF_SEARCH_PHASE_EVALUATOR);
        this.withSelectionPhaseEvaluatorFactory(DEF_SELECTION_PHASE_EVALUATOR);
        this.setPerformanceMeasureName(LOSS_FUNCTION.getClass().getSimpleName());
        double blowUpInSelectionPhase = MathExt.round((double)1.4285714285714286, (int)2);
        this.getAlgorithmConfig().setProperty("hasco.blowup.selection", String.valueOf(blowUpInSelectionPhase));
        double blowUpInPostprocessing = MathExt.round((double)(1.0 / (1.0 - this.getAlgorithmConfig().dataPortionForSelection()) / 5.0), (int)2);
        this.getAlgorithmConfig().setProperty("hasco.blowup.postprocess", String.valueOf(blowUpInPostprocessing));
    }

    public MLPlanWekaBuilder withTinyWekaSearchSpace() throws IOException {
        this.withSearchSpaceConfigFile((File)ResourceUtil.getResourceAsFile((String)RES_SSC_TINY_WEKA));
        return this;
    }

    public void withLearningCurveExtrapolationEvaluation(int[] anchorpoints, ISamplingAlgorithmFactory<IInstance, ? extends ASamplingAlgorithm<IInstance>> subsamplingAlgorithmFactory, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod) {
        this.withSearchPhaseEvaluatorFactory((IClassifierEvaluatorFactory)new LearningCurveExtrapolationEvaluatorFactory(anchorpoints, subsamplingAlgorithmFactory, trainSplitForAnchorpointsMeasurement, extrapolationMethod));
        this.withSelectionPhaseEvaluatorFactory(new MonteCarloCrossValidationEvaluatorFactory().withNumMCIterations(3).withTrainFoldSize(0.7).withSplitBasedEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator((IMeasure)new ZeroOneLoss())));
        this.getAlgorithmConfig().setProperty("hasco.blowup.selection", "10");
    }
}

