/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.exceptions.ComponentInstantiationFailedException;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.jaicore.basic.IInformedObjectEvaluatorExtension;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.events.IEvent;
import ai.libs.jaicore.basic.events.IEventEmitter;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.scikitwrapper.ScikitLearnWrapper;
import ai.libs.jaicore.timing.TimedObjectEvaluator;
import ai.libs.mlplan.core.events.ClassifierCreatedEvent;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;

public class PipelineEvaluator
extends TimedObjectEvaluator<ComponentInstance, Double>
implements IInformedObjectEvaluatorExtension<Double>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(PipelineEvaluator.class);
    private final EventBus eventBus = new EventBus();
    private final IClassifierFactory classifierFactory;
    private final IClassifierEvaluator benchmark;
    private final int timeoutForEvaluation;
    private Double bestScore = 1.0;

    public PipelineEvaluator(IClassifierFactory classifierFactory, IClassifierEvaluator benchmark, int timeoutForEvaluation) {
        this.classifierFactory = classifierFactory;
        this.benchmark = benchmark;
        if (benchmark instanceof IEventEmitter) {
            ((IEventEmitter)benchmark).registerListener((Object)this);
        }
        this.timeoutForEvaluation = timeoutForEvaluation;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger name from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.benchmark instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger name of actual benchmark {} to {}.benchmark", (Object)this.benchmark.getClass().getName(), (Object)name);
            ((ILoggingCustomizable)this.benchmark).setLoggerName(name + ".benchmark");
        } else {
            this.logger.info("Benchmark {} does not implement ILoggingCustomizable, not customizing its logger.", (Object)this.benchmark.getClass().getName());
        }
    }

    public Double evaluateSupervised(ComponentInstance c) throws InterruptedException, ObjectEvaluationFailedException {
        this.logger.debug("Received request to evaluate component instance {}", (Object)c);
        try {
            if (this.benchmark instanceof IInformedObjectEvaluatorExtension) {
                ((IInformedObjectEvaluatorExtension)this.benchmark).updateBestScore((Comparable)this.bestScore);
            }
            Classifier classifier = (Classifier)this.classifierFactory.getComponentInstantiation(c);
            this.eventBus.post((Object)new ClassifierCreatedEvent(c, classifier));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting benchmark {} for classifier {}", (Object)this.benchmark, (Object)(classifier instanceof ScikitLearnWrapper ? classifier.toString() : classifier.getClass().getName()));
            }
            Double score = (Double)this.benchmark.evaluate((Object)classifier);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Obtained score {} for classifier {}", (Object)score, (Object)(classifier instanceof ScikitLearnWrapper ? classifier.toString() : classifier.getClass().getName()));
            }
            return score;
        }
        catch (ComponentInstantiationFailedException e) {
            throw new ObjectEvaluationFailedException("Evaluation of composition failed as the component instantiation could not be built.", (Throwable)e);
        }
    }

    public void updateBestScore(Double bestScore) {
        this.bestScore = bestScore;
    }

    public long getTimeout(ComponentInstance item) {
        return this.timeoutForEvaluation;
    }

    public String getMessage(ComponentInstance item) {
        return "Pipeline evaluation phase";
    }

    public IClassifierEvaluator getBenchmark() {
        return this.benchmark;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    @Subscribe
    public void receiveEvent(IEvent e) {
        this.eventBus.post((Object)e);
    }
}

