/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.gui.outofsampleplots;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import ai.libs.mlplan.core.events.ClassifierFoundEvent;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPlugin;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPluginModel;
import ai.libs.mlplan.gui.outofsampleplots.OutOfSampleErrorPlotPluginView;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class OutOfSampleErrorPlotPluginController
extends ASimpleMVCPluginController<OutOfSampleErrorPlotPluginModel, OutOfSampleErrorPlotPluginView> {
    private Instances train;
    private Instances test;
    private Logger logger = LoggerFactory.getLogger(OutOfSampleErrorPlotPlugin.class);

    public OutOfSampleErrorPlotPluginController(OutOfSampleErrorPlotPluginModel model, OutOfSampleErrorPlotPluginView view) {
        super((ASimpleMVCPluginModel)model, (ASimpleMVCPluginView)view);
    }

    public Instances getTrain() {
        return this.train;
    }

    public void setTrain(Instances train) {
        this.train = train;
    }

    public Instances getTest() {
        return this.test;
    }

    public void setTest(Instances test) {
        this.test = test;
    }

    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent || guiEvent instanceof GoToTimeStepEvent) {
            ((OutOfSampleErrorPlotPluginModel)this.getModel()).clear();
        }
    }

    public void handleAlgorithmEventInternally(AlgorithmEvent algorithmEvent) {
        if (algorithmEvent instanceof ClassifierFoundEvent) {
            try {
                this.logger.debug("Received classifier found event {}", (Object)algorithmEvent);
                ClassifierFoundEvent event = (ClassifierFoundEvent)algorithmEvent;
                Classifier classifier = (Classifier)event.getSolutionCandidate();
                this.logger.debug("Building classifier");
                classifier.buildClassifier(this.train);
                Evaluation eval = new Evaluation(this.train);
                ArrayList<Double> performances = new ArrayList<Double>();
                performances.add(event.getScore());
                eval.evaluateModel(classifier, this.test, new Object[0]);
                performances.add(eval.errorRate());
                this.logger.debug("Adding solution to model and updating view.");
                ((OutOfSampleErrorPlotPluginModel)this.getModel()).addEntry(event.getTimestamp(), classifier, performances);
            }
            catch (Exception e) {
                this.logger.error("Could not train classifier! " + e.toString());
                e.printStackTrace();
            }
        } else {
            this.logger.trace("Received and ignored irrelevant event {}", (Object)algorithmEvent);
        }
    }
}

