/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.mlplan.metamining.pipelinecharacterizing.IOntologyConnector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WEKAOntologyConnector
implements IOntologyConnector {
    private static final List<String> classifierPortfolio = Arrays.asList("weka.classifiers.bayes.BayesNet", "weka.classifiers.bayes.NaiveBayes", "weka.classifiers.bayes.NaiveBayesMultinomial", "weka.classifiers.functions.Logistic", "weka.classifiers.functions.MultilayerPerceptron", "weka.classifiers.functions.SGD", "weka.classifiers.functions.SimpleLogistic", "weka.classifiers.functions.SMO", "weka.classifiers.functions.VotedPerceptron", "weka.classifiers.lazy.IBk", "weka.classifiers.lazy.KStar", "weka.classifiers.rules.DecisionTable", "weka.classifiers.rules.JRip", "weka.classifiers.rules.OneR", "weka.classifiers.rules.PART", "weka.classifiers.rules.ZeroR", "weka.classifiers.trees.DecisionStump", "weka.classifiers.trees.J48", "weka.classifiers.trees.LMT", "weka.classifiers.trees.RandomForest", "weka.classifiers.trees.RandomTree", "weka.classifiers.trees.REPTree");
    private static final List<String> evaluatorPortfolio = Arrays.asList("weka.attributeSelection.CfsSubsetEval", "weka.attributeSelection.CorrelationAttributeEval", "weka.attributeSelection.GainRatioAttributeEval", "weka.attributeSelection.InfoGainAttributeEval", "weka.attributeSelection.OneRAttributeEval", "weka.attributeSelection.PrincipalComponents", "weka.attributeSelection.ReliefFAttributeEval", "weka.attributeSelection.SymmetricalUncertAttributeEval");
    private static final List<String> searcherPortfolio = Arrays.asList("weka.attributeSelection.BestFirst", "weka.attributeSelection.GreedyStepwise", "weka.attributeSelection.Ranker");
    private static final String ONTOLOGY_FILENAME = "DMOP_modified.owl";
    private static final String ONTOLOGY_IRI = "http://www.e-lico.eu/ontologies/dmo/DMOP/DMOP.owl";
    private static final String ONTOLOGY_IRI_SEPARATOR = "#";
    private static final Logger logger = LoggerFactory.getLogger(WEKAOntologyConnector.class);
    private String classifierTopNode = "ModelingAlgorithm";
    private String searcherTopNode = "SearchStrategy";
    private String evaluatorTopNode = "DataProcessingAlgorithm";
    private OWLDataFactory dataFactory;
    private OWLOntology ontology;
    private boolean includeEqualSuperClasses = true;
    private static final String MSG_NOT_SUPPORTED_BY_ONTOLOGY = " is not supported by the used ontology.";

    public WEKAOntologyConnector() throws OWLOntologyCreationException {
        OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();
        this.dataFactory = ontologyManager.getOWLDataFactory();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(ONTOLOGY_FILENAME);
        this.ontology = ontologyManager.loadOntologyFromOntologyDocument(inputStream);
    }

    @Override
    public List<String> getAncestorsOfClassifier(String classifierName) {
        if (!classifierPortfolio.contains(classifierName)) {
            StringBuilder builder = new StringBuilder();
            builder.append(classifierName);
            builder.append(MSG_NOT_SUPPORTED_BY_ONTOLOGY);
            throw new IllegalArgumentException(builder.toString());
        }
        return this.getAncestorsOfAlgorithmUntil(classifierName, this.classifierTopNode);
    }

    @Override
    public List<String> getAncestorsOfSearcher(String searcher) {
        if (!searcherPortfolio.contains(searcher)) {
            StringBuilder builder = new StringBuilder();
            builder.append(searcher);
            builder.append(MSG_NOT_SUPPORTED_BY_ONTOLOGY);
            throw new IllegalArgumentException(builder.toString());
        }
        return this.getAncestorsOfAlgorithmUntil(searcher, this.searcherTopNode);
    }

    @Override
    public List<String> getAncestorsOfEvaluator(String evaluator) {
        if (!evaluatorPortfolio.contains(evaluator)) {
            StringBuilder builder = new StringBuilder();
            builder.append(evaluator);
            builder.append(MSG_NOT_SUPPORTED_BY_ONTOLOGY);
            throw new IllegalArgumentException(builder.toString());
        }
        return this.getAncestorsOfAlgorithmUntil(evaluator, this.evaluatorTopNode);
    }

    protected List<String> getAncestorsOfAlgorithmUntil(String algorithm, String until) {
        OWLNamedIndividual algorithmAsIndividual = this.dataFactory.getOWLNamedIndividual(this.getAsOntologyElement(algorithm));
        Optional firstAxiom = this.ontology.classAssertionAxioms((OWLIndividual)algorithmAsIndividual).findFirst();
        if (!firstAxiom.isPresent()) {
            throw new IllegalArgumentException("There is no axiom for the given algorithm");
        }
        OWLClass algorithmClass = ((OWLClassAssertionAxiom)firstAxiom.get()).getClassExpression().asOWLClass();
        ArrayList<OWLClass> ancestors = new ArrayList<OWLClass>();
        ancestors.add(algorithmClass);
        for (int i = 0; i < ancestors.size(); ++i) {
            int previousAncestorSize = ancestors.size();
            this.ontology.subClassAxiomsForSubClass((OWLClass)ancestors.get(i)).filter(axiom -> axiom.getSuperClass().getClassExpressionType() == ClassExpressionType.OWL_CLASS).forEach(axiom -> {
                OWLClass toAdd = axiom.getSuperClass().asOWLClass();
                ancestors.add(toAdd);
            });
            if (this.includeEqualSuperClasses && ancestors.size() == previousAncestorSize) {
                this.ontology.equivalentClassesAxioms((OWLClass)ancestors.get(i)).forEach(axiom -> axiom.classExpressions().forEach(elem -> {
                    if (!ancestors.contains(((OWLClassExpression)elem.conjunctSet().findFirst().get()).asOWLClass())) {
                        ancestors.add(((OWLClassExpression)elem.conjunctSet().findFirst().get()).asOWLClass());
                    }
                }));
            }
            if (((OWLClass)ancestors.get(ancestors.size() - 1)).getIRI().getShortForm().equals(until)) break;
        }
        ArrayList<String> ancestorNames = new ArrayList<String>();
        boolean startAdding = true;
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            if (!startAdding) {
                String ancestorName = ((OWLClass)ancestors.get(i)).getIRI().getShortForm();
                if (!ancestorName.equals(until)) continue;
                ancestorNames.add(ancestorName);
                continue;
            }
            ancestorNames.add(((OWLClass)ancestors.get(i)).getIRI().getShortForm());
            startAdding = false;
        }
        ancestorNames.add(algorithmAsIndividual.getIRI().getShortForm());
        return ancestorNames;
    }

    private String getAsOntologyElement(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(ONTOLOGY_IRI);
        builder.append(ONTOLOGY_IRI_SEPARATOR);
        builder.append(name);
        return builder.toString();
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public List<String> getAvailableClassifiers() {
        return classifierPortfolio;
    }

    public List<String> getAvailableSearchers() {
        return searcherPortfolio;
    }

    public List<String> getAvailableEvaluators() {
        return evaluatorPortfolio;
    }

    public static void main(String[] args) throws OWLOntologyCreationException {
        WEKAOntologyConnector connector = new WEKAOntologyConnector();
        for (String classifier : classifierPortfolio) {
            logger.info("{}", connector.getAncestorsOfClassifier(classifier));
        }
        for (String searcher : searcherPortfolio) {
            logger.info("{}", connector.getAncestorsOfSearcher(searcher));
        }
        for (String evaluator : evaluatorPortfolio) {
            logger.info("{}", connector.getAncestorsOfEvaluator(evaluator));
        }
    }

    public String getClassifierTopNode() {
        return this.classifierTopNode;
    }

    public String getSearcherTopNode() {
        return this.searcherTopNode;
    }

    public String getEvaluatorTopNode() {
        return this.evaluatorTopNode;
    }
}

