/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.mlplan.metamining.pipelinecharacterizing.IOntologyConnector;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IPipelineCharacterizer;
import ai.libs.mlplan.metamining.pipelinecharacterizing.WEKAOntologyConnector;
import ai.libs.mlplan.multiclass.wekamlplan.weka.model.MLPipeline;
import ai.libs.mlplan.multiclass.wekamlplan.weka.model.SupervisedFilterSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import treeminer.FrequentSubtreeFinder;
import treeminer.TreeMiner;
import treeminer.TreeRepresentationUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;

public class WEKAPipelineCharacterizer
implements IPipelineCharacterizer {
    private FrequentSubtreeFinder treeMiner = new TreeMiner();
    private IOntologyConnector ontologyConnector;
    private String[] patterns;
    private int minSupport = 1;
    private String preprocessorSubTreeName = "Preprocessor";
    private String preprocessorsSubTreeName = "Preprocessors";
    private String pipelineTreeName = "Pipeline";

    public WEKAPipelineCharacterizer() {
        try {
            this.ontologyConnector = new WEKAOntologyConnector();
        }
        catch (OWLOntologyCreationException e) {
            System.err.println("Cannot connect to Ontology!");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void build(List<MLPipeline> pipelines) {
        ArrayList pipelineRepresentations = new ArrayList();
        pipelines.forEach(pipeline -> pipelineRepresentations.add(this.makeStringTreeRepresentation((MLPipeline)pipeline)));
        this.treeMiner.findFrequentSubtrees(pipelineRepresentations, this.minSupport);
    }

    @Override
    public double[] characterize(MLPipeline pipeline) {
        String treeRepresentation = this.makeStringTreeRepresentation(pipeline);
        double[] pipelineCharacterization = new double[this.patterns.length];
        for (int i = 0; i < this.patterns.length; ++i) {
            pipelineCharacterization[i] = TreeRepresentationUtils.containsSubtree((String)treeRepresentation, (String)this.patterns[i]) ? 1.0 : 0.0;
        }
        return pipelineCharacterization;
    }

    protected String makeStringTreeRepresentation(MLPipeline pipeline) {
        ArrayList preprocessorsSubTree = new ArrayList();
        List<SupervisedFilterSelector> preprocessors = pipeline.getPreprocessors();
        preprocessors.forEach(preprocessor -> {
            String searcher = preprocessor.getSearcher().getClass().getName();
            List<String> searcherBranch = this.ontologyConnector.getAncestorsOfSearcher(searcher);
            String searcherBranchRepresentation = TreeRepresentationUtils.makeRepresentationForBranch(searcherBranch);
            String evaluator = preprocessor.getEvaluator().getClass().getName();
            List<String> evaluatorBranch = this.ontologyConnector.getAncestorsOfEvaluator(evaluator);
            String evaluatorBranchRepresentation = TreeRepresentationUtils.makeRepresentationForBranch(evaluatorBranch);
            String preprocessorSubTree = TreeRepresentationUtils.addChildrenToNode((String)this.preprocessorSubTreeName, Arrays.asList(searcherBranchRepresentation, evaluatorBranchRepresentation));
            preprocessorsSubTree.add(preprocessorSubTree);
        });
        String preprocessorsSubTreeRepresentation = TreeRepresentationUtils.addChildrenToNode((String)this.preprocessorsSubTreeName, preprocessorsSubTree);
        String classifier = pipeline.getBaseClassifier().getClass().getName();
        List<String> classifierBranch = this.ontologyConnector.getAncestorsOfClassifier(classifier);
        String classifierBranchRepresentation = TreeRepresentationUtils.makeRepresentationForBranch(classifierBranch);
        return TreeRepresentationUtils.addChildrenToNode((String)this.pipelineTreeName, Arrays.asList(preprocessorsSubTreeRepresentation, classifierBranchRepresentation));
    }

    private List<String> getParametersForClassifier(Classifier classifier) {
        AbstractClassifier abstractClassifier;
        ArrayList<String> parameters = new ArrayList<String>();
        if (classifier instanceof AbstractClassifier && (abstractClassifier = (AbstractClassifier)classifier).getOptions() != null && abstractClassifier.getOptions().length > 0) {
            abstractClassifier.getOptions();
        }
        return parameters;
    }

    @Override
    public double[][] getCharacterizationsOfTrainingExamples() {
        return null;
    }

    public IOntologyConnector getOntologyConnector() {
        return this.ontologyConnector;
    }

    public void setOntologyConnector(IOntologyConnector ontologyConnector) {
        this.ontologyConnector = ontologyConnector;
    }

    public int getMinSupport() {
        return this.minSupport;
    }

    public void setMinSupport(int minSupport) {
        this.minSupport = minSupport;
    }
}

