/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.similaritymeasures;

import ai.libs.mlplan.metamining.similaritymeasures.IHeterogenousSimilarityMeasureComputer;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.minimize.CostFunction;
import de.jungblut.math.minimize.CostGradientTuple;
import de.jungblut.math.minimize.GradientDescent;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class F1Optimizer
implements IHeterogenousSimilarityMeasureComputer {
    private static final double ALPHA_START = 1.0E-9;
    private static final double ALPHA_MAX = 1.0E-5;
    private static final int ITERATIONS_PER_PROBE = 100;
    private static final int LIMIT = 1;
    private static final boolean VERBOSE = false;
    private static final double MAX_DESIRED_ERROR = 0.0;
    private INDArray RRT;
    private INDArray X;
    private INDArray U;

    @Override
    public void build(final INDArray X, INDArray W, INDArray R) {
        this.RRT = R.mmul(R.transpose());
        this.X = X;
        int m = X.columns();
        boolean numberOfImplicitFeatures = true;
        double[] denseVector = new double[m * 1];
        int c = 0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < 1; ++j) {
                denseVector[c++] = (Math.random() - 0.5) * 100.0;
            }
        }
        DenseDoubleVector currentSolutionAsVector = new DenseDoubleVector(denseVector);
        INDArray currentSolutionAsMatrix = this.vector2matrix((DoubleVector)currentSolutionAsVector, m, 1);
        double currentCost = this.getCost(currentSolutionAsMatrix);
        System.out.println("X = " + X);
        System.out.println("randomly initialized U = " + currentSolutionAsMatrix);
        System.out.println("loss of randomly initialized U: " + currentCost);
        CostFunction cf = new CostFunction(){

            public CostGradientTuple evaluateCost(DoubleVector input) {
                INDArray U = F1Optimizer.this.vector2matrix(input, X.columns(), 1);
                double cost = F1Optimizer.this.getCost(U);
                INDArray gradientMatrix = F1Optimizer.this.getGradientAsMatrix(U);
                CostGradientTuple cgt = new CostGradientTuple(cost, F1Optimizer.this.matrix2vector(gradientMatrix));
                return cgt;
            }
        };
        double alpha = 1.0E-9;
        while (currentCost > 0.0) {
            double lastCost = currentCost;
            DenseDoubleVector lastSolution = currentSolutionAsVector;
            GradientDescent gd = new GradientDescent(alpha, 1.0);
            currentSolutionAsMatrix = this.vector2matrix((DoubleVector)(currentSolutionAsVector = gd.minimize(cf, (DoubleVector)currentSolutionAsVector, 100, false)), m, 1);
            currentCost = this.getCost(currentSolutionAsMatrix);
            if (lastCost < currentCost) {
                currentSolutionAsVector = lastSolution;
                currentCost = lastCost;
                alpha /= 2.0;
            } else {
                if (!(lastCost > currentCost)) break;
                alpha *= 2.0;
            }
            alpha = Math.min(alpha, 1.0E-5);
            System.out.println(currentCost + " (alpha = " + alpha + ")");
        }
        this.U = currentSolutionAsMatrix;
    }

    public INDArray vector2matrix(DoubleVector vector, int m, int n) {
        double[] inputs = new double[vector.getLength()];
        for (int i = 0; i < vector.getLength(); ++i) {
            inputs[i] = vector.get(i);
        }
        return Nd4j.create((double[])inputs, (int[])new int[]{m, n});
    }

    public DoubleVector matrix2vector(INDArray matrix) {
        int m = matrix.rows();
        int n = matrix.columns();
        double[] denseVector = new double[m * n];
        int c = 0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                denseVector[c++] = matrix.getDouble(i, j);
            }
        }
        return new DenseDoubleVector(denseVector);
    }

    public double getCost(INDArray U) {
        INDArray Z1 = this.X.mmul(U);
        INDArray Z2 = Z1.transpose();
        INDArray Z = Z1.mmul(Z2);
        INDArray Q = this.RRT.sub(Z);
        double cost = 0.0;
        int n = Q.columns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                cost += Math.pow(Q.getDouble(i, j), 2.0);
            }
        }
        return cost;
    }

    public INDArray getGradientAsMatrix(INDArray U) {
        int m = this.X.columns();
        int n = U.columns();
        float[][] derivatives = new float[m][n];
        for (int k = 0; k < m; ++k) {
            for (int l = 0; l < n; ++l) {
                derivatives[k][l] = this.getFirstDerivative(U, k, l);
            }
        }
        return Nd4j.create((float[][])derivatives);
    }

    public float getFirstDerivative(INDArray U, int k, int l) {
        INDArray Z1 = this.X.mmul(U);
        INDArray Z2 = Z1.transpose();
        INDArray Z = Z1.mmul(Z2);
        INDArray Q = this.RRT.sub(Z);
        int n = this.X.rows();
        float[] sums = new float[n];
        for (int i = 0; i < n; ++i) {
            sums[i] = this.X.getRow(i).mmul(U.getColumn(l)).getFloat(0, 0);
        }
        float derivative = 0.0f;
        for (int i = 0; i < n; ++i) {
            float Xik = this.X.getFloat(i, k);
            for (int j = 0; j < n; ++j) {
                float sumA = Xik * sums[j];
                float sumB = this.X.getFloat(j, k) * sums[i];
                derivative += -2.0f * Q.getFloat(i, j) * (sumA + sumB);
            }
        }
        return derivative;
    }

    @Override
    public double computeSimilarity(INDArray x, INDArray w) {
        return 0.0;
    }

    public INDArray getX() {
        return this.X;
    }

    public INDArray getU() {
        return this.U;
    }
}

