/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan;

import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPlugin;
import ai.libs.hasco.model.Component;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.IAlgorithm;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphViewPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGenerator;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePlugin;
import ai.libs.jaicore.graphvisualizer.window.AlgorithmVisualizationWindow;
import ai.libs.jaicore.ml.evaluation.IInstancesClassifier;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNodeInfoGenerator;
import ai.libs.jaicore.search.gui.plugins.rollouthistograms.SearchRolloutHistogramPlugin;
import ai.libs.jaicore.search.model.travesaltree.JaicoreNodeInfoGenerator;
import ai.libs.mlplan.core.AbstractMLPlanBuilder;
import ai.libs.mlplan.core.MLPlan;
import ai.libs.mlplan.multiclass.MLPlanClassifierConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;

public class MLPlanWekaClassifier
implements Classifier,
CapabilitiesHandler,
OptionHandler,
ILoggingCustomizable,
IInstancesClassifier {
    private Logger logger = LoggerFactory.getLogger(MLPlanWekaClassifier.class);
    private String loggerName;
    private boolean visualizationEnabled = false;
    private final transient AbstractMLPlanBuilder builder;
    private TimeOut timeout;
    private Classifier classifierFoundByMLPlan;
    private double internalValidationErrorOfSelectedClassifier;

    public MLPlanWekaClassifier(AbstractMLPlanBuilder builder) {
        this.builder = builder;
        this.timeout = builder.getTimeOut();
    }

    public void buildClassifier(Instances data) throws Exception {
        Objects.requireNonNull(this.timeout, "Timeout must be set before running ML-Plan.");
        MLPlan mlplan = new MLPlan(this.builder, data);
        mlplan.setTimeout(this.timeout);
        if (this.loggerName != null) {
            mlplan.setLoggerName(this.loggerName + ".mlplan");
        }
        if (this.visualizationEnabled) {
            new JFXPanel();
            AlgorithmVisualizationWindow window = new AlgorithmVisualizationWindow((IAlgorithm)mlplan, (IGUIPlugin)new GraphViewPlugin(), new IGUIPlugin[]{new NodeInfoGUIPlugin((NodeInfoGenerator)new JaicoreNodeInfoGenerator((NodeInfoGenerator)new TFDNodeInfoGenerator())), new SearchRolloutHistogramPlugin(), new SolutionPerformanceTimelinePlugin(), new HASCOModelStatisticsPlugin()});
            Platform.runLater((Runnable)window);
        }
        this.classifierFoundByMLPlan = mlplan.call();
    }

    public double[] classifyInstances(Instances instances) throws Exception {
        if (this.getSelectedClassifier() instanceof IInstancesClassifier) {
            return ((IInstancesClassifier)this.getSelectedClassifier()).classifyInstances(instances);
        }
        double[] predictions = new double[instances.size()];
        for (int i = 0; i < instances.size(); ++i) {
            predictions[i] = this.getSelectedClassifier().classifyInstance(instances.get(i));
        }
        return predictions;
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.classifierFoundByMLPlan == null) {
            throw new IllegalStateException("Classifier has not been built yet.");
        }
        return this.classifierFoundByMLPlan.classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.classifierFoundByMLPlan == null) {
            throw new IllegalStateException("Classifier has not been built yet.");
        }
        return this.classifierFoundByMLPlan.distributionForInstance(instance);
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public Enumeration<Option> listOptions() {
        return null;
    }

    public void setOptions(String[] options) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    public void setTimeout(TimeOut timeout) {
        this.timeout = timeout;
    }

    public MLPlanClassifierConfig getMLPlanConfig() {
        return this.builder.getAlgorithmConfig();
    }

    public Collection<Component> getComponents() throws IOException {
        return this.builder.getComponents();
    }

    public void setVisualizationEnabled(boolean visualizationEnabled) {
        this.visualizationEnabled = visualizationEnabled;
    }

    public Classifier getSelectedClassifier() {
        return this.classifierFoundByMLPlan;
    }

    public double getInternalValidationErrorOfSelectedClassifier() {
        return this.internalValidationErrorOfSelectedClassifier;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger name to {}", (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched ML-Plan logger to {}", (Object)name);
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

