/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan.sophisticated.featuregen;

import ai.libs.mlplan.multiclass.wekamlplan.sophisticated.featuregen.FeatureGenerator;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class PolynomialFeatures
implements FeatureGenerator {
    private boolean isPrepared;
    private int potence = 2;
    private List<Integer> indicesToSquare = new ArrayList<Integer>();

    @Override
    public void prepare(Instances data) throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.indicesToSquare.clear();
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (!data.attribute(i).isNumeric()) continue;
            attributes.add(new Attribute("q" + i, false));
            this.indicesToSquare.add(i);
        }
        this.isPrepared = true;
    }

    private Instances getEmptyDataset() {
        if (!this.isPrepared) {
            throw new IllegalStateException("Cannot get empty dataset before preparation");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int indexToSquare : this.indicesToSquare) {
            attributes.add(new Attribute("pow_" + this.potence + "_" + indexToSquare, false));
        }
        return new Instances("potences", attributes, 0);
    }

    @Override
    public Instance apply(Instance data) throws Exception {
        DenseInstance copy = new DenseInstance(this.indicesToSquare.size());
        int i = 0;
        for (int index : this.indicesToSquare) {
            copy.setValue(i++, Math.pow(data.value(index), this.potence));
        }
        Instances dataset = this.getEmptyDataset();
        dataset.add((Instance)copy);
        copy.setDataset(dataset);
        return copy;
    }

    @Override
    public Instances apply(Instances data) throws Exception {
        Instances copy = this.getEmptyDataset();
        for (Instance inst : data) {
            Instance modInst = this.apply(inst);
            copy.add(modInst);
            modInst.setDataset(copy);
        }
        return copy;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    public int getPotence() {
        return this.potence;
    }

    public void setPotence(int potence) {
        this.potence = potence;
    }
}

