/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan.weka;

import ai.libs.hasco.core.Util;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import ai.libs.jaicore.search.model.travesaltree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceBasedNodeEvaluator
implements INodeEvaluator<TFDNode, Double> {
    private final Collection<Component> components;
    private final List<String> orderingOfComponents;
    private static final Logger logger = LoggerFactory.getLogger(PreferenceBasedNodeEvaluator.class);
    private boolean sentLogMessageForHavingEnteredSecondSubPhase = false;
    private String methodPrefix = "resolveAbstractClassifierWith";

    public PreferenceBasedNodeEvaluator(Collection<Component> components, List<String> orderingOfComponents) {
        this.components = components;
        this.orderingOfComponents = orderingOfComponents;
    }

    public PreferenceBasedNodeEvaluator(Collection<Component> components) {
        this(components, new ArrayList<String>());
    }

    public PreferenceBasedNodeEvaluator(Collection<Component> components, List<String> orderingOfComponents, String methodPrefix) {
        this(components, orderingOfComponents);
        this.methodPrefix = methodPrefix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Double f(Node<TFDNode, ?> n) {
        LinkedList<String> appliedMethods = new LinkedList<String>();
        for (TFDNode x2 : n.externalPath()) {
            if (x2.getAppliedMethodInstance() == null) continue;
            appliedMethods.add(x2.getAppliedMethodInstance().getMethod().getName());
        }
        ComponentInstance instance = Util.getSolutionCompositionFromState(this.components, (Monom)((TFDNode)n.getPoint()).getState(), (boolean)false);
        boolean isPipeline = appliedMethods.stream().anyMatch(x -> x.toLowerCase().contains("pipeline"));
        boolean lastMethod = false;
        String classifierName = null;
        Double score = 0.0;
        if (instance == null) return score;
        if (instance.getComponent().getName().toLowerCase().contains("pipeline")) {
            lastMethod = lastMethod || ((String)appliedMethods.get(appliedMethods.size() - 1)).startsWith("resolveBaseClassifierWith");
            if (!instance.getSatisfactionOfRequiredInterfaces().containsKey("classifier")) return 0.0;
            classifierName = ((ComponentInstance)instance.getSatisfactionOfRequiredInterfaces().get("classifier")).getComponent().getName();
        } else {
            classifierName = instance.getComponent().getName();
            boolean bl = lastMethod = lastMethod || ((String)appliedMethods.get(appliedMethods.size() - 1)).startsWith(this.methodPrefix);
        }
        if (lastMethod) {
            if (isPipeline) {
                score = score + (double)(this.orderingOfComponents.size() + 1);
            }
            score = score + (double)(this.orderingOfComponents.contains(classifierName) ? this.orderingOfComponents.indexOf(classifierName) + 1 : this.orderingOfComponents.size() + 1);
            return score * 1.0E-10;
        }
        score = null;
        if (this.sentLogMessageForHavingEnteredSecondSubPhase) return score;
        if (!((Double)n.getParent().getInternalLabel() > 1.0E-6)) return score;
        this.sentLogMessageForHavingEnteredSecondSubPhase = true;
        logger.info("Entering phase 1b! Breadth first search ends here, because the search is asking for the f-value of a node whose parent has been truely evaluated with an f-value of {}", (Object)n.getParent().getInternalLabel());
        return score;
    }

    public String toString() {
        return "PreferenceBasedNodeEvaluator [ORDERING_OF_CLASSIFIERS=" + this.orderingOfComponents + "]";
    }
}

