/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan.weka;

import ai.libs.hasco.exceptions.ComponentInstantiationFailedException;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import ai.libs.mlplan.multiclass.wekamlplan.weka.model.MLPipeline;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.OptionHandler;

public class WEKAPipelineFactory
implements IClassifierFactory {
    private Logger logger = LoggerFactory.getLogger(WEKAPipelineFactory.class);
    private static final String L_CLASSIFIER = "classifier";

    public Classifier getComponentInstantiation(ComponentInstance groundComponent) throws ComponentInstantiationFailedException {
        try {
            if (groundComponent.getComponent().getName().equals("pipeline")) {
                ComponentInstance preprocessorCI = null;
                preprocessorCI = (ComponentInstance)groundComponent.getSatisfactionOfRequiredInterfaces().get("preprocessor");
                ComponentInstance evaluatorCI = (ComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterfaces().get("eval");
                ComponentInstance searcherCI = (ComponentInstance)preprocessorCI.getSatisfactionOfRequiredInterfaces().get("search");
                ASEvaluation eval = ASEvaluation.forName((String)evaluatorCI.getComponent().getName(), (String[])this.getParameterList(evaluatorCI).toArray(new String[0]));
                ASSearch search = ASSearch.forName((String)searcherCI.getComponent().getName(), (String[])this.getParameterList(searcherCI).toArray(new String[0]));
                Classifier c = this.getComponentInstantiation((ComponentInstance)groundComponent.getSatisfactionOfRequiredInterfaces().get(L_CLASSIFIER));
                return new MLPipeline(search, eval, c);
            }
            Classifier c = AbstractClassifier.forName((String)groundComponent.getComponent().getName(), (String[])this.getParameterList(groundComponent).toArray(new String[0]));
            List<String> options = this.getParameterList(groundComponent);
            options.add("-do-not-check-capabilities");
            if (c instanceof OptionHandler) {
                ((OptionHandler)c).setOptions(options.toArray(new String[0]));
            }
            block12: for (Map.Entry reqI : groundComponent.getSatisfactionOfRequiredInterfaces().entrySet()) {
                switch ((String)reqI.getKey()) {
                    case "W": {
                        if (c instanceof SingleClassifierEnhancer) {
                            ((SingleClassifierEnhancer)c).setClassifier(this.getComponentInstantiation((ComponentInstance)reqI.getValue()));
                            continue block12;
                        }
                        this.logger.error("Got required interface W but classifier {} is not single classifier enhancer", (Object)c.getClass().getName());
                        continue block12;
                    }
                    case "K": {
                        if (c instanceof SMO) {
                            Kernel k = (Kernel)Class.forName(((ComponentInstance)reqI.getValue()).getComponent().getName()).newInstance();
                            k.setOptions(this.getParameterList((ComponentInstance)reqI.getValue()).toArray(new String[0]));
                            ((SMO)c).setKernel(k);
                            continue block12;
                        }
                        this.logger.error("Got required interface K but classifier {} is not SMO", (Object)c.getClass().getName());
                        continue block12;
                    }
                    case "B": {
                        List<Classifier> baseLearnerList = this.getListOfBaseLearners((ComponentInstance)reqI.getValue());
                        if (c instanceof MultipleClassifiersCombiner) {
                            ((MultipleClassifiersCombiner)c).setClassifiers(baseLearnerList.toArray(new Classifier[0]));
                            continue block12;
                        }
                        this.logger.error("Got required interface B but classifier {} is not MultipleClassifiersCombiner", (Object)c.getClass().getName());
                        continue block12;
                    }
                }
                this.logger.error("Got required interface {} for classifier {}. Dont know what to do with it...", reqI.getKey(), (Object)c.getClass().getName());
            }
            return c;
        }
        catch (Exception e) {
            throw new ComponentInstantiationFailedException((Throwable)e, "Could not instantiate component.");
        }
    }

    private List<Classifier> getListOfBaseLearners(ComponentInstance ci) throws ComponentInstantiationFailedException {
        LinkedList<Classifier> baseLearnerList = new LinkedList<Classifier>();
        if (ci.getComponent().getName().equals("MultipleBaseLearnerListElement")) {
            baseLearnerList.add(this.getComponentInstantiation((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get(L_CLASSIFIER)));
        } else if (ci.getComponent().getName().equals("MultipleBaseLearnerListChain")) {
            baseLearnerList.add(this.getComponentInstantiation((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get(L_CLASSIFIER)));
            baseLearnerList.addAll(this.getListOfBaseLearners((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get("chain")));
        }
        return baseLearnerList;
    }

    private List<String> getParameterList(ComponentInstance ci) {
        LinkedList<String> parameters = new LinkedList<String>();
        for (Map.Entry parameterValues : ci.getParameterValues().entrySet()) {
            if (((String)parameterValues.getKey()).toLowerCase().endsWith("activator") || ((String)parameterValues.getValue()).equals("REMOVED")) continue;
            if (!((String)parameterValues.getValue()).equals("false")) {
                parameters.add("-" + (String)parameterValues.getKey());
            }
            if (parameterValues.getValue() == null || ((String)parameterValues.getValue()).equals("") || ((String)parameterValues.getValue()).equals("true") || ((String)parameterValues.getValue()).equals("false")) continue;
            parameters.add((String)parameterValues.getValue());
        }
        return parameters;
    }
}

