/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclass.wekamlplan.weka;

import ai.libs.hasco.core.Util;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.exceptions.ControlledNodeEvaluationException;
import ai.libs.jaicore.search.model.travesaltree.Node;
import ai.libs.mlplan.core.PipelineValidityCheckingNodeEvaluator;
import java.util.Arrays;
import java.util.Collection;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class WekaPipelineValidityCheckingNodeEvaluator
extends PipelineValidityCheckingNodeEvaluator {
    private boolean propertiesDetermined;
    private boolean binaryClass;
    private boolean multiClass;
    private boolean regression;
    private boolean multiValuedNominalAttributes;
    private boolean containsNegativeValues;

    public WekaPipelineValidityCheckingNodeEvaluator() {
    }

    public WekaPipelineValidityCheckingNodeEvaluator(Collection<Component> components, Instances data) {
        super(components, data);
    }

    private boolean multiValuedNominalAttributesExist() {
        for (int i = 0; i < this.getData().numAttributes(); ++i) {
            Attribute att = this.getData().attribute(i);
            if (att == this.getData().classAttribute() || !att.isNominal() || att.numValues() <= 2) continue;
            return true;
        }
        return false;
    }

    private synchronized void extractDatasetProperties() {
        if (!this.propertiesDetermined) {
            this.binaryClass = this.getData().classAttribute().isNominal() && this.getData().classAttribute().numValues() == 2;
            this.multiClass = this.getData().classAttribute().isNominal() && this.getData().classAttribute().numValues() > 2;
            this.regression = this.getData().classAttribute().isNumeric();
            this.multiValuedNominalAttributes = this.multiValuedNominalAttributesExist();
            this.containsNegativeValues = false;
            for (Instance i : this.getData()) {
                this.containsNegativeValues = this.containsNegativeValues || Arrays.stream(i.toDoubleArray()).anyMatch(x -> x < 0.0);
            }
            this.propertiesDetermined = true;
        }
    }

    public Double f(Node<TFDNode, ?> n) throws ControlledNodeEvaluationException {
        ComponentInstance instance;
        if (!this.propertiesDetermined) {
            this.extractDatasetProperties();
        }
        if ((instance = Util.getSolutionCompositionFromState(this.getComponents(), (Monom)((TFDNode)n.getPoint()).getState(), (boolean)false)) != null) {
            ComponentInstance classifier;
            ComponentInstance pp = (ComponentInstance)instance.getSatisfactionOfRequiredInterfaces().get("preprocessor");
            if (pp != null && pp.getComponent().getName().contains("AttributeSelection")) {
                ComponentInstance search = (ComponentInstance)pp.getSatisfactionOfRequiredInterfaces().get("search");
                ComponentInstance eval = (ComponentInstance)pp.getSatisfactionOfRequiredInterfaces().get("eval");
                if (search != null && eval != null && !WekaUtil.isValidPreprocessorCombination((String)search.getComponent().getName(), (String)eval.getComponent().getName())) {
                    throw new ControlledNodeEvaluationException("The given combination of searcher and evaluator cannot be benchmarked since they are incompatible.");
                }
            }
            if ((classifier = instance.getComponent().getName().toLowerCase().contains("pipeline") ? (ComponentInstance)instance.getSatisfactionOfRequiredInterfaces().get("classifier") : instance) != null) {
                this.checkValidity(classifier.getComponent().getName().toLowerCase());
            }
        }
        return null;
    }

    private void checkValidity(String classifierName) throws ControlledNodeEvaluationException {
        boolean binaryClassifierMatch = classifierName.matches("(.*)(additiveregression|simplelinearregression|m5rules|votedperceptron|m5p)(.*)");
        if (!this.binaryClass && binaryClassifierMatch) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on non-binary datasets.");
        }
        boolean noBinaryClassifierMatch = classifierName.matches("(.*)(additiveregression|m5p|m5rules|simplelinearregression)(.*)");
        if (this.binaryClass && noBinaryClassifierMatch) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted for binary classification tasks.");
        }
        if (this.multiValuedNominalAttributes && classifierName.matches("(.*)(naivebayesmultinomial|simplelinearregression)(.*)")) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on datasets with multi-valued nominal attributes.");
        }
        boolean noMulticlassClassifierMatch = classifierName.matches("(.*)(votedperceptron)(.*)");
        if (this.multiClass && noMulticlassClassifierMatch) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on multinomial classification dataset.");
        }
        if (this.regression && !classifierName.matches("(.*)(additiveregression|m5p|m5rules|simplelinearregression)(.*)")) {
            throw new ControlledNodeEvaluationException(classifierName + " cannot be adopted on regression problems.");
        }
        if (this.containsNegativeValues && classifierName.matches("(.*)(naivebayesmultinomial)(.*)")) {
            throw new ControlledNodeEvaluationException("Negative numeric attribute values are not supported by the classifier.");
        }
    }
}

