/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multiclasswithreduction;

import java.util.ArrayList;
import java.util.Collection;

public class ClassSplit<T> {
    private final Collection<T> classes;
    private final Collection<T> l;
    private final Collection<T> r;

    public ClassSplit(Collection<T> classes, Collection<T> l, Collection<T> r) {
        this.classes = classes;
        this.l = l;
        this.r = r;
    }

    public ClassSplit(ClassSplit<T> split) {
        this(split.getClasses(), new ArrayList<T>(split.getL()), new ArrayList<T>(split.getR()));
    }

    public Collection<T> getClasses() {
        return this.classes;
    }

    public Collection<T> getL() {
        return this.l;
    }

    public Collection<T> getR() {
        return this.r;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classes == null ? 0 : this.classes.hashCode());
        result = 31 * result + (this.l == null ? 0 : this.l.hashCode());
        result = 31 * result + (this.r == null ? 0 : this.r.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassSplit other = (ClassSplit)obj;
        if (this.classes == null ? other.classes != null : !this.classes.equals(other.classes)) {
            return false;
        }
        if (this.l == null ? other.l != null : !this.l.equals(other.l)) {
            return false;
        }
        return !(this.r == null ? other.r != null : !this.r.equals(other.r));
    }

    public String toString() {
        return "ClassSplit [classes=" + this.classes + ", l=" + this.l + ", r=" + this.r + "]";
    }
}

