/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.multilabel;

import ai.libs.hasco.exceptions.ComponentInstantiationFailedException;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.mlplan.multiclass.wekamlplan.IClassifierFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import meka.classifiers.multilabel.MultiLabelClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.OptionHandler;

public class MekaPipelineFactory
implements IClassifierFactory {
    private static final String PARAMETER_NAME_WITH_DASH_WARNING = "Required interface of component {} has dash or underscore in interface id {}";
    private static final Logger logger = LoggerFactory.getLogger(MekaPipelineFactory.class);

    public Classifier getComponentInstantiation(ComponentInstance ci) throws ComponentInstantiationFailedException {
        MultiLabelClassifier instance = null;
        try {
            instance = (MultiLabelClassifier)this.getClassifier(ci);
            return instance;
        }
        catch (Exception e) {
            throw new ComponentInstantiationFailedException((Throwable)e, "Could not instantiate " + ci.getComponent().getName());
        }
    }

    private Classifier getClassifier(ComponentInstance ci) throws Exception {
        Classifier c = (Classifier)Class.forName(ci.getComponent().getName()).newInstance();
        List<String> optionsList = this.getOptionsForParameterValues(ci);
        for (Map.Entry reqI : ci.getSatisfactionOfRequiredInterfaces().entrySet()) {
            if (((String)reqI.getKey()).startsWith("-") || ((String)reqI.getKey()).startsWith("_")) {
                logger.warn(PARAMETER_NAME_WITH_DASH_WARNING, (Object)ci.getComponent(), reqI.getKey());
            }
            if (((String)reqI.getKey()).equals("B") || c instanceof SingleClassifierEnhancer || ((String)reqI.getKey()).equals("K") && ci.getComponent().getName().endsWith("SMO")) continue;
            logger.warn("Classifier {} is not a single classifier enhancer and still has an unexpected required interface: {}. Try to set this configuration in the form of options.", (Object)ci.getComponent().getName(), reqI);
            optionsList.add("-" + (String)reqI.getKey());
            optionsList.add(((ComponentInstance)reqI.getValue()).getComponent().getName());
            if (((ComponentInstance)reqI.getValue()).getParameterValues().isEmpty() && ((ComponentInstance)reqI.getValue()).getSatisfactionOfRequiredInterfaces().isEmpty()) continue;
            optionsList.add("--");
            optionsList.addAll(this.getOptionsRecursively((ComponentInstance)reqI.getValue()));
        }
        if (c instanceof OptionHandler) {
            ((OptionHandler)c).setOptions(optionsList.toArray(new String[0]));
        }
        for (Map.Entry reqI : ci.getSatisfactionOfRequiredInterfaces().entrySet()) {
            if (((String)reqI.getKey()).startsWith("-") || ((String)reqI.getKey()).startsWith("_")) {
                logger.warn(PARAMETER_NAME_WITH_DASH_WARNING, (Object)ci.getComponent(), reqI.getKey());
            }
            if (((String)reqI.getKey()).equals("K") && ci.getComponent().getName().endsWith("SMO")) {
                ComponentInstance kernelCI = (ComponentInstance)reqI.getValue();
                logger.debug("Set kernel for SMO to be {}", (Object)kernelCI.getComponent().getName());
                Kernel k = (Kernel)Class.forName(kernelCI.getComponent().getName()).newInstance();
                k.setOptions(this.getOptionsForParameterValues(kernelCI).toArray(new String[0]));
                continue;
            }
            if (((String)reqI.getKey()).equals("B") && c instanceof MultipleClassifiersCombiner) {
                Classifier[] classifiers = this.getListOfBaseLearners((ComponentInstance)reqI.getValue()).toArray(new Classifier[0]);
                ((MultipleClassifiersCombiner)c).setClassifiers(classifiers);
                continue;
            }
            if (!((String)reqI.getKey()).equals("W") || !(c instanceof SingleClassifierEnhancer)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Set {} as a base classifier for {}", (Object)((ComponentInstance)reqI.getValue()).getComponent().getName(), (Object)ci.getComponent().getName());
            }
            ((SingleClassifierEnhancer)c).setClassifier(this.getClassifier((ComponentInstance)reqI.getValue()));
        }
        return c;
    }

    private List<Classifier> getListOfBaseLearners(ComponentInstance ci) throws Exception {
        LinkedList<Classifier> baseLearnerList = new LinkedList<Classifier>();
        if (ci.getComponent().getName().equals("MultipleBaseLearnerListElement")) {
            baseLearnerList.add(this.getClassifier((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get("classifier")));
        } else if (ci.getComponent().getName().equals("MultipleBaseLearnerListChain")) {
            baseLearnerList.add(this.getClassifier((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get("classifier")));
            baseLearnerList.addAll(this.getListOfBaseLearners((ComponentInstance)ci.getSatisfactionOfRequiredInterfaces().get("chain")));
        }
        return baseLearnerList;
    }

    private List<String> getOptionsForParameterValues(ComponentInstance ci) {
        LinkedList<String> optionsList = new LinkedList<String>();
        for (Map.Entry parameterValue : ci.getParameterValues().entrySet()) {
            if (((String)parameterValue.getKey()).startsWith("-") || ((String)parameterValue.getKey()).startsWith("_")) {
                logger.warn(PARAMETER_NAME_WITH_DASH_WARNING, (Object)ci.getComponent(), parameterValue);
            }
            if (((String)parameterValue.getValue()).equals("true")) {
                optionsList.add("-" + (String)parameterValue.getKey());
                continue;
            }
            if (((String)parameterValue.getKey()).toLowerCase().contains("activator") || ((String)parameterValue.getValue()).equals("false")) continue;
            optionsList.add("-" + (String)parameterValue.getKey());
            if (ci.getComponent().getParameterWithName((String)parameterValue.getKey()).isNumeric()) {
                NumericParameterDomain numDom = (NumericParameterDomain)ci.getComponent().getParameterWithName((String)parameterValue.getKey()).getDefaultDomain();
                if (numDom.isInteger()) {
                    optionsList.add((int)Double.parseDouble((String)parameterValue.getValue()) + "");
                    continue;
                }
                optionsList.add((String)parameterValue.getValue());
                continue;
            }
            optionsList.add((String)parameterValue.getValue());
        }
        return optionsList;
    }

    private List<String> getOptionsRecursively(ComponentInstance ci) {
        List<String> optionsList = this.getOptionsForParameterValues(ci);
        for (Map.Entry reqI : ci.getSatisfactionOfRequiredInterfaces().entrySet()) {
            if (((String)reqI.getKey()).startsWith("-") || ((String)reqI.getKey()).startsWith("_")) {
                logger.warn(PARAMETER_NAME_WITH_DASH_WARNING, (Object)ci.getComponent(), reqI.getKey());
            }
            optionsList.add("-" + (String)reqI.getKey());
            if (((String)reqI.getKey()).equals("B") || ((String)reqI.getKey()).equals("K")) {
                LinkedList<String> valueList = new LinkedList<String>();
                valueList.add(((ComponentInstance)reqI.getValue()).getComponent().getName());
                valueList.addAll(this.getOptionsRecursively((ComponentInstance)reqI.getValue()));
                optionsList.add(SetUtil.implode(valueList, (String)" "));
                continue;
            }
            optionsList.add(((ComponentInstance)reqI.getValue()).getComponent().getName());
            if (((ComponentInstance)reqI.getValue()).getParameterValues().isEmpty() && ((ComponentInstance)reqI.getValue()).getSatisfactionOfRequiredInterfaces().isEmpty()) continue;
            optionsList.add("--");
            optionsList.addAll(this.getOptionsRecursively((ComponentInstance)reqI.getValue()));
        }
        return optionsList;
    }
}

