/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.ensemble.simple;

import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.reduction.Util;
import ai.libs.reduction.ensemble.simple.EnsembleOfSimpleOneStepReductionsExperiment;
import ai.libs.reduction.ensemble.simple.MySQLEnsembleOfSimpleOneStepReductionsExperiment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class MySQLEnsembleOfSimpleOneStepReductionsExperimentRunner {
    private static final String TABLE_NAME = "homogeneousensemblesofreductionstumps";
    private final SQLAdapter adapter;
    private final Collection<MySQLEnsembleOfSimpleOneStepReductionsExperiment> knownExperiments = new HashSet<MySQLEnsembleOfSimpleOneStepReductionsExperiment>();

    public MySQLEnsembleOfSimpleOneStepReductionsExperimentRunner(String host, String user, String password, String database) {
        this.adapter = new SQLAdapter(host, user, password, database);
        try {
            this.knownExperiments.addAll(this.getConductedExperiments());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Collection<MySQLEnsembleOfSimpleOneStepReductionsExperiment> getConductedExperiments() throws SQLException {
        HashSet<MySQLEnsembleOfSimpleOneStepReductionsExperiment> experiments = new HashSet<MySQLEnsembleOfSimpleOneStepReductionsExperiment>();
        ResultSet rs = this.adapter.getRowsOfTable(TABLE_NAME);
        while (rs.next()) {
            experiments.add(new MySQLEnsembleOfSimpleOneStepReductionsExperiment(rs.getInt("evaluation_id"), new EnsembleOfSimpleOneStepReductionsExperiment(rs.getInt("seed"), rs.getString("dataset"), rs.getString("classifier"), rs.getInt("size"), rs.getDouble("errorRate"), rs.getString("exception"))));
        }
        return experiments;
    }

    public MySQLEnsembleOfSimpleOneStepReductionsExperiment createAndGetExperimentIfNotConducted(int seed, File dataFile, String nameOfClassifier, int size) throws FileNotFoundException, IOException {
        EnsembleOfSimpleOneStepReductionsExperiment exp = new EnsembleOfSimpleOneStepReductionsExperiment(seed, dataFile.getAbsolutePath(), nameOfClassifier, size);
        Optional<MySQLEnsembleOfSimpleOneStepReductionsExperiment> existingExperiment = this.knownExperiments.stream().filter(e -> e.getExperiment().equals(exp)).findAny();
        if (existingExperiment.isPresent()) {
            return null;
        }
        if (this.canInfeasibilityBeDerived(this.knownExperiments, exp)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seed", String.valueOf(seed));
        map.put("dataset", dataFile.getAbsolutePath());
        map.put("classifier", nameOfClassifier);
        map.put("size", size);
        try {
            int id = this.adapter.insert(TABLE_NAME, map);
            return new MySQLEnsembleOfSimpleOneStepReductionsExperiment(id, exp);
        }
        catch (SQLException e2) {
            System.err.println(e2.getMessage());
            return null;
        }
    }

    private void updateExperiment(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp, Map<String, ? extends Object> values) throws SQLException {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("evaluation_id", String.valueOf(exp.getId()));
        this.adapter.update(TABLE_NAME, values, where);
    }

    public void conductExperiment(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp) throws Exception {
        List<Map<String, Object>> mccvResults = Util.conductEnsembleOfOneStepReductionsExperiment(exp.getExperiment());
        DescriptiveStatistics errorRate = new DescriptiveStatistics();
        DescriptiveStatistics runtime = new DescriptiveStatistics();
        for (Map<String, Object> result : mccvResults) {
            errorRate.addValue(((Double)result.get("errorRate")).doubleValue());
            runtime.addValue((double)((Long)result.get("trainTime")).longValue());
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("errorRate", errorRate.getMean());
        this.updateExperiment(exp, values);
    }

    public void markExperimentAsUnsolvable(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : new String[]{"errorRate"}) {
            values.put(key, "-1");
        }
        this.updateExperiment(exp, values);
    }

    public void associateExperimentWithException(MySQLEnsembleOfSimpleOneStepReductionsExperiment exp, String classifier, Throwable e) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : new String[]{"errorRate"}) {
            values.put(key, "-1");
        }
        values.put("exception", e.getClass().getName() + "\n" + e.getMessage());
        this.updateExperiment(exp, values);
    }

    private boolean canInfeasibilityBeDerived(Collection<MySQLEnsembleOfSimpleOneStepReductionsExperiment> experimentsWithResults, EnsembleOfSimpleOneStepReductionsExperiment experimentInQuestion) {
        for (MySQLEnsembleOfSimpleOneStepReductionsExperiment knownExperiment : experimentsWithResults) {
            EnsembleOfSimpleOneStepReductionsExperiment re;
            if (!knownExperiment.getExperiment().getDataset().equals(experimentInQuestion.getDataset()) || (re = knownExperiment.getExperiment()).getException() == null || !re.getNameOfClassifier().equals(experimentInQuestion.getNameOfClassifier())) continue;
            System.out.println("Skipping because " + experimentInQuestion.getNameOfClassifier() + " is known to be problematic as classifier on " + re.getDataset() + " due to " + re.getException());
            return true;
        }
        return false;
    }
}

