/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.single;

import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.classification.multiclass.reduction.MCTreeNodeReD;
import ai.libs.jaicore.ml.classification.multiclass.reduction.splitters.ISplitter;
import ai.libs.jaicore.ml.classification.multiclass.reduction.splitters.ISplitterFactory;
import ai.libs.jaicore.ml.core.evaluation.measure.IMeasure;
import ai.libs.jaicore.ml.core.evaluation.measure.singlelabel.ZeroOneLoss;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.FixedSplitClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.MonteCarloCrossValidationEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.SimpleSLCSplitBasedClassifierEvaluator;
import ai.libs.reduction.single.ReductionExperiment;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ExperimentRunner<T extends ISplitter> {
    private final int k;
    private final int mccvRepeats;
    private final ISplitterFactory<T> splitterFactory;

    public ExperimentRunner(int k, int mccvRepeats, ISplitterFactory<T> splitterFactory) {
        this.k = k;
        this.mccvRepeats = mccvRepeats;
        this.splitterFactory = splitterFactory;
    }

    public Map<String, Object> conductSingleOneStepReductionExperiment(ReductionExperiment experiment) throws Exception {
        Instances data = new Instances((Reader)new BufferedReader(new FileReader(experiment.getDataset())));
        data.setClassIndex(data.numAttributes() - 1);
        int seed = experiment.getSeed();
        Classifier leftClassifier = AbstractClassifier.forName((String)experiment.getNameOfLeftClassifier(), null);
        Classifier innerClassifier = AbstractClassifier.forName((String)experiment.getNameOfInnerClassifier(), null);
        Classifier rightClassifier = AbstractClassifier.forName((String)experiment.getNameOfRightClassifier(), null);
        List outerSplit = WekaUtil.getStratifiedSplit((Instances)data, (long)experiment.getSeed(), (double[])new double[]{0.7});
        MonteCarloCrossValidationEvaluator mccv = new MonteCarloCrossValidationEvaluator((ISplitBasedClassifierEvaluator)new SimpleSLCSplitBasedClassifierEvaluator((IMeasure)new ZeroOneLoss()), this.mccvRepeats, (Instances)outerSplit.get(0), 0.7, (long)seed);
        ISplitter splitter = this.splitterFactory.getSplitter(seed);
        MCTreeNodeReD bestFoundClassifier = null;
        double bestFoundScore = Double.MAX_VALUE;
        for (int i = 0; i < this.k; ++i) {
            ArrayList classSplit;
            try {
                classSplit = new ArrayList(splitter.split((Instances)outerSplit.get(0)));
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not create a split.", e);
            }
            MCTreeNodeReD classifier = new MCTreeNodeReD(innerClassifier, (Collection)classSplit.get(0), leftClassifier, (Collection)classSplit.get(1), rightClassifier);
            double loss = mccv.evaluate((Classifier)classifier);
            System.out.println("\t\t\tComputed loss " + loss);
            if (!(loss < bestFoundScore)) continue;
            bestFoundScore = loss;
            bestFoundClassifier = classifier;
        }
        double loss = new FixedSplitClassifierEvaluator((Instances)outerSplit.get(0), (Instances)outerSplit.get(1)).evaluate(bestFoundClassifier);
        HashMap<String, Object> result = new HashMap<String, Object>();
        System.out.println("\t\t\tBest previously observed loss was " + bestFoundScore + ". The retrained classifier achieves " + loss + " on the full data.");
        result.put("errorRate", loss);
        return result;
    }
}

