/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.single.heterogeneous.bestofkrandom;

import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.jaicore.ml.classification.multiclass.reduction.splitters.RandomSplitter;
import ai.libs.reduction.single.BestOfKAtRandomExperiment;
import ai.libs.reduction.single.ExperimentRunner;
import ai.libs.reduction.single.MySQLReductionExperiment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class MySQLReductionExperimentRunnerWrapper {
    private static final String TABLE_NAME = "reductionstumps_heterogeneous_random_bestofk";
    private final SQLAdapter adapter;
    private final Collection<MySQLReductionExperiment> knownExperiments = new HashSet<MySQLReductionExperiment>();
    private final int k;
    private final int mccvrepeats;

    public MySQLReductionExperimentRunnerWrapper(String host, String user, String password, String database, int k, int mccvRepeats) {
        this.adapter = new SQLAdapter(host, user, password, database);
        this.k = k;
        this.mccvrepeats = mccvRepeats;
        try {
            this.knownExperiments.addAll(this.getConductedExperiments());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Collection<MySQLReductionExperiment> getConductedExperiments() throws SQLException {
        HashSet<MySQLReductionExperiment> experiments = new HashSet<MySQLReductionExperiment>();
        ResultSet rs = this.adapter.getRowsOfTable(TABLE_NAME);
        while (rs.next()) {
            experiments.add(new MySQLReductionExperiment(rs.getInt("evaluation_id"), new BestOfKAtRandomExperiment(rs.getInt("seed"), rs.getString("dataset"), rs.getString("left_classifier"), rs.getString("inner_classifier"), rs.getString("right_classifier"), rs.getInt("k"), rs.getInt("mccvrepeats"))));
        }
        return experiments;
    }

    public MySQLReductionExperiment createAndGetExperimentIfNotConducted(int seed, File dataFile, String nameOfLeftClassifier, String nameOfInnerClassifier, String nameOfRightClassifier) throws FileNotFoundException, IOException {
        BestOfKAtRandomExperiment exp = new BestOfKAtRandomExperiment(seed, dataFile.getAbsolutePath(), nameOfLeftClassifier, nameOfInnerClassifier, nameOfRightClassifier, this.k, this.mccvrepeats);
        Optional<MySQLReductionExperiment> existingExperiment = this.knownExperiments.stream().filter(e -> e.getExperiment().equals(exp)).findAny();
        if (existingExperiment.isPresent()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seed", seed);
        map.put("dataset", dataFile.getAbsolutePath());
        map.put("left_classifier", nameOfLeftClassifier);
        map.put("inner_classifier", nameOfInnerClassifier);
        map.put("right_classifier", nameOfRightClassifier);
        map.put("k", this.k);
        map.put("mccvrepeats", this.mccvrepeats);
        try {
            int id = this.adapter.insert(TABLE_NAME, map);
            return new MySQLReductionExperiment(id, exp);
        }
        catch (SQLException e2) {
            System.err.println(e2.getMessage());
            return null;
        }
    }

    private void updateExperiment(MySQLReductionExperiment exp, Map<String, ? extends Object> values) throws SQLException {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("evaluation_id", String.valueOf(exp.getId()));
        this.adapter.update(TABLE_NAME, values, where);
    }

    public void conductExperiment(MySQLReductionExperiment exp) throws Exception {
        ExperimentRunner runner = new ExperimentRunner(this.k, this.mccvrepeats, seed -> new RandomSplitter(new Random(seed)));
        Map<String, Object> results = runner.conductSingleOneStepReductionExperiment(exp.getExperiment());
        this.updateExperiment(exp, results);
    }

    public void markExperimentAsUnsolvable(MySQLReductionExperiment exp) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("errorRate", "-1");
        this.updateExperiment(exp, values);
    }

    public void associateExperimentWithException(MySQLReductionExperiment exp, Throwable e) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("errorRate", "-1");
        values.put("exception", e.getClass().getName() + "\n" + e.getMessage());
        this.updateExperiment(exp, values);
    }
}

