/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.reduction.single.heterogeneous.simplerpnd;

import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.reduction.Util;
import ai.libs.reduction.single.MySQLReductionExperiment;
import ai.libs.reduction.single.ReductionExperiment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class MySQLExperimentRunner {
    private static final String TABLE_NAME = "reductionstumps";
    private final SQLAdapter adapter;
    private final Collection<MySQLReductionExperiment> knownExperiments = new HashSet<MySQLReductionExperiment>();

    public MySQLExperimentRunner(String host, String user, String password, String database) {
        this.adapter = new SQLAdapter(host, user, password, database);
        try {
            this.knownExperiments.addAll(this.getConductedExperiments());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Collection<MySQLReductionExperiment> getConductedExperiments() throws SQLException {
        HashSet<MySQLReductionExperiment> experiments = new HashSet<MySQLReductionExperiment>();
        ResultSet rs = this.adapter.getRowsOfTable(TABLE_NAME);
        while (rs.next()) {
            experiments.add(new MySQLReductionExperiment(rs.getInt("evaluation_id"), new ReductionExperiment(rs.getInt("seed"), rs.getString("dataset"), rs.getString("left_classifier"), rs.getString("inner_classifier"), rs.getString("right_classifier"), rs.getString("exception_left"), rs.getString("exception_inner"), rs.getString("exception_right"))));
        }
        return experiments;
    }

    public MySQLReductionExperiment createAndGetExperimentIfNotConducted(int seed, File dataFile, String nameOfLeftClassifier, String nameOfInnerClassifier, String nameOfRightClassifier) throws FileNotFoundException, IOException {
        ReductionExperiment exp = new ReductionExperiment(seed, dataFile.getAbsolutePath(), nameOfLeftClassifier, nameOfInnerClassifier, nameOfRightClassifier);
        Optional<MySQLReductionExperiment> existingExperiment = this.knownExperiments.stream().filter(e -> e.getExperiment().equals(exp)).findAny();
        if (existingExperiment.isPresent()) {
            return null;
        }
        if (this.canInfeasibilityBeDerived(this.knownExperiments, exp)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("seed", String.valueOf(seed));
        map.put("dataset", dataFile.getAbsolutePath());
        map.put("rpnd_classifier", nameOfInnerClassifier);
        map.put("left_classifier", nameOfLeftClassifier);
        map.put("inner_classifier", nameOfInnerClassifier);
        map.put("right_classifier", nameOfRightClassifier);
        try {
            int id = this.adapter.insert(TABLE_NAME, map);
            return new MySQLReductionExperiment(id, exp);
        }
        catch (SQLException e2) {
            System.err.println(e2.getMessage());
            return null;
        }
    }

    private void updateExperiment(MySQLReductionExperiment exp, Map<String, ? extends Object> values) throws SQLException {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("evaluation_id", String.valueOf(exp.getId()));
        this.adapter.update(TABLE_NAME, values, where);
    }

    public void conductExperiment(MySQLReductionExperiment exp) throws Exception {
        List<Map<String, Object>> mccvResults = Util.conductSingleOneStepReductionExperiment(exp.getExperiment());
        DescriptiveStatistics errorRate = new DescriptiveStatistics();
        DescriptiveStatistics runtime = new DescriptiveStatistics();
        for (Map<String, Object> result : mccvResults) {
            errorRate.addValue(((Double)result.get("errorRate")).doubleValue());
            runtime.addValue((double)((Long)result.get("trainTime")).longValue());
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("error_rate_min", errorRate.getMin());
        values.put("error_rate_max", errorRate.getMax());
        values.put("error_rate_mean", errorRate.getMean());
        values.put("error_rate_std", errorRate.getStandardDeviation());
        values.put("runtime_min", runtime.getMin());
        values.put("runtime_max", runtime.getMax());
        values.put("runtime_mean", runtime.getMean());
        values.put("runtime_std", runtime.getStandardDeviation());
        this.updateExperiment(exp, values);
    }

    public void markExperimentAsUnsolvable(MySQLReductionExperiment exp) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : new String[]{"error_rate_min", "error_rate_max", "error_rate_mean", "error_rate_std", "runtime_min", "runtime_max", "runtime_mean", "runtime_std"}) {
            values.put(key, "-1");
        }
        this.updateExperiment(exp, values);
    }

    public void associateExperimentWithException(MySQLReductionExperiment exp, String classifier, Throwable e) throws SQLException {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : new String[]{"error_rate_min", "error_rate_max", "error_rate_mean", "error_rate_std", "runtime_min", "runtime_max", "runtime_mean", "runtime_std"}) {
            values.put(key, "-1");
        }
        values.put("exception_" + classifier, e.getClass().getName() + "\n" + e.getMessage());
        this.updateExperiment(exp, values);
    }

    private boolean canInfeasibilityBeDerived(Collection<MySQLReductionExperiment> experimentsWithResults, ReductionExperiment experimentInQuestion) {
        return false;
    }
}

