/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    UnsupervisedSubsetEvaluator.java
 *    Copyright (C) 1999-2012 University of Waikato, Hamilton, New Zealand
 *
 */

package weka.attributeSelection;

import weka.clusterers.Clusterer;

/** 
 * Abstract unsupervised attribute subset evaluator.
 *
 * @author Mark Hall (mhall@cs.waikato.ac.nz)
 * @version $Revision$
 */
public abstract class UnsupervisedSubsetEvaluator 
  extends ASEvaluation
  implements SubsetEvaluator {

  /** for serialization */
  static final long serialVersionUID = 627934376267488763L;
  
  /**
   * Return the number of clusters used by the subset evaluator
   *
   * @return the number of clusters used
   * @exception Exception if an error occurs
   */
  public abstract int getNumClusters() throws Exception;

  /**
   * Get the clusterer
   *
   * @return the clusterer
   */
  public abstract Clusterer getClusterer();

  /**
   * Set the clusterer to use
   *
   * @param d the clusterer to use
   */
  public abstract void setClusterer(Clusterer d);
}
