/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class ParallelMultipleClassifiersCombiner
extends MultipleClassifiersCombiner {
    private static final long serialVersionUID = 728109028953726626L;
    protected int m_numExecutionSlots = 1;
    protected transient ThreadPoolExecutor m_executorPool;
    protected int m_completed;
    protected int m_failed;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String iterations = Utils.getOption("num-slots", options);
        if (iterations.length() != 0) {
            this.setNumExecutionSlots(Integer.parseInt(iterations));
        } else {
            this.setNumExecutionSlots(1);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-num-slots");
        options.add("" + this.getNumExecutionSlots());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public void setNumExecutionSlots(int numSlots) {
        this.m_numExecutionSlots = numSlots;
    }

    public int getNumExecutionSlots() {
        return this.m_numExecutionSlots;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for constructing the ensemble.";
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_numExecutionSlots < 1) {
            throw new Exception("Number of execution slots needs to be >= 1!");
        }
        if (this.m_numExecutionSlots > 1) {
            if (this.m_Debug) {
                System.out.println("Starting executor pool with " + this.m_numExecutionSlots + " slots...");
            }
            this.startExecutorPool();
        }
        this.m_completed = 0;
        this.m_failed = 0;
    }

    protected void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = new ThreadPoolExecutor(this.m_numExecutionSlots, this.m_numExecutionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_numExecutionSlots > 1 && this.m_completed + this.m_failed < this.m_Classifiers.length) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    protected synchronized void buildClassifiers(final Instances data) throws Exception {
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            if (this.m_numExecutionSlots > 1) {
                final Classifier currentClassifier = this.m_Classifiers[i];
                final int iteration = i;
                Runnable newTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ParallelMultipleClassifiersCombiner.this.m_Debug) {
                                System.out.println("Training classifier (" + (iteration + 1) + ")");
                            }
                            currentClassifier.buildClassifier(data);
                            if (ParallelMultipleClassifiersCombiner.this.m_Debug) {
                                System.out.println("Finished classifier (" + (iteration + 1) + ")");
                            }
                            ParallelMultipleClassifiersCombiner.this.completedClassifier(iteration, true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            ParallelMultipleClassifiersCombiner.this.completedClassifier(iteration, false);
                        }
                    }
                };
                this.m_executorPool.execute(newTask);
                continue;
            }
            this.m_Classifiers[i].buildClassifier(data);
        }
        if (this.m_numExecutionSlots > 1 && this.m_completed + this.m_failed < this.m_Classifiers.length) {
            this.block(true);
        }
    }

    protected synchronized void completedClassifier(int iteration, boolean success) {
        if (!success) {
            ++this.m_failed;
            if (this.m_Debug) {
                System.err.println("Iteration " + iteration + " failed!");
            }
        } else {
            ++this.m_completed;
        }
        if (this.m_completed + this.m_failed == this.m_Classifiers.length) {
            if (this.m_failed > 0 && this.m_Debug) {
                System.err.println("Problem building classifiers - some iterations failed.");
            }
            this.m_executorPool.shutdown();
            this.block(false);
        }
    }
}

