/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import weka.classifiers.bayes.net.ADNode;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class VaryNode
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -6196294370675872424L;
    public int m_iNode;
    public int m_nMCV;
    public ADNode[] m_ADNodes;

    public VaryNode(int iNode) {
        this.m_iNode = iNode;
    }

    public void getCounts(int[] nCounts, int[] nNodes, int[] nOffsets, int iNode, int iOffset, ADNode parent, boolean bSubstract) throws InterruptedException {
        for (int iValue = 0; iValue < this.m_ADNodes.length; ++iValue) {
            if (iValue != this.m_nMCV) {
                if (this.m_ADNodes[iValue] == null) continue;
                this.m_ADNodes[iValue].getCounts(nCounts, nNodes, nOffsets, iNode + 1, iOffset + nOffsets[iNode] * iValue, bSubstract);
                continue;
            }
            parent.getCounts(nCounts, nNodes, nOffsets, iNode + 1, iOffset + nOffsets[iNode] * iValue, bSubstract);
            for (int iValue2 = 0; iValue2 < this.m_ADNodes.length; ++iValue2) {
                if (iValue2 == this.m_nMCV || this.m_ADNodes[iValue2] == null) continue;
                this.m_ADNodes[iValue2].getCounts(nCounts, nNodes, nOffsets, iNode + 1, iOffset + nOffsets[iNode] * iValue, !bSubstract);
            }
        }
    }

    public void print(String sTab) {
        for (int iValue = 0; iValue < this.m_ADNodes.length; ++iValue) {
            System.out.print(sTab + iValue + ": ");
            if (this.m_ADNodes[iValue] == null) {
                if (iValue == this.m_nMCV) {
                    System.out.println("MCV");
                    continue;
                }
                System.out.println("null");
                continue;
            }
            System.out.println();
            this.m_ADNodes[iValue].print();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

