/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;

public class SimpleEstimator
extends BayesNetEstimator {
    static final long serialVersionUID = 5874941612331806172L;

    @Override
    public String globalInfo() {
        return "SimpleEstimator is used for estimating the conditional probability tables of a Bayes network once the structure has been learned. Estimates probabilities directly from data.";
    }

    @Override
    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        this.initCPTs(bayesNet);
        Enumeration<Instance> enumInsts = bayesNet.m_Instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            Instance instance = enumInsts.nextElement();
            this.updateClassifier(bayesNet, instance);
        }
    }

    @Override
    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        for (int iAttribute = 0; iAttribute < bayesNet.m_Instances.numAttributes(); ++iAttribute) {
            double iCPT = 0.0;
            for (int iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getNrOfParents(); ++iParent) {
                int nParent = bayesNet.getParentSet(iAttribute).getParent(iParent);
                iCPT = iCPT * (double)bayesNet.m_Instances.attribute(nParent).numValues() + instance.value(nParent);
            }
            bayesNet.m_Distributions[iAttribute][(int)iCPT].addValue(instance.value(iAttribute), instance.weight());
        }
    }

    @Override
    public void initCPTs(BayesNet bayesNet) throws Exception {
        int iAttribute;
        Instances instances = bayesNet.m_Instances;
        int nMaxParentCardinality = 1;
        for (iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            if (bayesNet.getParentSet(iAttribute).getCardinalityOfParents() <= nMaxParentCardinality) continue;
            nMaxParentCardinality = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
        }
        bayesNet.m_Distributions = new Estimator[instances.numAttributes()][nMaxParentCardinality];
        for (iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            for (int iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents(); ++iParent) {
                bayesNet.m_Distributions[iAttribute][iParent] = new DiscreteEstimatorBayes(instances.attribute(iAttribute).numValues(), this.m_fAlpha);
            }
        }
    }

    @Override
    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        int iClass;
        Instances instances = bayesNet.m_Instances;
        int nNumClasses = instances.numClasses();
        double[] fProbs = new double[nNumClasses];
        int iClass2 = 0;
        while (iClass2 < nNumClasses) {
            double logfP = 0.0;
            for (int iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
                double iCPT = 0.0;
                for (int iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getNrOfParents(); ++iParent) {
                    int nParent = bayesNet.getParentSet(iAttribute).getParent(iParent);
                    iCPT = nParent == instances.classIndex() ? iCPT * (double)nNumClasses + (double)iClass2 : iCPT * (double)instances.attribute(nParent).numValues() + instance.value(nParent);
                }
                if (iAttribute == instances.classIndex()) {
                    logfP += Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(iClass2));
                    continue;
                }
                logfP += Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(instance.value(iAttribute)));
            }
            int n = iClass2++;
            fProbs[n] = fProbs[n] + logfP;
        }
        double fMax = fProbs[0];
        for (iClass = 0; iClass < nNumClasses; ++iClass) {
            if (!(fProbs[iClass] > fMax)) continue;
            fMax = fProbs[iClass];
        }
        for (iClass = 0; iClass < nNumClasses; ++iClass) {
            fProbs[iClass] = Math.exp(fProbs[iClass] - fMax);
        }
        try {
            Utils.normalize(fProbs);
        }
        catch (IllegalArgumentException ex) {
            return new double[nNumClasses];
        }
        return fProbs;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

