/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class K2
extends GlobalScoreSearchAlgorithm
implements TechnicalInformationHandler {
    static final long serialVersionUID = -6626871067466338256L;
    boolean m_bRandomOrder = false;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "G.F. Cooper and E. Herskovits");
        result.setValue(TechnicalInformation.Field.YEAR, "1990");
        result.setValue(TechnicalInformation.Field.TITLE, "A Bayesian method for constructing Bayesian belief networks from databases");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Conference on Uncertainty in AI");
        result.setValue(TechnicalInformation.Field.PAGES, "86-94");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "G. Cooper and E. Herskovits");
        additional.setValue(TechnicalInformation.Field.YEAR, "1992");
        additional.setValue(TechnicalInformation.Field.TITLE, "A Bayesian method for the induction of probabilistic networks from data");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        additional.setValue(TechnicalInformation.Field.VOLUME, "9");
        additional.setValue(TechnicalInformation.Field.NUMBER, "4");
        additional.setValue(TechnicalInformation.Field.PAGES, "309-347");
        return result;
    }

    @Override
    public void search(BayesNet bayesNet, Instances instances) throws Exception {
        int iOrder;
        int[] nOrder = new int[instances.numAttributes()];
        nOrder[0] = instances.classIndex();
        int nAttribute = 0;
        for (int iOrder2 = 1; iOrder2 < instances.numAttributes(); ++iOrder2) {
            if (nAttribute == instances.classIndex()) {
                // empty if block
            }
            int n = ++nAttribute;
            ++nAttribute;
            nOrder[iOrder2] = n;
        }
        if (this.m_bRandomOrder) {
            Random random = new Random();
            int iClass = this.getInitAsNaiveBayes() ? 0 : -1;
            for (iOrder = 0; iOrder < instances.numAttributes(); ++iOrder) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Killed WEKA!");
                }
                int iOrder2 = random.nextInt(instances.numAttributes());
                if (iOrder == iClass || iOrder2 == iClass) continue;
                int nTmp = nOrder[iOrder];
                nOrder[iOrder] = nOrder[iOrder2];
                nOrder[iOrder2] = nTmp;
            }
        }
        double fBaseScore = this.calcScore(bayesNet);
        for (iOrder = 1; iOrder < instances.numAttributes(); ++iOrder) {
            boolean bProgress;
            if (Thread.interrupted()) {
                throw new InterruptedException("Killed WEKA!");
            }
            int iAttribute = nOrder[iOrder];
            double fBestScore = fBaseScore;
            boolean bl = bProgress = bayesNet.getParentSet(iAttribute).getNrOfParents() < this.getMaxNrOfParents();
            while (bProgress && bayesNet.getParentSet(iAttribute).getNrOfParents() < this.getMaxNrOfParents()) {
                int nBestAttribute = -1;
                for (int iOrder2 = 0; iOrder2 < iOrder; ++iOrder2) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException("Killed WEKA!");
                    }
                    int iAttribute2 = nOrder[iOrder2];
                    double fScore = this.calcScoreWithExtraParent(iAttribute, iAttribute2);
                    if (!(fScore > fBestScore)) continue;
                    fBestScore = fScore;
                    nBestAttribute = iAttribute2;
                }
                if (nBestAttribute != -1) {
                    bayesNet.getParentSet(iAttribute).addParent(nBestAttribute, instances);
                    fBaseScore = fBestScore;
                    bProgress = true;
                    continue;
                }
                bProgress = false;
            }
        }
    }

    public void setMaxNrOfParents(int nMaxNrOfParents) {
        this.m_nMaxNrOfParents = nMaxNrOfParents;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    public void setInitAsNaiveBayes(boolean bInitAsNaiveBayes) {
        this.m_bInitAsNaiveBayes = bInitAsNaiveBayes;
    }

    public boolean getInitAsNaiveBayes() {
        return this.m_bInitAsNaiveBayes;
    }

    public void setRandomOrder(boolean bRandomOrder) {
        this.m_bRandomOrder = bRandomOrder;
    }

    public boolean getRandomOrder() {
        return this.m_bRandomOrder;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(0);
        newVector.addElement(new Option("\tInitial structure is empty (instead of Naive Bayes)", "N", 0, "-N"));
        newVector.addElement(new Option("\tMaximum number of parents", "P", 1, "-P <nr of parents>"));
        newVector.addElement(new Option("\tRandom order.\n\t(default false)", "R", 0, "-R"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setRandomOrder(Utils.getFlag('R', options));
        this.m_bInitAsNaiveBayes = !Utils.getFlag('N', options);
        String sMaxNrOfParents = Utils.getOption('P', options);
        if (sMaxNrOfParents.length() != 0) {
            this.setMaxNrOfParents(Integer.parseInt(sMaxNrOfParents));
        } else {
            this.setMaxNrOfParents(100000);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-P");
        options.add("" + this.m_nMaxNrOfParents);
        if (!this.m_bInitAsNaiveBayes) {
            options.add("-N");
        }
        if (this.getRandomOrder()) {
            options.add("-R");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String randomOrderTipText() {
        return "When set to true, the order of the nodes in the network is random. Default random order is false and the order of the nodes in the dataset is used. In any case, when the network was initialized as Naive Bayes Network, the class variable is first in the ordering though.";
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a hill climbing algorithm restricted by an order on the variables.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\nWorks with nominal variables and no missing values only.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

