/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.global.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RepeatedHillClimber
extends HillClimber {
    static final long serialVersionUID = -7359197180460703069L;
    int m_nRuns = 10;
    int m_nSeed = 1;
    Random m_random;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        double fCurrentScore;
        this.m_random = new Random(this.getSeed());
        double fBestScore = fCurrentScore = this.calcScore(bayesNet);
        BayesNet bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        for (int iRun = 0; iRun < this.m_nRuns; ++iRun) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Killed WEKA!");
            }
            this.generateRandomNet(bayesNet, instances);
            super.search(bayesNet, instances);
            fCurrentScore = this.calcScore(bayesNet);
            if (!(fCurrentScore > fBestScore)) continue;
            fBestScore = fCurrentScore;
            this.copyParentSets(bestBayesNet, bayesNet);
        }
        this.copyParentSets(bayesNet, bestBayesNet);
        bestBayesNet = null;
    }

    void generateRandomNet(BayesNet bayesNet, Instances instances) throws InterruptedException {
        int nNodes = instances.numAttributes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            while (parentSet.getNrOfParents() > 0) {
                parentSet.deleteLastParent(instances);
            }
        }
        if (this.getInitAsNaiveBayes()) {
            int iClass = instances.classIndex();
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                if (iNode == iClass) continue;
                bayesNet.getParentSet(iNode).addParent(iClass, instances);
            }
        }
        int nNrOfAttempts = this.m_random.nextInt(nNodes * nNodes);
        for (int iAttempt = 0; iAttempt < nNrOfAttempts; ++iAttempt) {
            int iTail = this.m_random.nextInt(nNodes);
            int iHead = this.m_random.nextInt(nNodes);
            if (bayesNet.getParentSet(iHead).getNrOfParents() >= this.getMaxNrOfParents() || !this.addArcMakesSense(bayesNet, instances, iHead, iTail)) continue;
            bayesNet.getParentSet(iHead).addParent(iTail, instances);
        }
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tRandom number seed", "A", 1, "-A <seed>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sSeed;
        String sRuns = Utils.getOption('U', options);
        if (sRuns.length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        if ((sSeed = Utils.getOption('A', options)).length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-U");
        options.add("" + this.getRuns());
        options.add("-A");
        options.add("" + this.getSeed());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm repeatedly uses hill climbing starting with a randomly generated network structure and return the best structure of the various runs.";
    }

    public String runsTipText() {
        return "Sets the number of times hill climbing is performed.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

