/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.ConditionalDensityEstimator;
import weka.classifiers.CostMatrix;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.Sourcable;
import weka.classifiers.UpdateableBatchProcessor;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.evaluation.AbstractEvaluationMetric;
import weka.classifiers.evaluation.InformationRetrievalEvaluationMetric;
import weka.classifiers.evaluation.InformationTheoreticEvaluationMetric;
import weka.classifiers.evaluation.IntervalBasedEvaluationMetric;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.evaluation.StandardEvaluationMetric;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.classifiers.evaluation.output.prediction.PlainText;
import weka.classifiers.misc.InputMappedClassifier;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.classifiers.xml.XMLClassifier;
import weka.core.BatchPredictor;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.core.Version;
import weka.core.WekaException;
import weka.core.converters.ConverterUtils;
import weka.core.pmml.PMMLFactory;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.estimators.UnivariateKernelEstimator;
import weka.experiment.Stats;

public class Evaluation
implements Summarizable,
RevisionHandler,
Serializable {
    private static final long serialVersionUID = -7010314486866816271L;
    protected int m_NumClasses;
    protected int m_NumFolds;
    protected double m_Incorrect;
    protected double m_Correct;
    protected double m_Unclassified;
    protected double m_MissingClass;
    protected double m_WithClass;
    protected double[][] m_ConfusionMatrix;
    protected String[] m_ClassNames;
    protected boolean m_ClassIsNominal;
    protected double[] m_ClassPriors;
    protected double m_ClassPriorsSum;
    protected CostMatrix m_CostMatrix;
    protected double m_TotalCost;
    protected double m_SumErr;
    protected double m_SumAbsErr;
    protected double m_SumSqrErr;
    protected double m_SumClass;
    protected double m_SumSqrClass;
    protected double m_SumPredicted;
    protected double m_SumSqrPredicted;
    protected double m_SumClassPredicted;
    protected double m_SumPriorAbsErr;
    protected double m_SumPriorSqrErr;
    protected double m_SumKBInfo;
    protected static int k_MarginResolution = 500;
    protected double[] m_MarginCounts;
    protected int m_NumTrainClassVals;
    protected double[] m_TrainClassVals;
    protected double[] m_TrainClassWeights;
    protected UnivariateKernelEstimator m_PriorEstimator;
    protected boolean m_ComplexityStatisticsAvailable = true;
    protected static final double MIN_SF_PROB = Double.MIN_VALUE;
    protected double m_SumPriorEntropy;
    protected double m_SumSchemeEntropy;
    protected boolean m_CoverageStatisticsAvailable = true;
    protected double m_ConfLevel = 0.95;
    protected double m_TotalSizeOfRegions;
    protected double m_TotalCoverage;
    protected double m_MinTarget;
    protected double m_MaxTarget;
    protected ArrayList<Prediction> m_Predictions;
    protected boolean m_NoPriors = false;
    protected Instances m_Header;
    protected boolean m_DiscardPredictions;
    protected List<AbstractEvaluationMetric> m_pluginMetrics;
    protected List<String> m_metricsToDisplay = new ArrayList<String>();
    public static final String[] BUILT_IN_EVAL_METRICS = new String[]{"Correct", "Incorrect", "Kappa", "Total cost", "Average cost", "KB relative", "KB information", "Correlation", "Complexity 0", "Complexity scheme", "Complexity improvement", "MAE", "RMSE", "RAE", "RRSE", "Coverage", "Region size", "TP rate", "FP rate", "Precision", "Recall", "F-measure", "MCC", "ROC area", "PRC area"};

    public static List<String> getAllEvaluationMetricNames() {
        ArrayList<String> allEvals = new ArrayList<String>();
        for (String s : BUILT_IN_EVAL_METRICS) {
            allEvals.add(s);
        }
        ArrayList<AbstractEvaluationMetric> pluginMetrics = AbstractEvaluationMetric.getPluginMetrics();
        if (pluginMetrics != null) {
            for (AbstractEvaluationMetric m : pluginMetrics) {
                if (m instanceof InformationRetrievalEvaluationMetric) {
                    List<String> statNames = m.getStatisticNames();
                    for (String s : statNames) {
                        allEvals.add(s);
                    }
                    continue;
                }
                allEvals.add(m.getMetricName());
            }
        }
        return allEvals;
    }

    public Evaluation(Instances data) throws Exception {
        this(data, null);
    }

    public Evaluation(Instances data, CostMatrix costMatrix) throws Exception {
        this.m_Header = new Instances(data, 0);
        this.m_NumClasses = data.numClasses();
        this.m_NumFolds = 1;
        this.m_ClassIsNominal = data.classAttribute().isNominal();
        if (this.m_ClassIsNominal) {
            this.m_ConfusionMatrix = new double[this.m_NumClasses][this.m_NumClasses];
            this.m_ClassNames = new String[this.m_NumClasses];
            for (int i = 0; i < this.m_NumClasses; ++i) {
                this.m_ClassNames[i] = data.classAttribute().value(i);
            }
        }
        this.m_CostMatrix = costMatrix;
        if (this.m_CostMatrix != null) {
            if (!this.m_ClassIsNominal) {
                throw new Exception("Class has to be nominal if cost matrix given!");
            }
            if (this.m_CostMatrix.size() != this.m_NumClasses) {
                throw new Exception("Cost matrix not compatible with data!");
            }
        }
        this.m_ClassPriors = new double[this.m_NumClasses];
        this.setPriors(data);
        this.m_MarginCounts = new double[k_MarginResolution + 1];
        for (String s : BUILT_IN_EVAL_METRICS) {
            if (s.equalsIgnoreCase("Coverage") || s.equalsIgnoreCase("Region size")) continue;
            this.m_metricsToDisplay.add(s.toLowerCase());
        }
        this.m_pluginMetrics = AbstractEvaluationMetric.getPluginMetrics();
        if (this.m_pluginMetrics != null) {
            for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                m.setBaseEvaluation(this);
                if (m instanceof InformationRetrievalEvaluationMetric) {
                    List<String> statNames = m.getStatisticNames();
                    for (String s : statNames) {
                        this.m_metricsToDisplay.add(s.toLowerCase());
                    }
                    continue;
                }
                this.m_metricsToDisplay.add(m.getMetricName().toLowerCase());
            }
        }
    }

    public Instances getHeader() {
        return this.m_Header;
    }

    public void setDiscardPredictions(boolean value) {
        this.m_DiscardPredictions = value;
        if (this.m_DiscardPredictions) {
            this.m_Predictions = null;
        }
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public List<AbstractEvaluationMetric> getPluginMetrics() {
        return this.m_pluginMetrics;
    }

    public void setMetricsToDisplay(List<String> display) {
        this.m_metricsToDisplay.clear();
        for (String s : display) {
            this.m_metricsToDisplay.add(s.trim().toLowerCase());
        }
    }

    public List<String> getMetricsToDisplay() {
        return this.m_metricsToDisplay;
    }

    public void toggleEvalMetrics(List<String> metricsToToggle) {
        for (String s : metricsToToggle) {
            if (this.m_metricsToDisplay.contains(s.toLowerCase())) {
                this.m_metricsToDisplay.remove(s.toLowerCase());
                continue;
            }
            this.m_metricsToDisplay.add(s.toLowerCase());
        }
    }

    public AbstractEvaluationMetric getPluginMetric(String name) {
        AbstractEvaluationMetric match = null;
        if (this.m_pluginMetrics != null) {
            for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                if (!m.getMetricName().equals(name) && !m.getClass().getName().equals(name)) continue;
                match = m;
                break;
            }
        }
        return match;
    }

    public double areaUnderROC(int classIndex) {
        if (this.m_Predictions == null) {
            return Utils.missingValue();
        }
        ThresholdCurve tc = new ThresholdCurve();
        Instances result = tc.getCurve(this.m_Predictions, classIndex);
        return ThresholdCurve.getROCArea(result);
    }

    public double weightedAreaUnderROC() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double aucTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.areaUnderROC(i);
            if (!(classCounts[i] > 0.0)) continue;
            aucTotal += temp * classCounts[i];
        }
        return aucTotal / classCountSum;
    }

    public double areaUnderPRC(int classIndex) {
        if (this.m_Predictions == null) {
            return Utils.missingValue();
        }
        ThresholdCurve tc = new ThresholdCurve();
        Instances result = tc.getCurve(this.m_Predictions, classIndex);
        return ThresholdCurve.getPRCArea(result);
    }

    public double weightedAreaUnderPRC() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double auprcTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.areaUnderPRC(i);
            if (!(classCounts[i] > 0.0)) continue;
            auprcTotal += temp * classCounts[i];
        }
        return auprcTotal / classCountSum;
    }

    public double[][] confusionMatrix() {
        double[][] newMatrix = new double[this.m_ConfusionMatrix.length][0];
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            newMatrix[i] = new double[this.m_ConfusionMatrix[i].length];
            System.arraycopy(this.m_ConfusionMatrix[i], 0, newMatrix[i], 0, this.m_ConfusionMatrix[i].length);
        }
        return newMatrix;
    }

    public void crossValidateModel(Classifier classifier, Instances data, int numFolds, Random random) throws Exception {
        this.crossValidateModel(classifier, data, numFolds, random, new Object[0]);
    }

    public void crossValidateModel(Classifier classifier, Instances data, int numFolds, Random random, Object ... forPrinting) throws Exception {
        data = new Instances(data);
        data.randomize(random);
        if (data.classAttribute().isNominal()) {
            data.stratify(numFolds);
        }
        AbstractOutput classificationOutput = null;
        if (forPrinting.length > 0 && forPrinting[0] instanceof AbstractOutput) {
            classificationOutput = (AbstractOutput)forPrinting[0];
            classificationOutput.setHeader(data);
            classificationOutput.printHeader();
        }
        for (int i = 0; i < numFolds; ++i) {
            Instances train = data.trainCV(numFolds, i, random);
            this.setPriors(train);
            Classifier copiedClassifier = AbstractClassifier.makeCopy(classifier);
            copiedClassifier.buildClassifier(train);
            if (classificationOutput == null && forPrinting.length > 0) {
                ((StringBuffer)forPrinting[0]).append("\n=== Classifier model (training fold " + (i + 1) + ") ===\n\n" + copiedClassifier);
            }
            Instances test = data.testCV(numFolds, i);
            if (classificationOutput != null) {
                this.evaluateModel(copiedClassifier, test, forPrinting);
                continue;
            }
            this.evaluateModel(copiedClassifier, test, new Object[0]);
        }
        this.m_NumFolds = numFolds;
        if (classificationOutput != null) {
            classificationOutput.printFooter();
        }
    }

    public void crossValidateModel(String classifierString, Instances data, int numFolds, String[] options, Random random) throws Exception {
        this.crossValidateModel(AbstractClassifier.forName(classifierString, options), data, numFolds, random);
    }

    public static String evaluateModel(String classifierString, String[] options) throws Exception {
        Classifier classifier;
        try {
            classifier = AbstractClassifier.forName(classifierString, null);
        }
        catch (Exception e) {
            throw new Exception("Can't find class with name " + classifierString + '.');
        }
        return Evaluation.evaluateModel(classifier, options);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("The first argument must be the class name of a classifier");
            }
            String classifier = args[0];
            args[0] = "";
            System.out.println(Evaluation.evaluateModel(classifier, args));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected static Classifier getModelFromFile(String modelFileName, Instances template) throws Exception {
        classifier /* !! */  = null;
        if (modelFileName.endsWith(".xml")) {
            try {
                pmmlModel = PMMLFactory.getPMMLModel(modelFileName);
                if (!(pmmlModel instanceof PMMLClassifier)) ** GOTO lbl32
                classifier /* !! */  = (PMMLClassifier)pmmlModel;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to read model XML file " + modelFileName);
            }
        } else {
            is /* !! */  = new FileInputStream(modelFileName);
            if (modelFileName.endsWith(".gz")) {
                is /* !! */  = new GZIPInputStream(is /* !! */ );
            }
            if (!modelFileName.endsWith(".koml")) {
                objectInputStream = SerializationHelper.getObjectInputStream(is /* !! */ );
                classifier /* !! */  = (Classifier)objectInputStream.readObject();
                savedStructure = null;
                try {
                    savedStructure = (Instances)objectInputStream.readObject();
                }
                catch (Exception var6_9) {
                    // empty catch block
                }
                if (savedStructure != null && !(classifier /* !! */  instanceof InputMappedClassifier) && !template.equalHeaders(savedStructure)) {
                    throw new Exception("training and test set are not compatible\n" + template.equalHeadersMsg(savedStructure));
                }
                objectInputStream.close();
            } else if (KOML.isPresent()) {
                xmlInputStream = new BufferedInputStream(is /* !! */ );
                classifier /* !! */  = (Classifier)KOML.read(xmlInputStream);
                xmlInputStream.close();
            } else {
                throw new WekaException("KOML library is not present");
            }
        }
lbl32:
        // 4 sources

        if (classifier /* !! */  == null) {
            throw new IllegalArgumentException("Failed to classifier from model file " + modelFileName);
        }
        return classifier /* !! */ ;
    }

    protected static void saveClassifier(Classifier classifier, Instances template, String objectOutputFileName) throws Exception {
        OutputStream os = new FileOutputStream(objectOutputFileName);
        if (!(objectOutputFileName.endsWith(".xml") || objectOutputFileName.endsWith(".koml") && KOML.isPresent())) {
            if (objectOutputFileName.endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
            objectOutputStream.writeObject(classifier);
            if (template != null) {
                objectOutputStream.writeObject(template);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
        } else {
            BufferedOutputStream xmlOutputStream = new BufferedOutputStream(os);
            if (objectOutputFileName.endsWith(".xml")) {
                XMLClassifier xmlSerial = new XMLClassifier();
                xmlSerial.write(xmlOutputStream, (Object)classifier);
            } else if (objectOutputFileName.endsWith(".koml")) {
                KOML.write(xmlOutputStream, (Object)classifier);
            }
            xmlOutputStream.close();
        }
    }

    public static String evaluateModel(Classifier classifier, String[] options) throws Exception {
        Random random;
        Instances tmpInst;
        StringBuffer schemeOptionsText = null;
        long trainTimeStart = 0L;
        long trainTimeElapsed = 0L;
        long testTimeStart = 0L;
        long testTimeElapsed = 0L;
        if (Utils.getFlag("h", options) || Utils.getFlag("help", options)) {
            boolean globalInfo = Utils.getFlag("synopsis", options) || Utils.getFlag("info", options);
            throw new Exception("\nHelp requested." + Evaluation.makeOptionString((Classifier)classifier, globalInfo));
        }
        try {
            String xml = Utils.getOption("xml", options);
            if (!xml.equals("")) {
                options = new XMLOptions(xml).toArray();
            }
        }
        catch (Exception ex) {
            throw new Exception("\nWeka exception: " + ex.getMessage() + Evaluation.makeOptionString((Classifier)classifier, false));
        }
        boolean noCrossValidation = Utils.getFlag("no-cv", options);
        String classIndexString = Utils.getOption('c', options);
        String trainFileName = Utils.getOption('t', options);
        String objectInputFileName = Utils.getOption('l', options);
        String objectOutputFileName = Utils.getOption('d', options);
        String testFileName = Utils.getOption('T', options);
        String foldsString = Utils.getOption('x', options);
        String seedString = Utils.getOption('s', options);
        boolean outputModelsForTrainingSplits = Utils.getFlag("output-models-for-training-splits", options);
        boolean classStatistics = !Utils.getFlag("do-not-output-per-class-statistics", options);
        boolean noOutput = Utils.getFlag('o', options);
        boolean trainStatistics = !Utils.getFlag('v', options);
        boolean printComplexityStatistics = Utils.getFlag('k', options);
        boolean printMargins = Utils.getFlag('r', options);
        boolean printGraph = Utils.getFlag('g', options);
        String sourceClass = Utils.getOption('z', options);
        boolean printSource = sourceClass.length() != 0;
        String thresholdFile = Utils.getOption("threshold-file", options);
        String thresholdLabel = Utils.getOption("threshold-label", options);
        boolean forceBatchTraining = Utils.getFlag("force-batch-training", options);
        String classifications = Utils.getOption("classifications", options);
        String classificationsOld = Utils.getOption("p", options);
        String splitPercentageString = Utils.getOption("split-percentage", options);
        boolean preserveOrder = Utils.getFlag("preserve-order", options);
        boolean discardPredictions = Utils.getFlag("no-predictions", options);
        String metricsToToggle = Utils.getOption("toggle", options);
        CostMatrix costMatrix = null;
        double splitPercentage = -1.0;
        int classIndex = -1;
        int actualClassIndex = -1;
        int seed = 1;
        int folds = 10;
        Instances train = null;
        Instances test = null;
        Instances template = null;
        AbstractOutput classificationOutput = null;
        ArrayList<String> toggleList = new ArrayList<String>();
        int labelIndex = 0;
        try {
            if (metricsToToggle.length() > 0) {
                String[] parts;
                String[] stringArray = parts = metricsToToggle.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String p = stringArray[i];
                    toggleList.add(p.trim().toLowerCase());
                }
            }
            if (objectInputFileName.length() != 0 && objectInputFileName.endsWith(".xml")) {
                try {
                    OptionHandler cl = (OptionHandler)new XMLClassifier().read(objectInputFileName);
                    options = (String[])Stream.concat(Arrays.stream(cl.getOptions()), Arrays.stream(options)).toArray(String[]::new);
                    objectInputFileName = "";
                }
                catch (Exception cl) {
                    // empty catch block
                }
            }
            if (trainFileName.length() == 0) {
                if (objectInputFileName.length() == 0) {
                    throw new IllegalArgumentException("No training file and no object input file given.");
                }
                if (testFileName.length() == 0) {
                    throw new IllegalArgumentException("No training file and no test file given.");
                }
            } else if (objectInputFileName.length() != 0 && (!(classifier instanceof UpdateableClassifier) || forceBatchTraining || testFileName.length() == 0)) {
                throw new IllegalArgumentException("Classifier not incremental or batch training forced, or no test file provided: can't use model file.");
            }
            if (objectInputFileName.length() != 0 && (splitPercentageString.length() != 0 || foldsString.length() != 0)) {
                throw new IllegalArgumentException("Cannot perform percentage split or cross-validation when model provided.");
            }
            if (splitPercentageString.length() != 0) {
                if (foldsString.length() != 0) {
                    throw new IllegalArgumentException("Percentage split cannot be used in conjunction with cross-validation ('-x').");
                }
                splitPercentage = Double.parseDouble(splitPercentageString);
                if (splitPercentage <= 0.0 || splitPercentage >= 100.0) {
                    throw new IllegalArgumentException("Split percentage needs to be >0 and <100.");
                }
            }
            if (preserveOrder && splitPercentage == -1.0) {
                throw new IllegalArgumentException("Split percentage is missing.");
            }
            if (discardPredictions && (classifications.length() > 0 || classificationsOld.length() > 0)) {
                throw new IllegalArgumentException("Cannot both discard and output predictions!");
            }
            if (thresholdFile.length() > 0 && (classifications.length() > 0 || classificationsOld.length() > 0)) {
                throw new IllegalArgumentException("Cannot output predictions and also write threshold file!");
            }
            if (thresholdFile.length() > 0 && !trainStatistics && noCrossValidation && splitPercentageString.length() <= 0 && testFileName.length() <= 0) {
                throw new IllegalArgumentException("Can only write a threshold file when performance statistics are computed!");
            }
            if (printMargins && !trainStatistics && noCrossValidation && splitPercentageString.length() <= 0 && testFileName.length() <= 0) {
                throw new IllegalArgumentException("Can only print margins when performance statistics are computed!");
            }
            if (trainFileName.length() == 0 && printComplexityStatistics) {
                throw new IllegalArgumentException("Cannot print complexity statistics without training file!");
            }
            if (printGraph && !(classifier instanceof Drawable)) {
                throw new IllegalArgumentException("Can only print graph if classifier implements Drawable interface!");
            }
            if (printSource && !(classifier instanceof Sourcable)) {
                throw new IllegalArgumentException("Can only print source if classifier implements Sourcable interface!");
            }
            if (printGraph && trainFileName.length() <= 0 && objectInputFileName.length() <= 0) {
                throw new IllegalArgumentException("Can only print graph if training file or model file is provided!");
            }
            if (printSource && trainFileName.length() <= 0 && objectInputFileName.length() <= 0) {
                throw new IllegalArgumentException("Can only print source if training file or model file is provided!");
            }
            if (objectInputFileName.length() > 0 && trainFileName.length() > 0 && (!(classifier instanceof UpdateableClassifier) || forceBatchTraining)) {
                throw new IllegalArgumentException("Can't use batch training when updating an existing classifier!");
            }
            if (noCrossValidation && testFileName.length() != 0) {
                throw new IllegalArgumentException("Attempt to turn off cross-validation when explicit test file is provided!");
            }
            if (splitPercentageString.length() > 0 && testFileName.length() != 0) {
                throw new IllegalArgumentException("Cannot perform percentage split when explicit test file is provided!");
            }
            if (thresholdFile.length() != 0 && discardPredictions) {
                throw new IllegalArgumentException("Can only output to threshold file when predictions are not discarded!");
            }
            if (outputModelsForTrainingSplits && (testFileName.length() > 0 || splitPercentageString.length() == 0 && noCrossValidation)) {
                throw new IllegalArgumentException("Can only output models for training splits if cross-validation or percentage split evaluation is performed!");
            }
            if (seedString.length() != 0) {
                seed = Integer.parseInt(seedString);
            }
            if (foldsString.length() != 0) {
                folds = Integer.parseInt(foldsString);
            }
            if (classIndexString.length() != 0) {
                classIndex = classIndexString.equals("first") ? 1 : (classIndexString.equals("last") ? -1 : Integer.parseInt(classIndexString));
            }
            if (testFileName.length() != 0) {
                try {
                    template = test = new ConverterUtils.DataSource(testFileName).getStructure();
                    if (classIndex != -1) {
                        test.setClassIndex(classIndex - 1);
                    } else if (test.classIndex() == -1 || classIndexString.length() != 0) {
                        test.setClassIndex(test.numAttributes() - 1);
                    }
                    actualClassIndex = test.classIndex();
                }
                catch (Exception e) {
                    throw new Exception("Can't open file " + testFileName + '.');
                }
            }
            if (trainFileName.length() != 0) {
                try {
                    template = train = new ConverterUtils.DataSource(trainFileName).getStructure();
                    if (classIndex != -1) {
                        train.setClassIndex(classIndex - 1);
                    } else if (train.classIndex() == -1 || classIndexString.length() != 0) {
                        train.setClassIndex(train.numAttributes() - 1);
                    }
                    actualClassIndex = train.classIndex();
                }
                catch (Exception e) {
                    throw new Exception("Can't open file " + trainFileName + '.');
                }
            }
            if (!(classifier instanceof InputMappedClassifier) && test != null && train != null && !test.equalHeaders(train)) {
                throw new IllegalArgumentException("Train and test file not compatible!\n" + test.equalHeadersMsg(train));
            }
            if (thresholdFile.length() != 0 && !template.classAttribute().isNominal()) {
                throw new IllegalArgumentException("Can only output to threshold file when class attribute is nominal!");
            }
            if (printMargins && !template.classAttribute().isNominal()) {
                throw new IllegalArgumentException("Can only print margins when class is nominal!");
            }
            if (objectInputFileName.length() != 0) {
                String[] backedUpClassifier = classifier;
                if (objectInputFileName.endsWith(".xml")) {
                    try {
                        OptionHandler cl = (OptionHandler)new XMLClassifier().read(objectInputFileName);
                        options = (String[])Stream.concat(Arrays.stream(cl.getOptions()), Arrays.stream(options)).toArray(String[]::new);
                        objectInputFileName = "";
                    }
                    catch (IllegalArgumentException ex) {
                        classifier = Evaluation.getModelFromFile(objectInputFileName, template);
                    }
                } else {
                    classifier = Evaluation.getModelFromFile(objectInputFileName, template);
                }
                if (!classifier.getClass().equals(backedUpClassifier.getClass())) {
                    throw new IllegalArgumentException("Loaded classifier is " + classifier.getClass().getCanonicalName() + ", not " + backedUpClassifier.getClass().getCanonicalName() + "!");
                }
            }
            if ((costMatrix = Evaluation.handleCostOption(Utils.getOption('m', options), template.numClasses())) != null && !template.classAttribute().isNominal()) {
                throw new IllegalArgumentException("Can only use cost matrix when class attribute is nominal!");
            }
            if (classifications.length() > 0) {
                classificationOutput = AbstractOutput.fromCommandline(classifications);
                if (classificationOutput == null) {
                    throw new IllegalArgumentException("Failed to instantiate class for classification output: " + classifications);
                }
                classificationOutput.setHeader(template);
            } else if (classificationsOld.length() > 0) {
                classificationOutput = new PlainText();
                classificationOutput.setHeader(template);
                if (!classificationsOld.equals("0")) {
                    classificationOutput.setAttributes(classificationsOld);
                }
                classificationOutput.setOutputDistribution(Utils.getFlag("distribution", options));
            } else if (Utils.getFlag("distribution", options)) {
                throw new Exception("Cannot print distribution without '-p' option!");
            }
            if (thresholdLabel.length() != 0) {
                labelIndex = template.classAttribute().indexOfValue(thresholdLabel);
            }
            if (labelIndex == -1) {
                throw new IllegalArgumentException("Class label '" + thresholdLabel + "' is unknown!");
            }
            if (objectInputFileName.length() == 0 && classifier instanceof OptionHandler) {
                for (String option : options) {
                    if (option.length() == 0) continue;
                    if (schemeOptionsText == null) {
                        schemeOptionsText = new StringBuffer();
                    }
                    if (option.indexOf(32) != -1) {
                        schemeOptionsText.append('\"' + option + "\" ");
                        continue;
                    }
                    schemeOptionsText.append(option + " ");
                }
                ((OptionHandler)classifier).setOptions(options);
            }
            Utils.checkForRemainingOptions(options);
        }
        catch (Exception ex) {
            throw new Exception("\nWeka exception: " + ex.getMessage() + Evaluation.makeOptionString((Classifier)classifier, false));
        }
        Classifier classifierBackup = null;
        if (objectInputFileName.length() == 0) {
            classifierBackup = AbstractClassifier.makeCopy((Classifier)classifier);
        }
        if (trainFileName.length() > 0 && (!noOutput || trainStatistics || printGraph || printSource || objectOutputFileName.length() > 0 || testFileName.length() > 0 || classificationOutput != null && noCrossValidation && splitPercentage == -1.0)) {
            if (classifier instanceof UpdateableClassifier && !forceBatchTraining) {
                trainTimeStart = System.currentTimeMillis();
                ConverterUtils.DataSource trainSource = new ConverterUtils.DataSource(trainFileName);
                trainSource.getStructure();
                if (objectInputFileName.length() <= 0) {
                    classifier.buildClassifier(new Instances(train, 0));
                }
                while (trainSource.hasMoreElements(train)) {
                    ((UpdateableClassifier)classifier).updateClassifier(trainSource.nextElement(train));
                }
                if (classifier instanceof UpdateableBatchProcessor) {
                    ((UpdateableBatchProcessor)classifier).batchFinished();
                }
                trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
            } else {
                Instances mappedClassifierDataset;
                Instances tempTrain = new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex);
                if (classifier instanceof InputMappedClassifier && !(mappedClassifierDataset = ((InputMappedClassifier)classifier).getModelHeader(new Instances(template, 0))).equalHeaders(tempTrain)) {
                    for (int zz = 0; zz < tempTrain.numInstances(); ++zz) {
                        Instance mapped = ((InputMappedClassifier)classifier).constructMappedInstance(tempTrain.instance(zz));
                        mappedClassifierDataset.add(mapped);
                    }
                    tempTrain = mappedClassifierDataset;
                }
                trainTimeStart = System.currentTimeMillis();
                classifier.buildClassifier(tempTrain);
                trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
            }
        }
        if (printGraph) {
            return ((Drawable)classifier).graph();
        }
        if (printSource) {
            return Evaluation.wekaStaticWrapper((Sourcable)classifier, sourceClass);
        }
        if (objectOutputFileName.length() > 0) {
            Evaluation.saveClassifier((Classifier)classifier, template, objectOutputFileName);
        }
        StringBuffer text = new StringBuffer();
        if (!noOutput && !printMargins && classificationOutput == null) {
            if (classifier instanceof OptionHandler && schemeOptionsText != null) {
                text.append("\nOptions: " + schemeOptionsText + "\n");
            }
            text.append("\n=== Classifier model (full training set) ===\n\n" + classifier.toString() + "\n");
            text.append("\nTime taken to build model: " + Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2) + " seconds\n");
        }
        if (!trainStatistics && noCrossValidation && splitPercentage != -1.0 && testFileName.length() <= 0 && classificationOutput == null) {
            if (noOutput) {
                return "";
            }
            return text.toString();
        }
        if (!printMargins && costMatrix != null) {
            text.append("\n=== Evaluation Cost Matrix ===\n\n");
            text.append(costMatrix.toString());
        }
        Instances mappedClassifierHeader = null;
        if (classifier instanceof InputMappedClassifier) {
            mappedClassifierHeader = ((InputMappedClassifier)classifier).getModelHeader(new Instances(template, 0));
        }
        if (classificationOutput != null) {
            if (classifier instanceof InputMappedClassifier) {
                classificationOutput.setHeader(mappedClassifierHeader);
            }
            StringBuffer predsBuff = new StringBuffer();
            classificationOutput.setBuffer(predsBuff);
            if (testFileName.length() > 0) {
                predsBuff.append("\n=== Predictions on test data ===\n\n");
                classificationOutput.print((Classifier)classifier, new ConverterUtils.DataSource(testFileName));
            } else if (splitPercentage > 0.0) {
                tmpInst = new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex);
                if (!preserveOrder) {
                    tmpInst.randomize(new Random(seed));
                }
                int trainSize = (int)Math.round((double)tmpInst.numInstances() * splitPercentage / 100.0);
                int testSize = tmpInst.numInstances() - trainSize;
                Instances trainInst = new Instances(tmpInst, 0, trainSize);
                classifier = AbstractClassifier.makeCopy(classifierBackup);
                classifier.buildClassifier(trainInst);
                trainInst = null;
                Instances testInst = new Instances(tmpInst, trainSize, testSize);
                predsBuff.append("\n=== Predictions on test split ===\n\n");
                classificationOutput.print((Classifier)classifier, testInst);
            } else if (!noCrossValidation) {
                random = new Random(seed);
                Evaluation testingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
                if (classifier instanceof InputMappedClassifier) {
                    testingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
                }
                testingEvaluation.toggleEvalMetrics(toggleList);
                classifier = AbstractClassifier.makeCopy(classifierBackup);
                predsBuff.append("\n=== Predictions under cross-validation ===\n\n");
                testingEvaluation.crossValidateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), folds, random, classificationOutput);
            } else {
                predsBuff.append("\n=== Predictions on training data ===\n\n");
                classificationOutput.print((Classifier)classifier, new ConverterUtils.DataSource(trainFileName));
            }
            text.append("\n" + predsBuff);
        } else {
            Evaluation trainingEvaluation;
            Evaluation testingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
            if (classifier instanceof InputMappedClassifier) {
                testingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
            }
            testingEvaluation.setDiscardPredictions(discardPredictions);
            testingEvaluation.toggleEvalMetrics(toggleList);
            if (testFileName.length() > 0) {
                if (train != null && trainStatistics && !printMargins) {
                    trainingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
                    if (classifier instanceof InputMappedClassifier) {
                        trainingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
                    }
                    trainingEvaluation.setDiscardPredictions(discardPredictions);
                    trainingEvaluation.toggleEvalMetrics(toggleList);
                    trainingEvaluation.setPriors(train);
                    testingEvaluation.setPriors(train);
                    ConverterUtils.DataSource trainSource = new ConverterUtils.DataSource(trainFileName);
                    trainSource.getStructure();
                    while (trainSource.hasMoreElements(train)) {
                        Instance trainInst = trainSource.nextElement(train);
                        trainingEvaluation.updatePriors(trainInst);
                        testingEvaluation.updatePriors(trainInst);
                    }
                    if (classifier instanceof BatchPredictor && ((BatchPredictor)classifier).implementsMoreEfficientBatchPrediction()) {
                        testTimeStart = System.currentTimeMillis();
                        trainingEvaluation.evaluateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), new Object[0]);
                        testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                    } else {
                        trainSource = new ConverterUtils.DataSource(trainFileName);
                        trainSource.getStructure();
                        testTimeStart = System.currentTimeMillis();
                        while (trainSource.hasMoreElements(train)) {
                            trainingEvaluation.evaluateModelOnceAndRecordPrediction((Classifier)classifier, trainSource.nextElement(train));
                        }
                        testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                    }
                    text.append("\nTime taken to test model on training data: ");
                    text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                    text.append(trainingEvaluation.toSummaryString("\n\n=== Error on training data ===\n", printComplexityStatistics));
                    if (template.classAttribute().isNominal()) {
                        if (classStatistics) {
                            text.append("\n\n" + trainingEvaluation.toClassDetailsString());
                        }
                        text.append("\n\n" + trainingEvaluation.toMatrixString());
                    }
                }
                if (train == null) {
                    testingEvaluation.useNoPriors();
                }
                if (classifier instanceof BatchPredictor && ((BatchPredictor)classifier).implementsMoreEfficientBatchPrediction()) {
                    testTimeStart = System.currentTimeMillis();
                    testingEvaluation.evaluateModel((Classifier)classifier, new ConverterUtils.DataSource(testFileName).getDataSet(test.classIndex()), new Object[0]);
                    testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                } else {
                    ConverterUtils.DataSource testSource = new ConverterUtils.DataSource(testFileName);
                    testSource.getStructure();
                    testTimeStart = System.currentTimeMillis();
                    while (testSource.hasMoreElements(test)) {
                        testingEvaluation.evaluateModelOnceAndRecordPrediction((Classifier)classifier, testSource.nextElement(test));
                    }
                    testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                }
                if (printMargins) {
                    return testingEvaluation.toCumulativeMarginDistributionString();
                }
                text.append("\nTime taken to test model on test data: ");
                text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                text.append(testingEvaluation.toSummaryString("\n\n=== Error on test data ===\n", printComplexityStatistics));
                if (template.classAttribute().isNominal()) {
                    if (classStatistics) {
                        text.append("\n\n" + testingEvaluation.toClassDetailsString());
                    }
                    text.append("\n\n" + testingEvaluation.toMatrixString());
                }
            } else if (splitPercentage > 0.0) {
                if (train != null && trainStatistics && !printMargins) {
                    trainingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
                    if (classifier instanceof InputMappedClassifier) {
                        trainingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
                    }
                    trainingEvaluation.setDiscardPredictions(discardPredictions);
                    trainingEvaluation.toggleEvalMetrics(toggleList);
                    ConverterUtils.DataSource trainSource = new ConverterUtils.DataSource(trainFileName);
                    trainSource.getStructure();
                    trainingEvaluation.setPriors(train);
                    while (trainSource.hasMoreElements(train)) {
                        trainingEvaluation.updatePriors(trainSource.nextElement(train));
                    }
                    if (classifier instanceof BatchPredictor && ((BatchPredictor)classifier).implementsMoreEfficientBatchPrediction()) {
                        testTimeStart = System.currentTimeMillis();
                        trainingEvaluation.evaluateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), new Object[0]);
                        testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                    } else {
                        trainSource = new ConverterUtils.DataSource(trainFileName);
                        trainSource.getStructure();
                        testTimeStart = System.currentTimeMillis();
                        while (trainSource.hasMoreElements(train)) {
                            trainingEvaluation.evaluateModelOnceAndRecordPrediction((Classifier)classifier, trainSource.nextElement(train));
                        }
                        testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                    }
                    text.append("\nTime taken to test model on training data: ");
                    text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                    text.append(trainingEvaluation.toSummaryString("\n\n=== Error on training data ===\n", printComplexityStatistics));
                    if (template.classAttribute().isNominal()) {
                        if (classStatistics) {
                            text.append("\n\n" + trainingEvaluation.toClassDetailsString());
                        }
                        text.append("\n\n" + trainingEvaluation.toMatrixString());
                    }
                }
                tmpInst = new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex);
                if (!preserveOrder) {
                    tmpInst.randomize(new Random(seed));
                }
                int trainSize = (int)Math.round((double)tmpInst.numInstances() * splitPercentage / 100.0);
                int testSize = tmpInst.numInstances() - trainSize;
                Instances trainInst = new Instances(tmpInst, 0, trainSize);
                classifier = AbstractClassifier.makeCopy(classifierBackup);
                classifier.buildClassifier(trainInst);
                if (outputModelsForTrainingSplits) {
                    text.append("\n=== Classifier model (training split) ===\n\n" + classifier.toString() + "\n");
                }
                testingEvaluation.setPriors(trainInst);
                trainInst = null;
                Instances testInst = new Instances(tmpInst, trainSize, testSize);
                testTimeStart = System.currentTimeMillis();
                testingEvaluation.evaluateModel((Classifier)classifier, testInst, new Object[0]);
                testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                if (printMargins) {
                    return testingEvaluation.toCumulativeMarginDistributionString();
                }
                text.append("\nTime taken to test model on test split: ");
                text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                text.append(testingEvaluation.toSummaryString("\n\n=== Error on test split ===\n", printComplexityStatistics));
                if (template.classAttribute().isNominal()) {
                    if (classStatistics) {
                        text.append("\n\n" + testingEvaluation.toClassDetailsString());
                    }
                    text.append("\n\n" + testingEvaluation.toMatrixString());
                }
            } else if (!noCrossValidation) {
                if (train != null && trainStatistics && !printMargins) {
                    trainingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
                    if (classifier instanceof InputMappedClassifier) {
                        trainingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
                    }
                    trainingEvaluation.setDiscardPredictions(discardPredictions);
                    trainingEvaluation.toggleEvalMetrics(toggleList);
                    ConverterUtils.DataSource trainSource = new ConverterUtils.DataSource(trainFileName);
                    trainSource.getStructure();
                    trainingEvaluation.setPriors(train);
                    while (trainSource.hasMoreElements(train)) {
                        trainingEvaluation.updatePriors(trainSource.nextElement(train));
                    }
                    if (classifier instanceof BatchPredictor && ((BatchPredictor)classifier).implementsMoreEfficientBatchPrediction()) {
                        testTimeStart = System.currentTimeMillis();
                        trainingEvaluation.evaluateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), new Object[0]);
                        testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                    } else {
                        trainSource = new ConverterUtils.DataSource(trainFileName);
                        trainSource.getStructure();
                        testTimeStart = System.currentTimeMillis();
                        while (trainSource.hasMoreElements(train)) {
                            trainingEvaluation.evaluateModelOnceAndRecordPrediction((Classifier)classifier, trainSource.nextElement(train));
                        }
                        testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                    }
                    text.append("\nTime taken to test model on training data: ");
                    text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                    text.append(trainingEvaluation.toSummaryString("\n\n=== Error on training data ===\n", printComplexityStatistics));
                    if (template.classAttribute().isNominal()) {
                        if (classStatistics) {
                            text.append("\n\n" + trainingEvaluation.toClassDetailsString());
                        }
                        text.append("\n\n" + trainingEvaluation.toMatrixString());
                    }
                }
                random = new Random(seed);
                classifier = AbstractClassifier.makeCopy(classifierBackup);
                testTimeStart = System.currentTimeMillis();
                if (!outputModelsForTrainingSplits) {
                    testingEvaluation.crossValidateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), folds, random);
                } else {
                    testingEvaluation.crossValidateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), folds, random, text);
                }
                testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                if (printMargins) {
                    return testingEvaluation.toCumulativeMarginDistributionString();
                }
                text.append("\nTime taken to perform cross-validation: ");
                text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                if (template.classAttribute().isNumeric()) {
                    text.append("\n\n\n" + testingEvaluation.toSummaryString("=== Cross-validation ===\n", printComplexityStatistics));
                } else {
                    text.append("\n\n\n" + testingEvaluation.toSummaryString("=== Stratified cross-validation ===\n", printComplexityStatistics));
                }
                if (template.classAttribute().isNominal()) {
                    if (classStatistics) {
                        text.append("\n\n" + testingEvaluation.toClassDetailsString());
                    }
                    text.append("\n\n" + testingEvaluation.toMatrixString());
                }
            } else if (trainStatistics && train != null) {
                trainingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
                if (classifier instanceof InputMappedClassifier) {
                    trainingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
                }
                trainingEvaluation.setDiscardPredictions(discardPredictions);
                trainingEvaluation.toggleEvalMetrics(toggleList);
                ConverterUtils.DataSource trainSource = new ConverterUtils.DataSource(trainFileName);
                trainSource.getStructure();
                trainingEvaluation.setPriors(train);
                while (trainSource.hasMoreElements(train)) {
                    trainingEvaluation.updatePriors(trainSource.nextElement(train));
                }
                if (classifier instanceof BatchPredictor && ((BatchPredictor)classifier).implementsMoreEfficientBatchPrediction()) {
                    testTimeStart = System.currentTimeMillis();
                    trainingEvaluation.evaluateModel((Classifier)classifier, new ConverterUtils.DataSource(trainFileName).getDataSet(actualClassIndex), new Object[0]);
                    testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                } else {
                    trainSource = new ConverterUtils.DataSource(trainFileName);
                    trainSource.getStructure();
                    testTimeStart = System.currentTimeMillis();
                    while (trainSource.hasMoreElements(train)) {
                        trainingEvaluation.evaluateModelOnceAndRecordPrediction((Classifier)classifier, trainSource.nextElement(train));
                    }
                    testTimeElapsed = System.currentTimeMillis() - testTimeStart;
                }
                if (printMargins) {
                    return trainingEvaluation.toCumulativeMarginDistributionString();
                }
                text.append("\nTime taken to test model on training data: ");
                text.append(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2) + " seconds");
                text.append(trainingEvaluation.toSummaryString("\n\n=== Error on training data ===\n", printComplexityStatistics));
                if (template.classAttribute().isNominal()) {
                    if (classStatistics) {
                        text.append("\n\n" + trainingEvaluation.toClassDetailsString());
                    }
                    text.append("\n\n" + trainingEvaluation.toMatrixString());
                }
                testingEvaluation = trainingEvaluation;
            }
            if (thresholdFile.length() != 0) {
                ThresholdCurve tc = new ThresholdCurve();
                Instances result = tc.getCurve(testingEvaluation.predictions(), labelIndex);
                ConverterUtils.DataSink.write(thresholdFile, result);
            }
        }
        return text.toString();
    }

    protected static CostMatrix handleCostOption(String costFileName, int numClasses) throws Exception {
        if (costFileName != null && costFileName.length() != 0) {
            BufferedReader costReader = null;
            try {
                costReader = new BufferedReader(new FileReader(costFileName));
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + '.');
            }
            try {
                return new CostMatrix(costReader);
            }
            catch (Exception ex) {
                try {
                    try {
                        ((Reader)costReader).close();
                        costReader = new BufferedReader(new FileReader(costFileName));
                    }
                    catch (Exception e) {
                        throw new Exception("Can't open file " + e.getMessage() + '.');
                    }
                    CostMatrix costMatrix = new CostMatrix(numClasses);
                    costMatrix.readOldFormat(costReader);
                    return costMatrix;
                }
                catch (Exception e2) {
                    throw ex;
                }
            }
        }
        return null;
    }

    public double[] evaluateModel(Classifier classifier, Instances data, Object ... forPredictionsPrinting) throws Exception {
        AbstractOutput classificationOutput = null;
        double[] predictions = new double[data.numInstances()];
        if (forPredictionsPrinting.length > 0) {
            classificationOutput = (AbstractOutput)forPredictionsPrinting[0];
        }
        if (classifier instanceof BatchPredictor && ((BatchPredictor)((Object)classifier)).implementsMoreEfficientBatchPrediction()) {
            Instances dataPred = new Instances(data);
            for (int i = 0; i < data.numInstances(); ++i) {
                dataPred.instance(i).setClassMissing();
            }
            double[][] preds = ((BatchPredictor)((Object)classifier)).distributionsForInstances(dataPred);
            for (int i = 0; i < data.numInstances(); ++i) {
                double[] p = preds[i];
                predictions[i] = this.evaluationForSingleInstance(p, data.instance(i), true);
                if (classificationOutput == null) continue;
                classificationOutput.printClassification(p, data.instance(i), i);
            }
        } else {
            for (int i = 0; i < data.numInstances(); ++i) {
                predictions[i] = this.evaluateModelOnceAndRecordPrediction(classifier, data.instance(i));
                if (classificationOutput == null) continue;
                classificationOutput.printClassification(classifier, data.instance(i), i);
            }
        }
        return predictions;
    }

    public double evaluationForSingleInstance(double[] dist, Instance instance, boolean storePredictions) throws Exception {
        double pred;
        if (Thread.interrupted()) {
            throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
        }
        if (this.m_ClassIsNominal) {
            pred = Utils.maxIndex(dist);
            if (dist[(int)pred] <= 0.0) {
                pred = Utils.missingValue();
            }
            this.updateStatsForClassifier(dist, instance);
            if (storePredictions && !this.m_DiscardPredictions) {
                if (this.m_Predictions == null) {
                    this.m_Predictions = new ArrayList();
                }
                this.m_Predictions.add(new NominalPrediction(instance.classValue(), dist, instance.weight()));
            }
        } else {
            pred = dist[0];
            this.updateStatsForPredictor(pred, instance);
            if (storePredictions && !this.m_DiscardPredictions) {
                if (this.m_Predictions == null) {
                    this.m_Predictions = new ArrayList();
                }
                this.m_Predictions.add(new NumericPrediction(instance.classValue(), pred, instance.weight()));
            }
        }
        return pred;
    }

    protected double evaluationForSingleInstance(Classifier classifier, Instance instance, boolean storePredictions) throws Exception {
        Instance classMissing = (Instance)instance.copy();
        classMissing.setDataset(instance.dataset());
        if (classifier instanceof InputMappedClassifier) {
            instance = (Instance)instance.copy();
            instance = ((InputMappedClassifier)classifier).constructMappedInstance(instance);
            int mappedClass = ((InputMappedClassifier)classifier).getMappedClassIndex();
            classMissing.setMissing(mappedClass);
        } else {
            classMissing.setClassMissing();
        }
        double pred = this.evaluationForSingleInstance(classifier.distributionForInstance(classMissing), instance, storePredictions);
        if (!(this.m_ClassIsNominal || instance.classIsMissing() || Utils.isMissingValue(pred))) {
            if (classifier instanceof IntervalEstimator) {
                this.updateStatsForIntervalEstimator((IntervalEstimator)((Object)classifier), classMissing, instance.classValue());
            } else {
                this.m_CoverageStatisticsAvailable = false;
            }
            if (classifier instanceof ConditionalDensityEstimator) {
                this.updateStatsForConditionalDensityEstimator((ConditionalDensityEstimator)((Object)classifier), classMissing, instance.classValue());
            } else {
                this.m_ComplexityStatisticsAvailable = false;
            }
        }
        return pred;
    }

    public double evaluateModelOnceAndRecordPrediction(Classifier classifier, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(classifier, instance, true);
    }

    public double evaluateModelOnce(Classifier classifier, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(classifier, instance, false);
    }

    public double evaluateModelOnce(double[] dist, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(dist, instance, false);
    }

    public double evaluateModelOnceAndRecordPrediction(double[] dist, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(dist, instance, true);
    }

    public void evaluateModelOnce(double prediction, Instance instance) throws Exception {
        this.evaluateModelOnce(this.makeDistribution(prediction), instance);
    }

    public ArrayList<Prediction> predictions() {
        if (this.m_DiscardPredictions) {
            return null;
        }
        return this.m_Predictions;
    }

    public static String wekaStaticWrapper(Sourcable classifier, String className) throws Exception {
        StringBuffer result = new StringBuffer();
        String staticClassifier = classifier.toSource(className);
        result.append("// Generated with Weka " + Version.VERSION + "\n");
        result.append("//\n");
        result.append("// This code is public domain and comes with no warranty.\n");
        result.append("//\n");
        result.append("// Timestamp: " + new Date() + "\n");
        result.append("\n");
        result.append("package weka.classifiers;\n");
        result.append("\n");
        result.append("import weka.core.Attribute;\n");
        result.append("import weka.core.Capabilities;\n");
        result.append("import weka.core.Capabilities.Capability;\n");
        result.append("import weka.core.Instance;\n");
        result.append("import weka.core.Instances;\n");
        result.append("import weka.core.RevisionUtils;\n");
        result.append("import weka.classifiers.Classifier;\nimport weka.classifiers.AbstractClassifier;\n");
        result.append("\n");
        result.append("public class WekaWrapper\n");
        result.append("  extends AbstractClassifier {\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns only the toString() method.\n");
        result.append("   *\n");
        result.append("   * @return a string describing the classifier\n");
        result.append("   */\n");
        result.append("  public String globalInfo() {\n");
        result.append("    return toString();\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns the capabilities of this classifier.\n");
        result.append("   *\n");
        result.append("   * @return the capabilities\n");
        result.append("   */\n");
        result.append("  public Capabilities getCapabilities() {\n");
        result.append(((Classifier)((Object)classifier)).getCapabilities().toSource("result", 4));
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * only checks the data against its capabilities.\n");
        result.append("   *\n");
        result.append("   * @param i the training data\n");
        result.append("   */\n");
        result.append("  public void buildClassifier(Instances i) throws Exception {\n");
        result.append("    // can classifier handle the data?\n");
        result.append("    getCapabilities().testWithFail(i);\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Classifies the given instance.\n");
        result.append("   *\n");
        result.append("   * @param i the instance to classify\n");
        result.append("   * @return the classification result\n");
        result.append("   */\n");
        result.append("  public double classifyInstance(Instance i) throws Exception {\n");
        result.append("    Object[] s = new Object[i.numAttributes()];\n");
        result.append("    \n");
        result.append("    for (int j = 0; j < s.length; j++) {\n");
        result.append("      if (!i.isMissing(j)) {\n");
        result.append("        if (i.attribute(j).isNominal())\n");
        result.append("          s[j] = new String(i.stringValue(j));\n");
        result.append("        else if (i.attribute(j).isNumeric())\n");
        result.append("          s[j] = new Double(i.value(j));\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("    \n");
        result.append("    // set class value to missing\n");
        result.append("    s[i.classIndex()] = null;\n");
        result.append("    \n");
        result.append("    return " + className + ".classify(s);\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns the revision string.\n");
        result.append("   * \n");
        result.append("   * @return        the revision\n");
        result.append("   */\n");
        result.append("  public String getRevision() {\n");
        result.append("    return RevisionUtils.extract(\"1.0\");\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns only the classnames and what classifier it is based on.\n");
        result.append("   *\n");
        result.append("   * @return a short description\n");
        result.append("   */\n");
        result.append("  public String toString() {\n");
        result.append("    return \"Auto-generated classifier wrapper, based on " + classifier.getClass().getName() + " (generated with Weka " + Version.VERSION + ").\\n\" + this.getClass().getName() + \"/" + className + "\";\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Runs the classfier from commandline.\n");
        result.append("   *\n");
        result.append("   * @param args the commandline arguments\n");
        result.append("   */\n");
        result.append("  public static void main(String args[]) {\n");
        result.append("    runClassifier(new WekaWrapper(), args);\n");
        result.append("  }\n");
        result.append("}\n");
        result.append("\n");
        result.append(staticClassifier);
        return result.toString();
    }

    public final double numInstances() {
        return this.m_WithClass;
    }

    public final double coverageOfTestCasesByPredictedRegions() {
        if (!this.m_CoverageStatisticsAvailable) {
            return Double.NaN;
        }
        return 100.0 * this.m_TotalCoverage / this.m_WithClass;
    }

    public final double sizeOfPredictedRegions() {
        if (this.m_NoPriors || !this.m_CoverageStatisticsAvailable) {
            return Double.NaN;
        }
        return 100.0 * this.m_TotalSizeOfRegions / this.m_WithClass;
    }

    public final double withClass() {
        return this.m_WithClass;
    }

    public final double missingClass() {
        return this.m_MissingClass;
    }

    public final double incorrect() {
        return this.m_Incorrect;
    }

    public final double pctIncorrect() {
        return 100.0 * this.m_Incorrect / this.m_WithClass;
    }

    public final double totalCost() {
        return this.m_TotalCost;
    }

    public final double avgCost() {
        return this.m_TotalCost / this.m_WithClass;
    }

    public final double correct() {
        return this.m_Correct;
    }

    public final double pctCorrect() {
        return 100.0 * this.m_Correct / this.m_WithClass;
    }

    public final double unclassified() {
        return this.m_Unclassified;
    }

    public final double pctUnclassified() {
        return 100.0 * this.m_Unclassified / this.m_WithClass;
    }

    public final double errorRate() {
        if (!this.m_ClassIsNominal) {
            return Math.sqrt(this.m_SumSqrErr / (this.m_WithClass - this.m_Unclassified));
        }
        if (this.m_CostMatrix == null) {
            return this.m_Incorrect / this.m_WithClass;
        }
        return this.avgCost();
    }

    public final double kappa() {
        double[] sumRows = new double[this.m_ConfusionMatrix.length];
        double[] sumColumns = new double[this.m_ConfusionMatrix.length];
        double sumOfWeights = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            for (int j = 0; j < this.m_ConfusionMatrix.length; ++j) {
                int n = i;
                sumRows[n] = sumRows[n] + this.m_ConfusionMatrix[i][j];
                int n2 = j;
                sumColumns[n2] = sumColumns[n2] + this.m_ConfusionMatrix[i][j];
                sumOfWeights += this.m_ConfusionMatrix[i][j];
            }
        }
        double correct = 0.0;
        double chanceAgreement = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            chanceAgreement += sumRows[i] * sumColumns[i];
            correct += this.m_ConfusionMatrix[i][i];
        }
        chanceAgreement /= sumOfWeights * sumOfWeights;
        correct /= sumOfWeights;
        if (chanceAgreement < 1.0) {
            return (correct - chanceAgreement) / (1.0 - chanceAgreement);
        }
        return 1.0;
    }

    public final double correlationCoefficient() throws Exception {
        if (this.m_ClassIsNominal) {
            throw new Exception("Can't compute correlation coefficient: class is nominal!");
        }
        double correlation = 0.0;
        double varActual = this.m_SumSqrClass - this.m_SumClass * this.m_SumClass / (this.m_WithClass - this.m_Unclassified);
        double varPredicted = this.m_SumSqrPredicted - this.m_SumPredicted * this.m_SumPredicted / (this.m_WithClass - this.m_Unclassified);
        double varProd = this.m_SumClassPredicted - this.m_SumClass * this.m_SumPredicted / (this.m_WithClass - this.m_Unclassified);
        correlation = varActual * varPredicted <= 0.0 ? 0.0 : varProd / Math.sqrt(varActual * varPredicted);
        return correlation;
    }

    public final double meanAbsoluteError() {
        return this.m_SumAbsErr / (this.m_WithClass - this.m_Unclassified);
    }

    public final double meanPriorAbsoluteError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumPriorAbsErr / this.m_WithClass;
    }

    public final double relativeAbsoluteError() throws Exception {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.meanAbsoluteError() / this.meanPriorAbsoluteError();
    }

    public final double rootMeanSquaredError() {
        return Math.sqrt(this.m_SumSqrErr / (this.m_WithClass - this.m_Unclassified));
    }

    public final double rootMeanPriorSquaredError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return Math.sqrt(this.m_SumPriorSqrErr / this.m_WithClass);
    }

    public final double rootRelativeSquaredError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.rootMeanSquaredError() / this.rootMeanPriorSquaredError();
    }

    public final double priorEntropy() {
        return this.SFMeanPriorEntropy();
    }

    public final double KBInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumKBInfo;
    }

    public final double KBMeanInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumKBInfo / (this.m_WithClass - this.m_Unclassified);
    }

    public final double KBRelativeInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.KBMeanInformation() / this.priorEntropy();
    }

    public final double SFPriorEntropy() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy;
    }

    public final double SFMeanPriorEntropy() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy / this.m_WithClass;
    }

    public final double SFSchemeEntropy() {
        if (!this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumSchemeEntropy;
    }

    public final double SFMeanSchemeEntropy() {
        if (!this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumSchemeEntropy / (this.m_WithClass - this.m_Unclassified);
    }

    public final double SFEntropyGain() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy - this.m_SumSchemeEntropy;
    }

    public final double SFMeanEntropyGain() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return (this.m_SumPriorEntropy - this.m_SumSchemeEntropy) / (this.m_WithClass - this.m_Unclassified);
    }

    public String toCumulativeMarginDistributionString() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Class must be nominal for margin distributions");
        }
        String result = "";
        double cumulativeCount = 0.0;
        for (int i = 0; i <= k_MarginResolution; ++i) {
            if (this.m_MarginCounts[i] != 0.0) {
                double margin = (double)i * 2.0 / (double)k_MarginResolution - 1.0;
                result = result + Utils.doubleToString(margin, 7, 3) + ' ' + Utils.doubleToString((cumulativeCount += this.m_MarginCounts[i]) * 100.0 / this.m_WithClass, 7, 3) + '\n';
                continue;
            }
            if (i != 0) continue;
            result = Utils.doubleToString(-1.0, 7, 3) + ' ' + Utils.doubleToString(0.0, 7, 3) + '\n';
        }
        return result;
    }

    @Override
    public String toSummaryString() {
        return this.toSummaryString("", false);
    }

    public String toSummaryString(boolean printComplexityStatistics) {
        return this.toSummaryString("=== Summary ===\n", printComplexityStatistics);
    }

    public String toSummaryString(String title, boolean printComplexityStatistics) {
        StringBuffer text = new StringBuffer();
        if (printComplexityStatistics && this.m_NoPriors) {
            printComplexityStatistics = false;
            System.err.println("Priors disabled, cannot print complexity statistics!");
        }
        text.append(title + "\n");
        try {
            if (this.m_WithClass > 0.0) {
                Object formattedS;
                if (this.m_ClassIsNominal) {
                    boolean displayCorrect = this.m_metricsToDisplay.contains("correct");
                    boolean displayIncorrect = this.m_metricsToDisplay.contains("incorrect");
                    boolean displayKappa = this.m_metricsToDisplay.contains("kappa");
                    boolean displayTotalCost = this.m_metricsToDisplay.contains("total cost");
                    boolean displayAverageCost = this.m_metricsToDisplay.contains("average cost");
                    if (displayCorrect) {
                        text.append("Correctly Classified Instances     ");
                        text.append(Utils.doubleToString(this.correct(), 12, 4) + "     " + Utils.doubleToString(this.pctCorrect(), 12, 4) + " %\n");
                    }
                    if (displayIncorrect) {
                        text.append("Incorrectly Classified Instances   ");
                        text.append(Utils.doubleToString(this.incorrect(), 12, 4) + "     " + Utils.doubleToString(this.pctIncorrect(), 12, 4) + " %\n");
                    }
                    if (displayKappa) {
                        text.append("Kappa statistic                    ");
                        text.append(Utils.doubleToString(this.kappa(), 12, 4) + "\n");
                    }
                    if (this.m_CostMatrix != null) {
                        if (displayTotalCost) {
                            text.append("Total Cost                         ");
                            text.append(Utils.doubleToString(this.totalCost(), 12, 4) + "\n");
                        }
                        if (displayAverageCost) {
                            text.append("Average Cost                       ");
                            text.append(Utils.doubleToString(this.avgCost(), 12, 4) + "\n");
                        }
                    }
                    if (printComplexityStatistics) {
                        boolean displayKBRelative = this.m_metricsToDisplay.contains("kb relative");
                        boolean displayKBInfo = this.m_metricsToDisplay.contains("kb information");
                        if (displayKBRelative) {
                            text.append("K&B Relative Info Score            ");
                            text.append(Utils.doubleToString(this.KBRelativeInformation(), 12, 4) + " %\n");
                        }
                        if (displayKBInfo) {
                            text.append("K&B Information Score              ");
                            text.append(Utils.doubleToString(this.KBInformation(), 12, 4) + " bits");
                            text.append(Utils.doubleToString(this.KBMeanInformation(), 12, 4) + " bits/instance\n");
                        }
                    }
                    if (this.m_pluginMetrics != null) {
                        for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                            String metricName;
                            boolean display;
                            if (!(m instanceof StandardEvaluationMetric) || !m.appliesToNominalClass() || m.appliesToNumericClass() || !(display = this.m_metricsToDisplay.contains(metricName = m.getMetricName().toLowerCase()))) continue;
                            formattedS = ((StandardEvaluationMetric)((Object)m)).toSummaryString();
                            text.append((String)formattedS);
                        }
                    }
                } else {
                    boolean displayCorrelation = this.m_metricsToDisplay.contains("correlation");
                    if (displayCorrelation) {
                        text.append("Correlation coefficient            ");
                        text.append(Utils.doubleToString(this.correlationCoefficient(), 12, 4) + "\n");
                    }
                    if (this.m_pluginMetrics != null) {
                        for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                            String metricName;
                            boolean display;
                            if (!(m instanceof StandardEvaluationMetric) || m.appliesToNominalClass() || !m.appliesToNumericClass() || !(display = this.m_metricsToDisplay.contains(metricName = m.getMetricName().toLowerCase()))) continue;
                            String formattedS2 = ((StandardEvaluationMetric)((Object)m)).toSummaryString();
                            text.append(formattedS2);
                        }
                    }
                }
                if (printComplexityStatistics && this.m_ComplexityStatisticsAvailable) {
                    boolean displayComplexityOrder0 = this.m_metricsToDisplay.contains("complexity 0");
                    boolean displayComplexityScheme = this.m_metricsToDisplay.contains("complexity scheme");
                    boolean displayComplexityImprovement = this.m_metricsToDisplay.contains("complexity improvement");
                    if (displayComplexityOrder0) {
                        text.append("Class complexity | order 0         ");
                        text.append(Utils.doubleToString(this.SFPriorEntropy(), 12, 4) + " bits");
                        text.append(Utils.doubleToString(this.SFMeanPriorEntropy(), 12, 4) + " bits/instance\n");
                    }
                    if (displayComplexityScheme) {
                        text.append("Class complexity | scheme          ");
                        text.append(Utils.doubleToString(this.SFSchemeEntropy(), 12, 4) + " bits");
                        text.append(Utils.doubleToString(this.SFMeanSchemeEntropy(), 12, 4) + " bits/instance\n");
                    }
                    if (displayComplexityImprovement) {
                        text.append("Complexity improvement     (Sf)    ");
                        text.append(Utils.doubleToString(this.SFEntropyGain(), 12, 4) + " bits");
                        text.append(Utils.doubleToString(this.SFMeanEntropyGain(), 12, 4) + " bits/instance\n");
                    }
                }
                if (printComplexityStatistics && this.m_pluginMetrics != null) {
                    for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                        if (!(m instanceof InformationTheoreticEvaluationMetric) || (!this.m_ClassIsNominal || !m.appliesToNominalClass()) && (this.m_ClassIsNominal || !m.appliesToNumericClass())) continue;
                        String metricName = m.getMetricName().toLowerCase();
                        boolean display = this.m_metricsToDisplay.contains(metricName);
                        List<String> statNames = m.getStatisticNames();
                        for (String s : statNames) {
                            display = display && this.m_metricsToDisplay.contains(s.toLowerCase());
                        }
                        if (!display) continue;
                        String formattedS2 = ((InformationTheoreticEvaluationMetric)((Object)m)).toSummaryString();
                        text.append(formattedS2);
                    }
                }
                boolean displayMAE = this.m_metricsToDisplay.contains("mae");
                boolean displayRMSE = this.m_metricsToDisplay.contains("rmse");
                boolean displayRAE = this.m_metricsToDisplay.contains("rae");
                boolean displayRRSE = this.m_metricsToDisplay.contains("rrse");
                if (displayMAE) {
                    text.append("Mean absolute error                ");
                    text.append(Utils.doubleToString(this.meanAbsoluteError(), 12, 4) + "\n");
                }
                if (displayRMSE) {
                    text.append("Root mean squared error            ");
                    text.append(Utils.doubleToString(this.rootMeanSquaredError(), 12, 4) + "\n");
                }
                if (!this.m_NoPriors) {
                    if (displayRAE) {
                        text.append("Relative absolute error            ");
                        text.append(Utils.doubleToString(this.relativeAbsoluteError(), 12, 4) + " %\n");
                    }
                    if (displayRRSE) {
                        text.append("Root relative squared error        ");
                        text.append(Utils.doubleToString(this.rootRelativeSquaredError(), 12, 4) + " %\n");
                    }
                }
                if (this.m_pluginMetrics != null) {
                    for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                        if (!(m instanceof StandardEvaluationMetric) || !m.appliesToNominalClass() || !m.appliesToNumericClass()) continue;
                        String metricName = m.getMetricName().toLowerCase();
                        boolean display = this.m_metricsToDisplay.contains(metricName);
                        List<String> statNames = m.getStatisticNames();
                        for (String s : statNames) {
                            display = display && this.m_metricsToDisplay.contains(s.toLowerCase());
                        }
                        if (!display) continue;
                        formattedS = ((StandardEvaluationMetric)((Object)m)).toSummaryString();
                        text.append((String)formattedS);
                    }
                }
                if (this.m_CoverageStatisticsAvailable) {
                    boolean displayCoverage = this.m_metricsToDisplay.contains("coverage");
                    boolean displayRegionSize = this.m_metricsToDisplay.contains("region size");
                    if (displayCoverage) {
                        text.append("Coverage of cases (" + Utils.doubleToString(this.m_ConfLevel, 4, 2) + " level)     ");
                        text.append(Utils.doubleToString(this.coverageOfTestCasesByPredictedRegions(), 12, 4) + " %\n");
                    }
                    if (!this.m_NoPriors && displayRegionSize) {
                        text.append("Mean rel. region size (" + Utils.doubleToString(this.m_ConfLevel, 4, 2) + " level) ");
                        text.append(Utils.doubleToString(this.sizeOfPredictedRegions(), 12, 4) + " %\n");
                    }
                }
            }
            if (Utils.gr(this.unclassified(), 0.0)) {
                text.append("UnClassified Instances             ");
                text.append(Utils.doubleToString(this.unclassified(), 12, 4) + "     " + Utils.doubleToString(this.pctUnclassified(), 12, 4) + " %\n");
            }
            text.append("Total Number of Instances          ");
            text.append(Utils.doubleToString(this.m_WithClass, 12, 4) + "\n");
            if (this.m_MissingClass > 0.0) {
                text.append("Ignored Class Unknown Instances            ");
                text.append(Utils.doubleToString(this.m_MissingClass, 12, 4) + "\n");
            }
        }
        catch (Exception ex) {
            System.err.println("Arggh - Must be a bug in Evaluation class");
            ex.printStackTrace();
        }
        return text.toString();
    }

    public String toMatrixString() throws Exception {
        return this.toMatrixString("=== Confusion Matrix ===\n");
    }

    public String toMatrixString(String title) throws Exception {
        int j;
        int i;
        StringBuffer text = new StringBuffer();
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        double maxval = 0.0;
        for (i = 0; i < this.m_NumClasses; ++i) {
            for (j = 0; j < this.m_NumClasses; ++j) {
                double current = this.m_ConfusionMatrix[i][j];
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (fractional || !(Math.log(fract) / Math.log(10.0) >= -2.0)) continue;
                fractional = true;
            }
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(this.m_NumClasses) / Math.log(IDChars.length)));
        text.append(title).append("\n");
        for (i = 0; i < this.m_NumClasses; ++i) {
            if (fractional) {
                text.append(" ").append(this.num2ShortID(i, IDChars, IDWidth - 3)).append("   ");
                continue;
            }
            text.append(" ").append(this.num2ShortID(i, IDChars, IDWidth));
        }
        text.append("   <-- classified as\n");
        for (i = 0; i < this.m_NumClasses; ++i) {
            for (j = 0; j < this.m_NumClasses; ++j) {
                text.append(" ").append(Utils.doubleToString(this.m_ConfusionMatrix[i][j], IDWidth, fractional ? 2 : 0));
            }
            text.append(" | ").append(this.num2ShortID(i, IDChars, IDWidth)).append(" = ").append(this.m_ClassNames[i]).append("\n");
        }
        return text.toString();
    }

    public String toClassDetailsString() throws Exception {
        return this.toClassDetailsString("=== Detailed Accuracy By Class ===\n");
    }

    /*
     * WARNING - void declaration
     */
    public String toClassDetailsString(String title) throws Exception {
        List<String> statNames;
        String metricName;
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No per class statistics possible!");
        }
        boolean displayTP = this.m_metricsToDisplay.contains("tp rate");
        boolean displayFP = this.m_metricsToDisplay.contains("fp rate");
        boolean displayP = this.m_metricsToDisplay.contains("precision");
        boolean displayR = this.m_metricsToDisplay.contains("recall");
        boolean displayFM = this.m_metricsToDisplay.contains("f-measure");
        boolean displayMCC = this.m_metricsToDisplay.contains("mcc");
        boolean displayROC = this.m_metricsToDisplay.contains("roc area");
        boolean displayPRC = this.m_metricsToDisplay.contains("prc area");
        StringBuffer text = new StringBuffer(title + "\n                 " + (displayTP ? "TP Rate  " : "") + (displayFP ? "FP Rate  " : "") + (displayP ? "Precision  " : "") + (displayR ? "Recall   " : "") + (displayFM ? "F-Measure  " : "") + (displayMCC ? "MCC      " : "") + (displayROC ? "ROC Area  " : "") + (displayPRC ? "PRC Area  " : ""));
        if (this.m_pluginMetrics != null && this.m_pluginMetrics.size() > 0) {
            for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                if (!(m instanceof InformationRetrievalEvaluationMetric) || !m.appliesToNominalClass() || !this.m_metricsToDisplay.contains(metricName = m.getMetricName().toLowerCase())) continue;
                statNames = m.getStatisticNames();
                for (String string : statNames) {
                    void var16_36;
                    if (!this.m_metricsToDisplay.contains(string.toLowerCase())) continue;
                    if (string.length() < 7) {
                        String string2 = Utils.padRight(string, 7);
                    }
                    text.append((String)var16_36).append("  ");
                }
            }
        }
        text.append("Class\n");
        for (int i = 0; i < this.m_NumClasses; ++i) {
            text.append("                 ");
            if (displayTP) {
                double tpr = this.truePositiveRate(i);
                if (Utils.isMissingValue(tpr)) {
                    text.append("?        ");
                } else {
                    text.append(String.format("%-9.3f", tpr));
                }
            }
            if (displayFP) {
                double fpr = this.falsePositiveRate(i);
                if (Utils.isMissingValue(fpr)) {
                    text.append("?        ");
                } else {
                    text.append(String.format("%-9.3f", fpr));
                }
            }
            if (displayP) {
                double p = this.precision(i);
                if (Utils.isMissingValue(p)) {
                    text.append("?          ");
                } else {
                    text.append(String.format("%-11.3f", this.precision(i)));
                }
            }
            if (displayR) {
                double r = this.recall(i);
                if (Utils.isMissingValue(r)) {
                    text.append("?        ");
                } else {
                    text.append(String.format("%-9.3f", this.recall(i)));
                }
            }
            if (displayFM) {
                double fm = this.fMeasure(i);
                if (Utils.isMissingValue(fm)) {
                    text.append("?          ");
                } else {
                    text.append(String.format("%-11.3f", this.fMeasure(i)));
                }
            }
            if (displayMCC) {
                double mat = this.matthewsCorrelationCoefficient(i);
                if (Utils.isMissingValue(mat)) {
                    text.append("?        ");
                } else {
                    text.append(String.format("%-9.3f", this.matthewsCorrelationCoefficient(i)));
                }
            }
            if (displayROC) {
                double rocVal = this.areaUnderROC(i);
                if (Utils.isMissingValue(rocVal)) {
                    text.append("?         ");
                } else {
                    text.append(String.format("%-10.3f", rocVal));
                }
            }
            if (displayPRC) {
                double prcVal = this.areaUnderPRC(i);
                if (Utils.isMissingValue(prcVal)) {
                    text.append("?         ");
                } else {
                    text.append(String.format("%-10.3f", prcVal));
                }
            }
            if (this.m_pluginMetrics != null && this.m_pluginMetrics.size() > 0) {
                for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                    String metricName2;
                    if (!(m instanceof InformationRetrievalEvaluationMetric) || !m.appliesToNominalClass() || !this.m_metricsToDisplay.contains(metricName2 = m.getMetricName().toLowerCase())) continue;
                    List<String> statNames2 = m.getStatisticNames();
                    for (String name : statNames2) {
                        if (!this.m_metricsToDisplay.contains(name.toLowerCase())) continue;
                        double stat = ((InformationRetrievalEvaluationMetric)((Object)m)).getStatistic(name, i);
                        if (name.length() < 7) {
                            name = Utils.padRight(name, 7);
                        }
                        if (Utils.isMissingValue(stat)) {
                            Utils.padRight("?", name.length());
                            continue;
                        }
                        text.append(String.format("%-" + name.length() + ".3f", stat)).append("  ");
                    }
                }
            }
            text.append(this.m_ClassNames[i]).append('\n');
        }
        text.append("Weighted Avg.    ");
        if (displayTP) {
            double wtpr = this.weightedTruePositiveRate();
            if (Utils.isMissingValue(wtpr)) {
                text.append("?        ");
            } else {
                text.append(String.format("%-9.3f", wtpr));
            }
        }
        if (displayFP) {
            double wfpr = this.weightedFalsePositiveRate();
            if (Utils.isMissingValue(wfpr)) {
                text.append("?        ");
            } else {
                text.append(String.format("%-9.3f", wfpr));
            }
        }
        if (displayP) {
            double wp = this.weightedPrecision();
            if (Utils.isMissingValue(wp)) {
                text.append("?          ");
            } else {
                text.append(String.format("%-11.3f", wp));
            }
        }
        if (displayR) {
            double wr = this.weightedRecall();
            if (Utils.isMissingValue(wr)) {
                text.append("?        ");
            } else {
                text.append(String.format("%-9.3f", wr));
            }
        }
        if (displayFM) {
            double wf = this.weightedFMeasure();
            if (Utils.isMissingValue(wf)) {
                text.append("?          ");
            } else {
                text.append(String.format("%-11.3f", wf));
            }
        }
        if (displayMCC) {
            double wmc = this.weightedMatthewsCorrelation();
            if (Utils.isMissingValue(wmc)) {
                text.append("?        ");
            } else {
                text.append(String.format("%-9.3f", wmc));
            }
        }
        if (displayROC) {
            double wroc = this.weightedAreaUnderROC();
            if (Utils.isMissingValue(wroc)) {
                text.append("?         ");
            } else {
                text.append(String.format("%-10.3f", wroc));
            }
        }
        if (displayPRC) {
            double wprc = this.weightedAreaUnderPRC();
            if (Utils.isMissingValue(wprc)) {
                text.append("?         ");
            } else {
                text.append(String.format("%-10.3f", wprc));
            }
        }
        if (this.m_pluginMetrics != null && this.m_pluginMetrics.size() > 0) {
            for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                if (!(m instanceof InformationRetrievalEvaluationMetric) || !m.appliesToNominalClass() || !this.m_metricsToDisplay.contains(metricName = m.getMetricName().toLowerCase())) continue;
                statNames = m.getStatisticNames();
                for (String string : statNames) {
                    void var16_44;
                    if (!this.m_metricsToDisplay.contains(string.toLowerCase())) continue;
                    double stat = ((InformationRetrievalEvaluationMetric)((Object)m)).getClassWeightedAverageStatistic(string);
                    if (string.length() < 7) {
                        String string3 = Utils.padRight(string, 7);
                    }
                    if (Utils.isMissingValue(stat)) {
                        Utils.padRight("?", var16_44.length());
                        continue;
                    }
                    text.append(String.format("%-" + var16_44.length() + ".3f", stat)).append("  ");
                }
            }
        }
        text.append("\n");
        return text.toString();
    }

    public double numTruePositives(int classIndex) {
        double correct = 0.0;
        for (int j = 0; j < this.m_NumClasses; ++j) {
            if (j != classIndex) continue;
            correct += this.m_ConfusionMatrix[classIndex][j];
        }
        return correct;
    }

    public double truePositiveRate(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        for (int j = 0; j < this.m_NumClasses; ++j) {
            if (j == classIndex) {
                correct += this.m_ConfusionMatrix[classIndex][j];
            }
            total += this.m_ConfusionMatrix[classIndex][j];
        }
        return correct / total;
    }

    public double weightedTruePositiveRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double truePosTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.truePositiveRate(i);
            if (!(classCounts[i] > 0.0)) continue;
            truePosTotal += temp * classCounts[i];
        }
        return truePosTotal / classCountSum;
    }

    public double numTrueNegatives(int classIndex) {
        double correct = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == classIndex) continue;
                correct += this.m_ConfusionMatrix[i][j];
            }
        }
        return correct;
    }

    public double trueNegativeRate(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != classIndex) {
                    correct += this.m_ConfusionMatrix[i][j];
                }
                total += this.m_ConfusionMatrix[i][j];
            }
        }
        return correct / total;
    }

    public double weightedTrueNegativeRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double trueNegTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.trueNegativeRate(i);
            if (!(classCounts[i] > 0.0)) continue;
            trueNegTotal += temp * classCounts[i];
        }
        return trueNegTotal / classCountSum;
    }

    public double numFalsePositives(int classIndex) {
        double incorrect = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != classIndex) continue;
                incorrect += this.m_ConfusionMatrix[i][j];
            }
        }
        return incorrect;
    }

    public double falsePositiveRate(int classIndex) {
        double incorrect = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == classIndex) {
                    incorrect += this.m_ConfusionMatrix[i][j];
                }
                total += this.m_ConfusionMatrix[i][j];
            }
        }
        return incorrect / total;
    }

    public double weightedFalsePositiveRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double falsePosTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.falsePositiveRate(i);
            if (!(classCounts[i] > 0.0)) continue;
            falsePosTotal += temp * classCounts[i];
        }
        return falsePosTotal / classCountSum;
    }

    public double numFalseNegatives(int classIndex) {
        double incorrect = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == classIndex) continue;
                incorrect += this.m_ConfusionMatrix[i][j];
            }
        }
        return incorrect;
    }

    public double falseNegativeRate(int classIndex) {
        double incorrect = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != classIndex) {
                    incorrect += this.m_ConfusionMatrix[i][j];
                }
                total += this.m_ConfusionMatrix[i][j];
            }
        }
        return incorrect / total;
    }

    public double weightedFalseNegativeRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double falseNegTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.falseNegativeRate(i);
            if (!(classCounts[i] > 0.0)) continue;
            falseNegTotal += temp * classCounts[i];
        }
        return falseNegTotal / classCountSum;
    }

    public double matthewsCorrelationCoefficient(int classIndex) {
        double numTP = this.numTruePositives(classIndex);
        double numTN = this.numTrueNegatives(classIndex);
        double numFP = this.numFalsePositives(classIndex);
        double numFN = this.numFalseNegatives(classIndex);
        double n = numTP * numTN - numFP * numFN;
        double d = (numTP + numFP) * (numTP + numFN) * (numTN + numFP) * (numTN + numFN);
        d = Math.sqrt(d);
        return n / d;
    }

    public double weightedMatthewsCorrelation() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double mccTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.matthewsCorrelationCoefficient(i);
            if (!(classCounts[i] > 0.0)) continue;
            mccTotal += temp * classCounts[i];
        }
        return mccTotal / classCountSum;
    }

    public double recall(int classIndex) {
        return this.truePositiveRate(classIndex);
    }

    public double weightedRecall() {
        return this.weightedTruePositiveRate();
    }

    public double precision(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) {
                correct += this.m_ConfusionMatrix[i][classIndex];
            }
            total += this.m_ConfusionMatrix[i][classIndex];
        }
        return correct / total;
    }

    public double weightedPrecision() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double precisionTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.precision(i);
            if (!(classCounts[i] > 0.0)) continue;
            precisionTotal += temp * classCounts[i];
        }
        return precisionTotal / classCountSum;
    }

    public double fMeasure(int classIndex) {
        double precision = this.precision(classIndex);
        double recall = this.recall(classIndex);
        if (precision == 0.0 && recall == 0.0) {
            return 0.0;
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    public double weightedFMeasure() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
            }
            classCountSum += classCounts[i];
        }
        double fMeasureTotal = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double temp = this.fMeasure(i);
            if (!(classCounts[i] > 0.0)) continue;
            fMeasureTotal += temp * classCounts[i];
        }
        return fMeasureTotal / classCountSum;
    }

    public double unweightedMacroFmeasure() {
        Stats rr = new Stats();
        for (int c = 0; c < this.m_NumClasses; ++c) {
            if (!(this.numTruePositives(c) + this.numFalseNegatives(c) > 0.0)) continue;
            rr.add(this.fMeasure(c));
        }
        rr.calculateDerived();
        return rr.mean;
    }

    public double unweightedMicroFmeasure() {
        double tp = 0.0;
        double fn = 0.0;
        double fp = 0.0;
        for (int c = 0; c < this.m_NumClasses; ++c) {
            tp += this.numTruePositives(c);
            fn += this.numFalseNegatives(c);
            fp += this.numFalsePositives(c);
        }
        return 2.0 * tp / (2.0 * tp + fn + fp);
    }

    public void setPriors(Instances train) throws Exception {
        this.m_NoPriors = false;
        if (!this.m_ClassIsNominal) {
            int i;
            this.m_NumTrainClassVals = 0;
            this.m_TrainClassVals = null;
            this.m_TrainClassWeights = null;
            this.m_PriorEstimator = null;
            this.m_MinTarget = Double.MAX_VALUE;
            this.m_MaxTarget = -1.7976931348623157E308;
            for (i = 0; i < train.numInstances(); ++i) {
                Instance currentInst = train.instance(i);
                if (currentInst.classIsMissing()) continue;
                this.addNumericTrainClass(currentInst.classValue(), currentInst.weight());
            }
            this.m_ClassPriorsSum = 0.0;
            this.m_ClassPriors[0] = 0.0;
            for (i = 0; i < train.numInstances(); ++i) {
                if (train.instance(i).classIsMissing()) continue;
                this.m_ClassPriors[0] = this.m_ClassPriors[0] + train.instance(i).classValue() * train.instance(i).weight();
                this.m_ClassPriorsSum += train.instance(i).weight();
            }
        } else {
            int i;
            for (i = 0; i < this.m_NumClasses; ++i) {
                this.m_ClassPriors[i] = 1.0;
            }
            this.m_ClassPriorsSum = this.m_NumClasses;
            for (i = 0; i < train.numInstances(); ++i) {
                if (train.instance(i).classIsMissing()) continue;
                int n = (int)train.instance(i).classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + train.instance(i).weight();
                this.m_ClassPriorsSum += train.instance(i).weight();
            }
            this.m_MaxTarget = this.m_NumClasses;
            this.m_MinTarget = 0.0;
        }
    }

    public double[] getClassPriors() {
        return this.m_ClassPriors;
    }

    public void updatePriors(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (!this.m_ClassIsNominal) {
                this.addNumericTrainClass(instance.classValue(), instance.weight());
                this.m_ClassPriors[0] = this.m_ClassPriors[0] + instance.classValue() * instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            } else {
                int n = (int)instance.classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            }
        }
    }

    public void useNoPriors() {
        this.m_NoPriors = true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Evaluation cmp = (Evaluation)obj;
        if (this.m_ClassIsNominal != cmp.m_ClassIsNominal) {
            return false;
        }
        if (this.m_NumClasses != cmp.m_NumClasses) {
            return false;
        }
        if (this.m_Incorrect != cmp.m_Incorrect) {
            return false;
        }
        if (this.m_Correct != cmp.m_Correct) {
            return false;
        }
        if (this.m_Unclassified != cmp.m_Unclassified) {
            return false;
        }
        if (this.m_MissingClass != cmp.m_MissingClass) {
            return false;
        }
        if (this.m_WithClass != cmp.m_WithClass) {
            return false;
        }
        if (this.m_SumErr != cmp.m_SumErr) {
            return false;
        }
        if (this.m_SumAbsErr != cmp.m_SumAbsErr) {
            return false;
        }
        if (this.m_SumSqrErr != cmp.m_SumSqrErr) {
            return false;
        }
        if (this.m_SumClass != cmp.m_SumClass) {
            return false;
        }
        if (this.m_SumSqrClass != cmp.m_SumSqrClass) {
            return false;
        }
        if (this.m_SumPredicted != cmp.m_SumPredicted) {
            return false;
        }
        if (this.m_SumSqrPredicted != cmp.m_SumSqrPredicted) {
            return false;
        }
        if (this.m_SumClassPredicted != cmp.m_SumClassPredicted) {
            return false;
        }
        if (this.m_ClassIsNominal) {
            for (int i = 0; i < this.m_NumClasses; ++i) {
                for (int j = 0; j < this.m_NumClasses; ++j) {
                    if (this.m_ConfusionMatrix[i][j] == cmp.m_ConfusionMatrix[i][j]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static String makeOptionString(Classifier classifier, boolean globalInfo) {
        StringBuffer optionsText = new StringBuffer("");
        optionsText.append("\n\nGeneral options:\n\n");
        optionsText.append("-h or -help\n");
        optionsText.append("\tOutput help information.\n");
        optionsText.append("-synopsis or -info\n");
        optionsText.append("\tOutput synopsis for classifier (use in conjunction  with -h)\n");
        optionsText.append("-t <name of training file>\n");
        optionsText.append("\tSets training file.\n");
        optionsText.append("-T <name of test file>\n");
        optionsText.append("\tSets test file. If missing, a cross-validation will be performed\n");
        optionsText.append("\ton the training data.\n");
        optionsText.append("-c <class index>\n");
        optionsText.append("\tSets index of class attribute (default: last).\n");
        optionsText.append("-x <number of folds>\n");
        optionsText.append("\tSets number of folds for cross-validation (default: 10).\n");
        optionsText.append("-no-cv\n");
        optionsText.append("\tDo not perform any cross validation.\n");
        optionsText.append("-force-batch-training\n");
        optionsText.append("\tAlways train classifier in batch mode, never incrementally.\n");
        optionsText.append("-split-percentage <percentage>\n");
        optionsText.append("\tSets the percentage for the train/test set split, e.g., 66.\n");
        optionsText.append("-preserve-order\n");
        optionsText.append("\tPreserves the order in the percentage split.\n");
        optionsText.append("-s <random number seed>\n");
        optionsText.append("\tSets random number seed for cross-validation or percentage split\n");
        optionsText.append("\t(default: 1).\n");
        optionsText.append("-m <name of file with cost matrix>\n");
        optionsText.append("\tSets file with cost matrix.\n");
        optionsText.append("-toggle <comma-separated list of evaluation metric names>\n");
        optionsText.append("\tComma separated list of metric names to toggle in the output.\n\tAll metrics are output by default with the exception of 'Coverage' and 'Region size'.\n\t");
        optionsText.append("Available metrics:\n\t");
        ArrayList<String> metricsToDisplay = new ArrayList<String>(Arrays.asList(BUILT_IN_EVAL_METRICS));
        ArrayList<AbstractEvaluationMetric> pluginMetrics = AbstractEvaluationMetric.getPluginMetrics();
        if (pluginMetrics != null) {
            for (AbstractEvaluationMetric m : pluginMetrics) {
                if (m instanceof InformationRetrievalEvaluationMetric) {
                    List<String> statNames = m.getStatisticNames();
                    for (String s : statNames) {
                        metricsToDisplay.add(s.toLowerCase());
                    }
                    continue;
                }
                metricsToDisplay.add(m.getMetricName().toLowerCase());
            }
        }
        int length = 0;
        for (int i = 0; i < metricsToDisplay.size(); ++i) {
            optionsText.append((String)metricsToDisplay.get(i));
            length += ((String)metricsToDisplay.get(i)).length();
            if (i != metricsToDisplay.size() - 1) {
                optionsText.append(",");
            }
            if (length < 60) continue;
            optionsText.append("\n\t");
            length = 0;
        }
        optionsText.append("\n");
        optionsText.append("-l <name of input file>\n");
        optionsText.append("\tSets model input file. In case the filename ends with '.xml',\n");
        optionsText.append("\ta PMML file is loaded or, if that fails, options are loaded\n");
        optionsText.append("\tfrom the XML file.\n");
        optionsText.append("-d <name of output file>\n");
        optionsText.append("\tSets model output file. In case the filename ends with '.xml',\n");
        optionsText.append("\tonly the options are saved to the XML file, not the model.\n");
        optionsText.append("-v\n");
        optionsText.append("\tOutputs no statistics for training data.\n");
        optionsText.append("-o\n");
        optionsText.append("\tOutputs statistics only, not the classifier.\n");
        optionsText.append("-output-models-for-training-splits\n");
        optionsText.append("\tOutput models for training splits if cross-validation or percentage-split evaluation is used.\n");
        optionsText.append("-do-not-output-per-class-statistics\n");
        optionsText.append("\tDo not output statistics for each class.\n");
        optionsText.append("-k\n");
        optionsText.append("\tOutputs information-theoretic statistics.\n");
        optionsText.append("-classifications \"weka.classifiers.evaluation.output.prediction.AbstractOutput + options\"\n");
        optionsText.append("\tUses the specified class for generating the classification output.\n");
        optionsText.append("\tE.g.: " + PlainText.class.getName() + "\n");
        optionsText.append("-p range\n");
        optionsText.append("\tOutputs predictions for test instances (or the train instances if\n");
        optionsText.append("\tno test instances provided and -no-cv is used), along with the \n");
        optionsText.append("\tattributes in the specified range (and nothing else). \n");
        optionsText.append("\tUse '-p 0' if no attributes are desired.\n");
        optionsText.append("\tDeprecated: use \"-classifications ...\" instead.\n");
        optionsText.append("-distribution\n");
        optionsText.append("\tOutputs the distribution instead of only the prediction\n");
        optionsText.append("\tin conjunction with the '-p' option (only nominal classes).\n");
        optionsText.append("\tDeprecated: use \"-classifications ...\" instead.\n");
        optionsText.append("-r\n");
        optionsText.append("\tOnly outputs cumulative margin distribution.\n");
        if (classifier instanceof Sourcable) {
            optionsText.append("-z <class name>\n");
            optionsText.append("\tOnly outputs the source representation of the classifier,\n\tgiving it the supplied name.\n");
        }
        if (classifier instanceof Drawable) {
            optionsText.append("-g\n");
            optionsText.append("\tOnly outputs the graph representation of the classifier.\n");
        }
        optionsText.append("-xml filename | xml-string\n");
        optionsText.append("\tRetrieves the options from the XML-data instead of the command line.\n");
        optionsText.append("-threshold-file <file>\n");
        optionsText.append("\tThe file to save the threshold data to.\n\tThe format is determined by the extensions, e.g., '.arff' for ARFF \n\tformat or '.csv' for CSV.\n");
        optionsText.append("-threshold-label <label>\n");
        optionsText.append("\tThe class label to determine the threshold data for\n\t(default is the first label)\n");
        optionsText.append("-no-predictions\n");
        optionsText.append("\tTurns off the collection of predictions in order to conserve memory.\n");
        if (classifier instanceof OptionHandler) {
            optionsText.append("\nOptions specific to " + classifier.getClass().getName() + ":\n\n");
            Enumeration<Option> enu = ((OptionHandler)((Object)classifier)).listOptions();
            while (enu.hasMoreElements()) {
                Option option = enu.nextElement();
                optionsText.append(option.synopsis() + '\n');
                optionsText.append(option.description() + "\n");
            }
        }
        if (globalInfo) {
            try {
                String gi = Evaluation.getGlobalInfo(classifier);
                optionsText.append(gi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return optionsText.toString();
    }

    protected static String getGlobalInfo(Classifier classifier) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(classifier.getClass());
        MethodDescriptor[] methods = bi.getMethodDescriptors();
        Object[] args = new Object[]{};
        String result = "\nSynopsis for " + classifier.getClass().getName() + ":\n\n";
        for (MethodDescriptor method : methods) {
            String name = method.getDisplayName();
            Method meth = method.getMethod();
            if (!name.equals("globalInfo")) continue;
            String globalInfo = (String)meth.invoke((Object)classifier, args);
            result = result + globalInfo;
            break;
        }
        return result;
    }

    protected String num2ShortID(int num, char[] IDChars, int IDWidth) {
        int i;
        char[] ID = new char[IDWidth];
        for (i = IDWidth - 1; i >= 0; --i) {
            ID[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
        }
        --i;
        while (i >= 0) {
            ID[i] = 32;
            --i;
        }
        return new String(ID);
    }

    protected double[] makeDistribution(double predictedClass) {
        double[] result = new double[this.m_NumClasses];
        if (Utils.isMissingValue(predictedClass)) {
            return result;
        }
        if (this.m_ClassIsNominal) {
            result[(int)predictedClass] = 1.0;
        } else {
            result[0] = predictedClass;
        }
        return result;
    }

    protected void updateStatsForClassifier(double[] predictedDistribution, Instance instance) throws Exception {
        int actualClass = (int)instance.classValue();
        if (!instance.classIsMissing()) {
            double priorProb;
            this.updateMargins(predictedDistribution, actualClass, instance.weight());
            int predictedClass = -1;
            double bestProb = 0.0;
            for (int i = 0; i < this.m_NumClasses; ++i) {
                if (!(predictedDistribution[i] > bestProb)) continue;
                predictedClass = i;
                bestProb = predictedDistribution[i];
            }
            this.m_WithClass += instance.weight();
            if (this.m_CostMatrix != null) {
                this.m_TotalCost = predictedClass < 0 ? (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getMaxCost(actualClass, instance)) : (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getElement(actualClass, predictedClass, instance));
            }
            if (predictedClass < 0) {
                this.m_Unclassified += instance.weight();
                return;
            }
            double predictedProb = Math.max(Double.MIN_VALUE, predictedDistribution[actualClass]);
            this.m_SumKBInfo = predictedProb >= (priorProb = Math.max(Double.MIN_VALUE, this.m_ClassPriors[actualClass] / this.m_ClassPriorsSum)) ? (this.m_SumKBInfo += (Utils.log2(predictedProb) - Utils.log2(priorProb)) * instance.weight()) : (this.m_SumKBInfo -= (Utils.log2(1.0 - predictedProb) - Utils.log2(1.0 - priorProb)) * instance.weight());
            this.m_SumSchemeEntropy -= Utils.log2(predictedProb) * instance.weight();
            this.m_SumPriorEntropy -= Utils.log2(priorProb) * instance.weight();
            this.updateNumericScores(predictedDistribution, this.makeDistribution(instance.classValue()), instance.weight());
            int[] indices = Utils.stableSort(predictedDistribution);
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            double sum = 0.0;
            double sizeOfRegions = 0.0;
            for (int i = predictedDistribution.length - 1; i >= 0 && !(sum >= this.m_ConfLevel); --i) {
                sum += predictedDistribution[indices[i]];
                sizeOfRegions += 1.0;
                if (actualClass != indices[i]) continue;
                this.m_TotalCoverage += instance.weight();
            }
            this.m_TotalSizeOfRegions += instance.weight() * sizeOfRegions / (this.m_MaxTarget - this.m_MinTarget);
            double[] dArray = this.m_ConfusionMatrix[actualClass];
            int n = predictedClass;
            dArray[n] = dArray[n] + instance.weight();
            if (predictedClass != actualClass) {
                this.m_Incorrect += instance.weight();
            } else {
                this.m_Correct += instance.weight();
            }
        } else {
            this.m_MissingClass += instance.weight();
        }
        if (this.m_pluginMetrics != null) {
            for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                if (m instanceof StandardEvaluationMetric) {
                    ((StandardEvaluationMetric)((Object)m)).updateStatsForClassifier(predictedDistribution, instance);
                    continue;
                }
                if (m instanceof InformationRetrievalEvaluationMetric) {
                    ((InformationRetrievalEvaluationMetric)((Object)m)).updateStatsForClassifier(predictedDistribution, instance);
                    continue;
                }
                if (!(m instanceof InformationTheoreticEvaluationMetric)) continue;
                ((InformationTheoreticEvaluationMetric)((Object)m)).updateStatsForClassifier(predictedDistribution, instance);
            }
        }
    }

    protected void updateStatsForIntervalEstimator(IntervalEstimator classifier, Instance classMissing, double classValue) throws Exception {
        double[][] preds = classifier.predictIntervals(classMissing, this.m_ConfLevel);
        if (this.m_Predictions != null) {
            ((NumericPrediction)this.m_Predictions.get(this.m_Predictions.size() - 1)).setPredictionIntervals(preds);
        }
        for (double[] pred : preds) {
            this.m_TotalSizeOfRegions += classMissing.weight() * (pred[1] - pred[0]) / (this.m_MaxTarget - this.m_MinTarget);
        }
        for (double[] pred : preds) {
            if (!(pred[1] >= classValue) || !(pred[0] <= classValue)) continue;
            this.m_TotalCoverage += classMissing.weight();
            break;
        }
        if (this.m_pluginMetrics != null) {
            Object object = this.m_pluginMetrics.iterator();
            while (object.hasNext()) {
                AbstractEvaluationMetric m = (AbstractEvaluationMetric)object.next();
                if (!(m instanceof IntervalBasedEvaluationMetric)) continue;
                ((IntervalBasedEvaluationMetric)((Object)m)).updateStatsForIntervalEstimator(classifier, classMissing, classValue);
            }
        }
    }

    protected void updateStatsForConditionalDensityEstimator(ConditionalDensityEstimator classifier, Instance classMissing, double classValue) throws Exception {
        if (this.m_PriorEstimator == null) {
            this.setNumericPriorsFromBuffer();
        }
        this.m_SumSchemeEntropy -= classifier.logDensity(classMissing, classValue) * classMissing.weight() / Utils.log2;
        this.m_SumPriorEntropy -= this.m_PriorEstimator.logDensity(classValue) * classMissing.weight() / Utils.log2;
    }

    protected void updateStatsForPredictor(double predictedValue, Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.m_WithClass += instance.weight();
            if (Utils.isMissingValue(predictedValue)) {
                this.m_Unclassified += instance.weight();
                return;
            }
            this.m_SumClass += instance.weight() * instance.classValue();
            this.m_SumSqrClass += instance.weight() * instance.classValue() * instance.classValue();
            this.m_SumClassPredicted += instance.weight() * instance.classValue() * predictedValue;
            this.m_SumPredicted += instance.weight() * predictedValue;
            this.m_SumSqrPredicted += instance.weight() * predictedValue * predictedValue;
            this.updateNumericScores(this.makeDistribution(predictedValue), this.makeDistribution(instance.classValue()), instance.weight());
        } else {
            this.m_MissingClass += instance.weight();
        }
        if (this.m_pluginMetrics != null) {
            for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
                if (m instanceof StandardEvaluationMetric) {
                    ((StandardEvaluationMetric)((Object)m)).updateStatsForPredictor(predictedValue, instance);
                    continue;
                }
                if (!(m instanceof InformationTheoreticEvaluationMetric)) continue;
                ((InformationTheoreticEvaluationMetric)((Object)m)).updateStatsForPredictor(predictedValue, instance);
            }
        }
    }

    protected void updateMargins(double[] predictedDistribution, int actualClass, double weight) {
        int bin;
        double probActual = predictedDistribution[actualClass];
        double probNext = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == actualClass || !(predictedDistribution[i] > probNext)) continue;
            probNext = predictedDistribution[i];
        }
        double margin = probActual - probNext;
        int n = bin = (int)((margin + 1.0) / 2.0 * (double)k_MarginResolution);
        this.m_MarginCounts[n] = this.m_MarginCounts[n] + weight;
    }

    protected void updateNumericScores(double[] predicted, double[] actual, double weight) {
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumSqrErr = 0.0;
        double sumPriorAbsErr = 0.0;
        double sumPriorSqrErr = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double diff = predicted[i] - actual[i];
            sumErr += diff;
            sumAbsErr += Math.abs(diff);
            sumSqrErr += diff * diff;
            diff = this.m_ClassPriors[i] / this.m_ClassPriorsSum - actual[i];
            sumPriorAbsErr += Math.abs(diff);
            sumPriorSqrErr += diff * diff;
        }
        this.m_SumErr += weight * sumErr / (double)this.m_NumClasses;
        this.m_SumAbsErr += weight * sumAbsErr / (double)this.m_NumClasses;
        this.m_SumSqrErr += weight * sumSqrErr / (double)this.m_NumClasses;
        this.m_SumPriorAbsErr += weight * sumPriorAbsErr / (double)this.m_NumClasses;
        this.m_SumPriorSqrErr += weight * sumPriorSqrErr / (double)this.m_NumClasses;
    }

    protected void addNumericTrainClass(double classValue, double weight) {
        if (classValue > this.m_MaxTarget) {
            this.m_MaxTarget = classValue;
        }
        if (classValue < this.m_MinTarget) {
            this.m_MinTarget = classValue;
        }
        if (this.m_TrainClassVals == null) {
            this.m_TrainClassVals = new double[100];
            this.m_TrainClassWeights = new double[100];
        }
        if (this.m_NumTrainClassVals == this.m_TrainClassVals.length) {
            double[] temp = new double[this.m_TrainClassVals.length * 2];
            System.arraycopy(this.m_TrainClassVals, 0, temp, 0, this.m_TrainClassVals.length);
            this.m_TrainClassVals = temp;
            temp = new double[this.m_TrainClassWeights.length * 2];
            System.arraycopy(this.m_TrainClassWeights, 0, temp, 0, this.m_TrainClassWeights.length);
            this.m_TrainClassWeights = temp;
        }
        this.m_TrainClassVals[this.m_NumTrainClassVals] = classValue;
        this.m_TrainClassWeights[this.m_NumTrainClassVals] = weight;
        ++this.m_NumTrainClassVals;
    }

    protected void setNumericPriorsFromBuffer() {
        this.m_PriorEstimator = new UnivariateKernelEstimator();
        for (int i = 0; i < this.m_NumTrainClassVals; ++i) {
            this.m_PriorEstimator.addValue(this.m_TrainClassVals[i], this.m_TrainClassWeights[i]);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

