/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.lazy.kstar.KStarCache;
import weka.classifiers.lazy.kstar.KStarConstants;
import weka.classifiers.lazy.kstar.KStarNominalAttribute;
import weka.classifiers.lazy.kstar.KStarNumericAttribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class KStar
extends AbstractClassifier
implements KStarConstants,
UpdateableClassifier,
TechnicalInformationHandler {
    static final long serialVersionUID = 332458330800479083L;
    protected Instances m_Train;
    protected int m_NumInstances;
    protected int m_NumClasses;
    protected int m_NumAttributes;
    protected int m_ClassType;
    protected int[][] m_RandClassCols;
    protected int m_ComputeRandomCols = 1;
    protected int m_InitFlag = 1;
    protected KStarCache[] m_Cache;
    protected int m_MissingMode = 4;
    protected int m_BlendMethod = 1;
    protected int m_GlobalBlend = 20;
    public static final Tag[] TAGS_MISSING = new Tag[]{new Tag(1, "Ignore the instances with missing values"), new Tag(2, "Treat missing values as maximally different"), new Tag(3, "Normalize over the attributes"), new Tag(4, "Average column entropy curves")};

    public String globalInfo() {
        return "K* is an instance-based classifier, that is the class of a test instance is based upon the class of those training instances similar to it, as determined by some similarity function.  It differs from other instance-based learners in that it uses an entropy-based distance function.\n\nFor more information on K*, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "John G. Cleary and Leonard E. Trigg");
        result.setValue(TechnicalInformation.Field.TITLE, "K*: An Instance-based Learner Using an Entropic Distance Measure");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "12th International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.PAGES, "108-114");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Train = new Instances(instances, 0, instances.numInstances());
        this.init_m_Attributes();
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception("Incompatible instance types\n" + this.m_Train.equalHeadersMsg(instance.dataset()));
        }
        if (instance.classIsMissing()) {
            return;
        }
        this.m_Train.add(instance);
        this.update_m_Attributes();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        double transProb = 0.0;
        double temp = 0.0;
        double[] classProbability = new double[this.m_NumClasses];
        double[] predictedValue = new double[1];
        for (i = 0; i < classProbability.length; ++i) {
            classProbability[i] = 0.0;
        }
        predictedValue[0] = 0.0;
        if (this.m_InitFlag == 1) {
            if (this.m_BlendMethod == 2) {
                this.generateRandomClassColomns();
            }
            this.m_Cache = new KStarCache[this.m_NumAttributes];
            for (i = 0; i < this.m_NumAttributes; ++i) {
                this.m_Cache[i] = new KStarCache();
            }
            this.m_InitFlag = 0;
        }
        Enumeration<Instance> enu = this.m_Train.enumerateInstances();
        while (enu.hasMoreElements()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            Instance trainInstance = enu.nextElement();
            transProb = this.instanceTransformationProbability(instance, trainInstance);
            switch (this.m_ClassType) {
                case 1: {
                    int n = (int)trainInstance.classValue();
                    classProbability[n] = classProbability[n] + transProb;
                    break;
                }
                case 0: {
                    predictedValue[0] = predictedValue[0] + transProb * trainInstance.classValue();
                    temp += transProb;
                }
            }
        }
        if (this.m_ClassType == 1) {
            double sum = Utils.sum(classProbability);
            if (sum <= 0.0) {
                for (int i2 = 0; i2 < classProbability.length; ++i2) {
                    classProbability[i2] = 1.0 / (double)this.m_NumClasses;
                }
            } else {
                Utils.normalize(classProbability, sum);
            }
            return classProbability;
        }
        predictedValue[0] = temp != 0.0 ? predictedValue[0] / temp : 0.0;
        return predictedValue;
    }

    private double instanceTransformationProbability(Instance first, Instance second) throws InterruptedException {
        double transProb = 1.0;
        int numMissAttr = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Killed WEKA!");
            }
            if (i == this.m_Train.classIndex()) continue;
            if (first.isMissing(i)) {
                ++numMissAttr;
                continue;
            }
            transProb *= this.attrTransProb(first, second, i);
            transProb = numMissAttr != this.m_NumAttributes ? Math.pow(transProb, (double)this.m_NumAttributes / (double)(this.m_NumAttributes - numMissAttr)) : 0.0;
        }
        return transProb / (double)this.m_NumInstances;
    }

    private double attrTransProb(Instance first, Instance second, int col) throws InterruptedException {
        double transProb = 0.0;
        switch (this.m_Train.attribute(col).type()) {
            case 1: {
                KStarNominalAttribute ksNominalAttr = new KStarNominalAttribute(first, second, col, this.m_Train, this.m_RandClassCols, this.m_Cache[col]);
                ksNominalAttr.setOptions(this.m_MissingMode, this.m_BlendMethod, this.m_GlobalBlend);
                transProb = ksNominalAttr.transProb();
                ksNominalAttr = null;
                break;
            }
            case 0: {
                KStarNumericAttribute ksNumericAttr = new KStarNumericAttribute(first, second, col, this.m_Train, this.m_RandClassCols, this.m_Cache[col]);
                ksNumericAttr.setOptions(this.m_MissingMode, this.m_BlendMethod, this.m_GlobalBlend);
                transProb = ksNumericAttr.transProb();
                ksNumericAttr = null;
            }
        }
        return transProb;
    }

    public String missingModeTipText() {
        return "Determines how missing attribute values are treated.";
    }

    public SelectedTag getMissingMode() {
        return new SelectedTag(this.m_MissingMode, TAGS_MISSING);
    }

    public void setMissingMode(SelectedTag newMode) {
        if (newMode.getTags() == TAGS_MISSING) {
            this.m_MissingMode = newMode.getSelectedTag().getID();
        }
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> optVector = new Vector<Option>(3);
        optVector.addElement(new Option("\tManual blend setting (default 20%)\n", "B", 1, "-B <num>"));
        optVector.addElement(new Option("\tEnable entropic auto-blend setting (symbolic class only)\n", "E", 0, "-E"));
        optVector.addElement(new Option("\tSpecify the missing value treatment mode (default a)\n\tValid options are: a(verage), d(elete), m(axdiff), n(ormal)\n", "M", 1, "-M <char>"));
        optVector.addAll(Collections.list(super.listOptions()));
        return optVector.elements();
    }

    public String globalBlendTipText() {
        return "The parameter for global blending. Values are restricted to [0,100].";
    }

    public void setGlobalBlend(int b) {
        this.m_GlobalBlend = b;
        if (this.m_GlobalBlend > 100) {
            this.m_GlobalBlend = 100;
        }
        if (this.m_GlobalBlend < 0) {
            this.m_GlobalBlend = 0;
        }
    }

    public int getGlobalBlend() {
        return this.m_GlobalBlend;
    }

    public String entropicAutoBlendTipText() {
        return "Whether entropy-based blending is to be used.";
    }

    public void setEntropicAutoBlend(boolean e) {
        this.m_BlendMethod = e ? 2 : 1;
    }

    public boolean getEntropicAutoBlend() {
        return this.m_BlendMethod == 2;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String blendStr = Utils.getOption('B', options);
        if (blendStr.length() != 0) {
            this.setGlobalBlend(Integer.parseInt(blendStr));
        }
        this.setEntropicAutoBlend(Utils.getFlag('E', options));
        String missingModeStr = Utils.getOption('M', options);
        if (missingModeStr.length() != 0) {
            switch (missingModeStr.charAt(0)) {
                case 'a': {
                    this.setMissingMode(new SelectedTag(4, TAGS_MISSING));
                    break;
                }
                case 'd': {
                    this.setMissingMode(new SelectedTag(1, TAGS_MISSING));
                    break;
                }
                case 'm': {
                    this.setMissingMode(new SelectedTag(2, TAGS_MISSING));
                    break;
                }
                case 'n': {
                    this.setMissingMode(new SelectedTag(3, TAGS_MISSING));
                    break;
                }
                default: {
                    this.setMissingMode(new SelectedTag(4, TAGS_MISSING));
                }
            }
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-B");
        options.add("" + this.m_GlobalBlend);
        if (this.getEntropicAutoBlend()) {
            options.add("-E");
        }
        options.add("-M");
        if (this.m_MissingMode == 4) {
            options.add("a");
        } else if (this.m_MissingMode == 1) {
            options.add("d");
        } else if (this.m_MissingMode == 2) {
            options.add("m");
        } else if (this.m_MissingMode == 3) {
            options.add("n");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer st = new StringBuffer();
        st.append("KStar Beta Verion (0.1b).\nCopyright (c) 1995-97 by Len Trigg (trigg@cs.waikato.ac.nz).\nJava port to Weka by Abdelaziz Mahoui (am14@cs.waikato.ac.nz).\n\nKStar options : ");
        String[] ops = this.getOptions();
        for (int i = 0; i < ops.length; ++i) {
            st.append(ops[i] + ' ');
        }
        return st.toString();
    }

    public static void main(String[] argv) {
        KStar.runClassifier(new KStar(), argv);
    }

    private void init_m_Attributes() {
        try {
            this.m_NumInstances = this.m_Train.numInstances();
            this.m_NumClasses = this.m_Train.numClasses();
            this.m_NumAttributes = this.m_Train.numAttributes();
            this.m_ClassType = this.m_Train.classAttribute().type();
            this.m_InitFlag = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void update_m_Attributes() {
        this.m_NumInstances = this.m_Train.numInstances();
        this.m_InitFlag = 1;
    }

    private void generateRandomClassColomns() {
        Random generator = new Random(42L);
        this.m_RandClassCols = new int[6][];
        int[] classvals = this.classValues();
        for (int i = 0; i < 5; ++i) {
            this.m_RandClassCols[i] = this.randomize(classvals, generator);
        }
        this.m_RandClassCols[5] = classvals;
    }

    private int[] classValues() {
        int[] classval = new int[this.m_NumInstances];
        for (int i = 0; i < this.m_NumInstances; ++i) {
            try {
                classval[i] = (int)this.m_Train.instance(i).classValue();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return classval;
    }

    private int[] randomize(int[] array, Random generator) {
        int[] newArray = new int[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        for (int j = newArray.length - 1; j > 0; --j) {
            int index = (int)(generator.nextDouble() * (double)j);
            int temp = newArray[j];
            newArray[j] = newArray[index];
            newArray[index] = temp;
        }
        return newArray;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

